/*
 * Decompiled with CFR 0.152.
 */
package giovynet.devices;

import giovynet.devices.DeviceException;
import giovynet.serial.Com;

public class GIV8DAQ {
    private static int timeInquiry = 50;
    private static int attemptsIfNoResponse = 2;
    private Com com;

    public Com getCom() {
        return this.com;
    }

    public GIV8DAQ(Com com) throws DeviceException {
        this.com = com;
    }

    public void command(Channel ch, DigitalOut instruction) throws DeviceException {
        switch (ch) {
            case ch1: {
                try {
                    if (instruction == DigitalOut.set_High) {
                        this.com.sendSingleData(49);
                        break;
                    }
                    if (instruction != DigitalOut.set_Low) break;
                    this.com.sendSingleData(81);
                    break;
                }
                catch (Exception e) {
                    throw new DeviceException("CH1," + e.getMessage());
                }
            }
            case ch2: {
                try {
                    if (instruction == DigitalOut.set_High) {
                        this.com.sendSingleData(50);
                        break;
                    }
                    if (instruction != DigitalOut.set_Low) break;
                    this.com.sendSingleData(87);
                    break;
                }
                catch (Exception e) {
                    throw new DeviceException("CH2," + e.getMessage());
                }
            }
            case ch3: {
                try {
                    if (instruction == DigitalOut.set_High) {
                        this.com.sendSingleData(51);
                        break;
                    }
                    if (instruction != DigitalOut.set_Low) break;
                    this.com.sendSingleData(69);
                    break;
                }
                catch (Exception e) {
                    throw new DeviceException("CH3," + e.getMessage());
                }
            }
            case ch4: {
                try {
                    if (instruction == DigitalOut.set_High) {
                        this.com.sendSingleData(52);
                        break;
                    }
                    if (instruction != DigitalOut.set_Low) break;
                    this.com.sendSingleData(82);
                    break;
                }
                catch (Exception e) {
                    throw new DeviceException("CH4," + e.getMessage());
                }
            }
            case ch5: {
                try {
                    if (instruction == DigitalOut.set_High) {
                        this.com.sendSingleData(53);
                        break;
                    }
                    if (instruction != DigitalOut.set_Low) break;
                    this.com.sendSingleData(84);
                    break;
                }
                catch (Exception e) {
                    throw new DeviceException("CH5," + e.getMessage());
                }
            }
            case ch6: {
                try {
                    if (instruction == DigitalOut.set_High) {
                        this.com.sendSingleData(54);
                        break;
                    }
                    if (instruction != DigitalOut.set_Low) break;
                    this.com.sendSingleData(89);
                    break;
                }
                catch (Exception e) {
                    throw new DeviceException("CH6," + e.getMessage());
                }
            }
            case ch7: {
                try {
                    if (instruction == DigitalOut.set_High) {
                        this.com.sendSingleData(55);
                        break;
                    }
                    if (instruction != DigitalOut.set_Low) break;
                    this.com.sendSingleData(85);
                    break;
                }
                catch (Exception e) {
                    throw new DeviceException("CH7," + e.getMessage());
                }
            }
            case ch8: {
                try {
                    if (instruction == DigitalOut.set_High) {
                        this.com.sendSingleData(56);
                        break;
                    }
                    if (instruction != DigitalOut.set_Low) break;
                    this.com.sendSingleData(73);
                    break;
                }
                catch (Exception e) {
                    throw new DeviceException("CH8," + e.getMessage());
                }
            }
        }
    }

    public boolean command(Channel ch, DigitalInput instruction) throws DeviceException {
        String response = "";
        for (int i = 0; i < attemptsIfNoResponse; ++i) {
            switch (ch) {
                case ch1: {
                    try {
                        if (instruction != DigitalInput.get_Digital_Input) break;
                        this.com.sendSingleData(65);
                        Thread.sleep(timeInquiry);
                        response = this.com.receiveSingleString();
                        break;
                    }
                    catch (Exception e) {
                        throw new DeviceException("CH1," + e.getMessage());
                    }
                }
                case ch2: {
                    try {
                        if (instruction != DigitalInput.get_Digital_Input) break;
                        this.com.sendSingleData(83);
                        Thread.sleep(timeInquiry);
                        response = this.com.receiveSingleString();
                        break;
                    }
                    catch (Exception e) {
                        throw new DeviceException("CH2," + e.getMessage());
                    }
                }
                case ch3: {
                    try {
                        if (instruction != DigitalInput.get_Digital_Input) break;
                        this.com.sendSingleData(68);
                        Thread.sleep(timeInquiry);
                        response = this.com.receiveSingleString();
                        break;
                    }
                    catch (Exception e) {
                        throw new DeviceException("CH3," + e.getMessage());
                    }
                }
                case ch4: {
                    try {
                        if (instruction != DigitalInput.get_Digital_Input) break;
                        this.com.sendSingleData(70);
                        Thread.sleep(timeInquiry);
                        response = this.com.receiveSingleString();
                        break;
                    }
                    catch (Exception e) {
                        throw new DeviceException("CH4," + e.getMessage());
                    }
                }
                case ch5: {
                    try {
                        if (instruction != DigitalInput.get_Digital_Input) break;
                        this.com.sendSingleData(71);
                        Thread.sleep(timeInquiry);
                        response = this.com.receiveSingleString();
                        break;
                    }
                    catch (Exception e) {
                        throw new DeviceException("CH5," + e.getMessage());
                    }
                }
                case ch6: {
                    try {
                        if (instruction != DigitalInput.get_Digital_Input) break;
                        this.com.sendSingleData(72);
                        Thread.sleep(timeInquiry);
                        response = this.com.receiveSingleString();
                        break;
                    }
                    catch (Exception e) {
                        throw new DeviceException("CH6," + e.getMessage());
                    }
                }
                case ch7: {
                    try {
                        if (instruction != DigitalInput.get_Digital_Input) break;
                        this.com.sendSingleData(74);
                        Thread.sleep(timeInquiry);
                        response = this.com.receiveSingleString();
                        break;
                    }
                    catch (Exception e) {
                        throw new DeviceException("CH7," + e.getMessage());
                    }
                }
                case ch8: {
                    try {
                        if (instruction != DigitalInput.get_Digital_Input) break;
                        this.com.sendSingleData(75);
                        Thread.sleep(timeInquiry);
                        response = this.com.receiveSingleString();
                        break;
                    }
                    catch (Exception e) {
                        throw new DeviceException("CH8," + e.getMessage());
                    }
                }
            }
            if (!response.equals("1") && !response.equals("0")) break;
        }
        return response.equals("1");
    }

    public String command(Channel ch, Analog instruction) throws DeviceException {
        StringBuffer store = new StringBuffer();
        for (int i = 0; i < attemptsIfNoResponse; ++i) {
            switch (ch) {
                case ch1: {
                    int x;
                    int data;
                    try {
                        if (instruction == Analog.get_Voltage_Measurement) {
                            this.com.sendSingleData(90);
                            Thread.sleep(timeInquiry);
                            data = 0;
                            for (x = 0; x < 100 && (data = this.com.receiveSingleCharAsInteger()) != 0; ++x) {
                                store.append((char)data);
                            }
                        } else {
                            if (instruction != Analog.get_Temperature_Measurement) break;
                            this.com.sendSingleData(57);
                            Thread.sleep(timeInquiry);
                            data = 0;
                            for (x = 0; x < 100 && (data = this.com.receiveSingleCharAsInteger()) != 0; ++x) {
                                store.append((char)data);
                            }
                        }
                        break;
                    }
                    catch (Exception e) {
                        throw new DeviceException("CH1," + e.getMessage());
                    }
                }
                case ch2: {
                    int x;
                    int data;
                    try {
                        if (instruction == Analog.get_Voltage_Measurement) {
                            this.com.sendSingleData(88);
                            Thread.sleep(timeInquiry);
                            data = 0;
                            for (x = 0; x < 100 && (data = this.com.receiveSingleCharAsInteger()) != 0; ++x) {
                                store.append((char)data);
                            }
                        } else {
                            if (instruction != Analog.get_Temperature_Measurement) break;
                            this.com.sendSingleData(48);
                            Thread.sleep(timeInquiry);
                            data = 0;
                            for (x = 0; x < 100 && (data = this.com.receiveSingleCharAsInteger()) != 0; ++x) {
                                store.append((char)data);
                            }
                        }
                        break;
                    }
                    catch (Exception e) {
                        throw new DeviceException("CH2," + e.getMessage());
                    }
                }
                case ch3: {
                    int x;
                    int data;
                    try {
                        if (instruction == Analog.get_Voltage_Measurement) {
                            this.com.sendSingleData(67);
                            Thread.sleep(timeInquiry);
                            data = 0;
                            for (x = 0; x < 100 && (data = this.com.receiveSingleCharAsInteger()) != 0; ++x) {
                                store.append((char)data);
                            }
                        } else {
                            if (instruction != Analog.get_Temperature_Measurement) break;
                            this.com.sendSingleData(45);
                            Thread.sleep(timeInquiry);
                            data = 0;
                            for (x = 0; x < 100 && (data = this.com.receiveSingleCharAsInteger()) != 0; ++x) {
                                store.append((char)data);
                            }
                        }
                        break;
                    }
                    catch (Exception e) {
                        throw new DeviceException("CH3," + e.getMessage());
                    }
                }
                case ch4: {
                    int x;
                    int data;
                    try {
                        if (instruction == Analog.get_Voltage_Measurement) {
                            this.com.sendSingleData(86);
                            Thread.sleep(timeInquiry);
                            data = 0;
                            for (x = 0; x < 100 && (data = this.com.receiveSingleCharAsInteger()) != 0; ++x) {
                                store.append((char)data);
                            }
                        } else {
                            if (instruction != Analog.get_Temperature_Measurement) break;
                            this.com.sendSingleData(61);
                            Thread.sleep(timeInquiry);
                            data = 0;
                            for (x = 0; x < 100 && (data = this.com.receiveSingleCharAsInteger()) != 0; ++x) {
                                store.append((char)data);
                            }
                        }
                        break;
                    }
                    catch (Exception e) {
                        throw new DeviceException("CH4," + e.getMessage());
                    }
                }
                case ch5: {
                    int x;
                    int data;
                    try {
                        if (instruction == Analog.get_Voltage_Measurement) {
                            this.com.sendSingleData(66);
                            Thread.sleep(timeInquiry);
                            data = 0;
                            for (x = 0; x < 100 && (data = this.com.receiveSingleCharAsInteger()) != 0; ++x) {
                                store.append((char)data);
                            }
                        } else {
                            if (instruction != Analog.get_Temperature_Measurement) break;
                            this.com.sendSingleData(79);
                            Thread.sleep(timeInquiry);
                            data = 0;
                            for (x = 0; x < 100 && (data = this.com.receiveSingleCharAsInteger()) != 0; ++x) {
                                store.append((char)data);
                            }
                        }
                        break;
                    }
                    catch (Exception e) {
                        throw new DeviceException("CH5," + e.getMessage());
                    }
                }
                case ch6: {
                    int x;
                    int data;
                    try {
                        if (instruction == Analog.get_Voltage_Measurement) {
                            this.com.sendSingleData(78);
                            Thread.sleep(timeInquiry);
                            data = 0;
                            for (x = 0; x < 100 && (data = this.com.receiveSingleCharAsInteger()) != 0; ++x) {
                                store.append((char)data);
                            }
                        } else {
                            if (instruction != Analog.get_Temperature_Measurement) break;
                            this.com.sendSingleData(80);
                            Thread.sleep(timeInquiry);
                            data = 0;
                            for (x = 0; x < 100 && (data = this.com.receiveSingleCharAsInteger()) != 0; ++x) {
                                store.append((char)data);
                            }
                        }
                        break;
                    }
                    catch (Exception e) {
                        throw new DeviceException("CH6," + e.getMessage());
                    }
                }
                case ch7: {
                    int x;
                    int data;
                    try {
                        if (instruction == Analog.get_Voltage_Measurement) {
                            this.com.sendSingleData(77);
                            Thread.sleep(timeInquiry);
                            data = 0;
                            for (x = 0; x < 100 && (data = this.com.receiveSingleCharAsInteger()) != 0; ++x) {
                                store.append((char)data);
                            }
                        } else {
                            if (instruction != Analog.get_Temperature_Measurement) break;
                            this.com.sendSingleData(91);
                            Thread.sleep(timeInquiry);
                            data = 0;
                            for (x = 0; x < 100 && (data = this.com.receiveSingleCharAsInteger()) != 0; ++x) {
                                store.append((char)data);
                            }
                        }
                        break;
                    }
                    catch (Exception e) {
                        throw new DeviceException("CH7," + e.getMessage());
                    }
                }
                case ch8: {
                    int x;
                    int data;
                    try {
                        if (instruction == Analog.get_Voltage_Measurement) {
                            this.com.sendSingleData(44);
                            Thread.sleep(timeInquiry);
                            data = 0;
                            for (x = 0; x < 100 && (data = this.com.receiveSingleCharAsInteger()) != 0; ++x) {
                                store.append((char)data);
                            }
                        } else {
                            if (instruction != Analog.get_Temperature_Measurement) break;
                            this.com.sendSingleData(93);
                            Thread.sleep(timeInquiry);
                            data = 0;
                            for (x = 0; x < 100 && (data = this.com.receiveSingleCharAsInteger()) != 0; ++x) {
                                store.append((char)data);
                            }
                        }
                        break;
                    }
                    catch (Exception e) {
                        throw new DeviceException("CH8," + e.getMessage());
                    }
                }
            }
            if (store.toString().length() > 0) break;
        }
        return store.toString();
    }

    public void command(ReturnMode instruction) throws DeviceException {
        switch (instruction) {
            case set_ASCII: {
                try {
                    this.com.sendSingleData(96);
                    break;
                }
                catch (Exception e) {
                    throw new DeviceException("Return_ASCII," + e.getMessage());
                }
            }
        }
    }

    public void command(TemperaturaReadingMode instruction) throws DeviceException {
        switch (instruction) {
            case set_Celsius: {
                try {
                    this.com.sendSingleData(59);
                    break;
                }
                catch (Exception e) {
                    throw new DeviceException("Return_ASCII," + e.getMessage());
                }
            }
            case set_Fahrenheit: {
                try {
                    this.com.sendSingleData(76);
                    break;
                }
                catch (Exception e) {
                    throw new DeviceException("Return_Binary," + e.getMessage());
                }
            }
        }
    }

    public static int getAttemptsIfNoResponse() {
        return attemptsIfNoResponse;
    }

    public static void setAttemptsIfNoResponse(int attemptsIfNoResponse) {
        GIV8DAQ.attemptsIfNoResponse = attemptsIfNoResponse;
    }

    public static int getTimeInquiry() {
        return timeInquiry;
    }

    public static void setTimeInquiry(int timeInquiry) {
        GIV8DAQ.timeInquiry = timeInquiry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TemperaturaReadingMode {
        set_Fahrenheit,
        set_Celsius;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReturnMode {
        set_ASCII;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Analog {
        get_Voltage_Measurement,
        get_Temperature_Measurement;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DigitalInput {
        get_Digital_Input;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DigitalOut {
        set_High,
        set_Low;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Channel {
        ch1,
        ch2,
        ch3,
        ch4,
        ch5,
        ch6,
        ch7,
        ch8;

    }
}

