/*
 * Decompiled with CFR 0.152.
 */
package giovynet.devices;

import giovynet.devices.DeviceException;
import giovynet.devices.GIV18B20;
import giovynet.devices.GIV8DAQ;
import giovynet.nativelink.SerialPort;
import giovynet.serial.Baud;
import giovynet.serial.Com;
import giovynet.serial.Parameters;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanDevices {
    private static int timeInquiry = 500;

    public List<GIV8DAQ> findGIV8DAQ() throws DeviceException {
        try {
            ArrayList<GIV8DAQ> listGIV8DAQ = new ArrayList<GIV8DAQ>();
            Parameters parameter = new Parameters();
            parameter.setBaudRate(Baud._115200);
            SerialPort serialPort = new SerialPort();
            List<String> portsFree = serialPort.getFreeSerialPort();
            for (String free : portsFree) {
                parameter.setPort(free);
                try {
                    Com com = new Com(parameter);
                    com.sendSingleData(39);
                    Thread.sleep(timeInquiry);
                    int resp = com.receiveSingleCharAsInteger();
                    if (resp != 81) continue;
                    listGIV8DAQ.add(new GIV8DAQ(com));
                }
                catch (Exception e) {}
            }
            if (listGIV8DAQ.size() > 0) {
                return listGIV8DAQ;
            }
            throw new DeviceException("No GIV8DAQ devices detected.");
        }
        catch (Exception e) {
            throw new DeviceException(e.getMessage());
        }
    }

    public List<GIV18B20> findGIV18B20() throws DeviceException {
        try {
            ArrayList<GIV18B20> listGIV18B20 = new ArrayList<GIV18B20>();
            Parameters parameter = new Parameters();
            parameter.setBaudRate(Baud._9600);
            SerialPort serialPort = new SerialPort();
            List<String> portsFree = serialPort.getFreeSerialPort();
            for (String free : portsFree) {
                parameter.setPort(free);
                try {
                    Com com = new Com(parameter);
                    com.sendSingleData(39);
                    Thread.sleep(timeInquiry);
                    int resp = com.receiveSingleCharAsInteger();
                    if (resp != 84) continue;
                    listGIV18B20.add(new GIV18B20(com));
                }
                catch (Exception e) {}
            }
            if (listGIV18B20.size() > 0) {
                return listGIV18B20;
            }
            throw new DeviceException("No GIV18B20 devices detected.");
        }
        catch (Exception e) {
            throw new DeviceException(e.getMessage());
        }
    }

    public static int getTimeInquiry() {
        return timeInquiry;
    }

    public static void setTimeInquiry(int timeInquiry) {
        ScanDevices.timeInquiry = timeInquiry;
    }
}

