/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.plaf.synthetica.SyntheticaScrollPaneLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JYTableScrollPane
extends JScrollPane {
    private static final Logger LOG = Logger.getLogger(JYTableScrollPane.class.getName());
    private List<JViewport> subHeaders;
    private List<Component> subHeaderCorners;
    private ChangeListener synchChangeListener;

    public JYTableScrollPane() {
        this.init();
    }

    public JYTableScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        this.init();
    }

    public JYTableScrollPane(Component view) {
        super(view);
        this.init();
    }

    public JYTableScrollPane(int vsbPolicy, int hsbPolicy) {
        super(vsbPolicy, hsbPolicy);
        this.init();
    }

    private void init() {
        this.setName("JYTableScrollPane");
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setLayout((LayoutManager)((Object)new JYTableScrollPaneLayout()));
    }

    public void addColumnSubHeaderView(Component view, Component corner) {
        List<Component> subHeaders = this.getColumnSubHeaderViews();
        JViewport viewport = this.createViewport();
        viewport.setView(view);
        this.getColumnSubHeaderList().add(viewport);
        this.add((Component)viewport, "COLUMN_SUBHEADER");
        if (corner == null) {
            corner = this.createLAFCorner();
        }
        if (corner == null) {
            corner = this.createStandIn();
        }
        this.getCornerList().add(corner);
        this.add(corner, "COLUMN_SUBHEADER_CORNER");
        this.firePropertyChange("columnSubHeaderViews", subHeaders, this.getColumnSubHeaderViews());
        this.revalidate();
        this.repaint();
    }

    private Component createStandIn() {
        JPanel comp = new JPanel();
        ((Component)comp).setVisible(false);
        return comp;
    }

    private Component createLAFCorner() {
        Object componentClass = UIManager.get("Table.scrollPaneCornerComponent");
        if (componentClass instanceof Class) {
            try {
                return (Component)((Class)componentClass).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void removeColumnSubHeaderView(Component view) {
        JViewport parent = this.getColumnSubHeader(view);
        if (parent == null) {
            return;
        }
        List<Component> subHeaders = this.getColumnSubHeaderViews();
        int position = this.getColumnSubHeaderList().indexOf(parent);
        this.getColumnSubHeaderList().remove(parent);
        this.remove(parent);
        Component corner = this.getCornerList().remove(position);
        this.remove(corner);
        this.firePropertyChange("columnSubHeaderViews", subHeaders, this.getColumnSubHeaderViews());
        this.revalidate();
        this.repaint();
    }

    private JViewport getColumnSubHeader(Component view) {
        for (JViewport viewport : this.getColumnSubHeaderList()) {
            if (!view.equals(viewport.getView())) continue;
            return viewport;
        }
        return null;
    }

    public List<Component> getColumnSubHeaderViews() {
        ArrayList<Component> views = new ArrayList<Component>();
        int i = 0;
        while (i < this.getColumnSubHeaderCount()) {
            views.add(this.getColumnSubHeader(i).getView());
            ++i;
        }
        return views;
    }

    public int getColumnSubHeaderCount() {
        return this.getColumnSubHeaderList().size();
    }

    List<JViewport> getColumnSubHeaders() {
        return new ArrayList<JViewport>(this.getColumnSubHeaderList());
    }

    List<Component> getColumnSubHeaderCorners() {
        return new ArrayList<Component>(this.getCornerList());
    }

    private List<Component> getCornerList() {
        if (this.subHeaderCorners == null) {
            this.subHeaderCorners = new ArrayList<Component>();
        }
        return this.subHeaderCorners;
    }

    protected void viewportChanged() {
        if (this.getViewport() == null) {
            return;
        }
        int i = 0;
        while (i < this.getColumnSubHeaderCount()) {
            this.updateColumnSubHeader(this.getColumnSubHeader(i));
            ++i;
        }
    }

    protected void updateColumnSubHeader(JViewport columnSubHeader) {
        Point source = this.getViewport().getViewPosition();
        Point target = columnSubHeader.getViewPosition();
        target.x = source.x;
        columnSubHeader.setViewPosition(target);
    }

    private void installSynchChangeListener() {
        if (this.getViewport() == null) {
            return;
        }
        this.getViewport().addChangeListener(this.getSynchChangeListener());
        this.viewportChanged();
    }

    private void uninstallSynchChangeListener() {
        if (this.getViewport() == null) {
            return;
        }
        this.getViewport().removeChangeListener(this.getSynchChangeListener());
    }

    private ChangeListener getSynchChangeListener() {
        if (this.synchChangeListener == null) {
            this.synchChangeListener = this.createSynchChangeListener();
        }
        return this.synchChangeListener;
    }

    private ChangeListener createSynchChangeListener() {
        ChangeListener l = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JYTableScrollPane.this.viewportChanged();
            }
        };
        return l;
    }

    private List<JViewport> getColumnSubHeaderList() {
        if (this.subHeaders == null) {
            this.subHeaders = new ArrayList<JViewport>();
        }
        return this.subHeaders;
    }

    private JViewport getColumnSubHeader(int i) {
        return this.getColumnSubHeaderList().get(i);
    }

    @Override
    public void setViewport(JViewport viewport) {
        this.uninstallSynchChangeListener();
        super.setViewport(viewport);
        this.installSynchChangeListener();
    }

    @Override
    public ScrollPaneLayout getLayout() {
        return (ScrollPaneLayout)super.getLayout();
    }

    public static class JYTableScrollPaneLayout
    extends SyntheticaScrollPaneLayoutManager {
        public static final String COLUMN_SUBHEADER = "COLUMN_SUBHEADER";
        public static final String COLUMN_SUBHEADER_CORNER = "COLUMN_SUBHEADER_CORNER";
        private List<JViewport> subHeaders;
        private List<Component> cornerList;

        public void syncWithScrollPane(JScrollPane sp) {
            super.syncWithScrollPane(sp);
            if (sp instanceof JYTableScrollPane) {
                this.subHeaders = ((JYTableScrollPane)sp).getColumnSubHeaders();
                this.cornerList = ((JYTableScrollPane)sp).getColumnSubHeaderCorners();
            }
        }

        public void addLayoutComponent(String s, Component c) {
            if (COLUMN_SUBHEADER.equals(s)) {
                this.getColumnSubHeaderList().add((JViewport)c);
            } else if (COLUMN_SUBHEADER_CORNER.equals(s)) {
                this.getCornerList().add(c);
            } else {
                super.addLayoutComponent(s, c);
            }
        }

        public void removeLayoutComponent(Component c) {
            if (this.getColumnSubHeaderList().remove(c)) {
                return;
            }
            if (this.getCornerList().remove(c)) {
                return;
            }
            super.removeLayoutComponent(c);
        }

        public void layoutContainer(Container parent) {
            Point beforePosition = this.viewport.getViewPosition();
            super.layoutContainer(parent);
            Rectangle viewRect = this.getBounds(this.viewport);
            Rectangle vsbBounds = this.getBounds(this.vsb);
            int subHeaderHeight = 0;
            boolean ltr = parent.getComponentOrientation().isLeftToRight();
            int i = 0;
            while (i < this.getColumnSubHeaderCount()) {
                JViewport port = this.getColumnSubHeader(i);
                Component comp = this.getCorner(i);
                if (port.isVisible()) {
                    Dimension pref = port.getPreferredSize();
                    port.setBounds(viewRect.x, viewRect.y, viewRect.width, pref.height);
                    if (vsbBounds != null) {
                        comp.setBounds(ltr ? viewRect.x + viewRect.width : viewRect.x - comp.getWidth(), viewRect.y, vsbBounds.width, pref.height);
                    }
                    viewRect.y += pref.height;
                    viewRect.height -= pref.height;
                    subHeaderHeight += pref.height;
                }
                ++i;
            }
            this.viewport.setBounds(viewRect);
            this.viewport.setViewPosition(beforePosition);
            if (vsbBounds != null) {
                vsbBounds.y = viewRect.y;
                vsbBounds.height -= subHeaderHeight;
                this.vsb.setBounds(vsbBounds);
            }
        }

        private Rectangle getBounds(Container colHead) {
            if (colHead != null && colHead.isVisible()) {
                return colHead.getBounds();
            }
            return null;
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = super.minimumLayoutSize(parent);
            Dimension subHeaderMin = this.getColumnSubHeadersMinimum(parent);
            dim.width = Math.max(dim.width, subHeaderMin.width);
            dim.height += subHeaderMin.height;
            return dim;
        }

        private Dimension getColumnSubHeadersMinimum(Container parent) {
            Dimension dim = new Dimension();
            int i = 0;
            while (i < this.getColumnSubHeaderCount()) {
                if (this.getColumnSubHeader(i).getView().isVisible()) {
                    Dimension sub = this.getColumnSubHeader(i).getMinimumSize();
                    dim.height += sub.height;
                    dim.width = Math.max(dim.width, sub.width);
                }
                ++i;
            }
            return dim;
        }

        private Dimension getColumnSubHeadersPreferred(Container parent) {
            Dimension dim = new Dimension();
            int i = 0;
            while (i < this.getColumnSubHeaderCount()) {
                if (this.getColumnSubHeader(i).getView().isVisible()) {
                    Dimension sub = this.getColumnSubHeader(i).getPreferredSize();
                    dim.height += sub.height;
                    dim.width = Math.max(dim.width, sub.width);
                }
                ++i;
            }
            return dim;
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = super.preferredLayoutSize(parent);
            Dimension subHeaderPref = this.getColumnSubHeadersPreferred(parent);
            dim.height += subHeaderPref.height;
            return dim;
        }

        private List<JViewport> getColumnSubHeaderList() {
            if (this.subHeaders == null) {
                this.subHeaders = new ArrayList<JViewport>();
            }
            return this.subHeaders;
        }

        public int getColumnSubHeaderCount() {
            return this.getColumnSubHeaderList().size();
        }

        public JViewport getColumnSubHeader(int i) {
            return this.getColumnSubHeaderList().get(i);
        }

        private List<Component> getCornerList() {
            if (this.cornerList == null) {
                this.cornerList = new ArrayList<Component>();
            }
            return this.cornerList;
        }

        private Component getCorner(int i) {
            return this.getCornerList().get(i);
        }

        List<JViewport> getColumnSubHeaders() {
            return new ArrayList<JViewport>(this.getColumnSubHeaderList());
        }

        List<Component> getColumnSubHeaderCorners() {
            return new ArrayList<Component>(this.getCornerList());
        }
    }
}

