/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.filter;

import de.javasoft.swing.JYFormattedSearchField;
import de.javasoft.swing.JYFormattedTextField;
import de.javasoft.swing.JYSearchField;
import de.javasoft.swing.JYTextField;
import de.javasoft.swing.filter.Boundaries;
import de.javasoft.swing.filter.ColumnFilter;
import de.javasoft.swing.filter.ComparableRowFilterModel;
import de.javasoft.swing.filter.FilterContainer;
import de.javasoft.swing.filter.IRowFilterModel;
import de.javasoft.swing.sort.RowFilters;
import java.awt.Component;
import java.text.Format;
import java.text.NumberFormat;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.swingx.util.Contract;

public class ComparableColumnFilter<M>
extends ColumnFilter<M> {
    private static final Logger LOG = Logger.getLogger(ComparableColumnFilter.class.getName());
    private JYFormattedSearchField filterField;
    private JYFormattedTextField toField;
    private ColumnFilter.TextFieldSupport textFieldSupport;

    public ComparableColumnFilter(int columnIndex) {
        super(columnIndex);
    }

    public ComparableColumnFilter(int columnIndex, IRowFilterModel<M> filterModel) {
        super(columnIndex, filterModel);
    }

    public void setFormatter(JFormattedTextField.AbstractFormatter formatter) {
        this.setFormatterFactory(new DefaultFormatterFactory(formatter));
    }

    public void setFormatterFactory(JFormattedTextField.AbstractFormatterFactory formatter) {
        Contract.asNotNull((Object)formatter, (String)"formatter/factory must not be null");
        this.clear();
        this.getFilteringComponent();
        this.filterField.setFormatterFactory(formatter);
        this.toField.setFormatterFactory(formatter);
    }

    @Override
    protected void doRelease() {
        this.getTextFieldSupport().uninstallMatchRulePopup((JYSearchField)this.filterField);
        this.getTextFieldSupport().removeTextField((JYTextField)this.filterField);
        this.getTextFieldSupport().removeTextField((JYTextField)this.toField);
    }

    @Override
    protected void installActivated(JComponent filteringComponent) {
        this.getTextFieldSupport().installMatchRulePopup((JYSearchField)this.filterField);
        this.matchValueChanged(null, this.getRowFilterModel().getMatchValue());
    }

    @Override
    protected void matchRuleChanged(Object rule) {
        Object oldRule = this.getRowFilterModel().getMatchRule();
        super.matchRuleChanged(rule);
        this.updateMatchValueAfterMatchRuleChanged(oldRule);
    }

    protected void updateMatchValueAfterMatchRuleChanged(Object oldRule) {
        if (oldRule.getClass() != this.getRowFilterModel().getMatchRule().getClass()) {
            this.matchValueChanged();
        }
    }

    @Override
    protected void updateComponentsAfterMatchRuleChanged(Object rule) {
        Action target = this.filterField.getSearchAction();
        target.putValue("ShortDescription", this.getMatchRuleName(rule));
        this.toField.setVisible(this.unwrapMatchRule(rule) instanceof RowFilters.RangeType);
        this.getFilteringComponent().revalidate();
    }

    @Override
    protected void matchValueChanged() {
        if (this.getRowFilterModel().getMatchRule() instanceof RowFilters.RangeType) {
            this.getRowFilterModel().setMatchValue(new Boundaries(this.filterField.getValue(), this.toField.getValue()));
        } else {
            this.getRowFilterModel().setMatchValue(this.filterField.getValue());
        }
    }

    @Override
    protected void matchValueChanged(Object oldValue, Object newValue) {
        this.getFilteringComponent();
        if (newValue instanceof Boundaries) {
            Boundaries boundaries = (Boundaries)newValue;
            if (!this.areEqual(this.filterField.getValue(), boundaries.from)) {
                this.filterField.setValue(boundaries.from);
            }
            if (!this.areEqual(this.toField.getValue(), boundaries.to)) {
                this.toField.setValue(boundaries.to);
            }
        } else {
            if (this.areEqual(this.filterField.getValue(), newValue)) {
                return;
            }
            this.filterField.setValue(newValue);
        }
    }

    @Override
    protected void matchRuleChanged(Object oldValue, Object newValue) {
        this.getFilteringComponent();
        boolean selectionChanged = this.getTextFieldSupport().selectMatchRuleAction((JYSearchField)this.filterField, newValue);
        if (selectionChanged) {
            this.updateMatchValueAfterMatchRuleChanged(oldValue);
        }
    }

    @Override
    protected IRowFilterModel<? extends M> createRowFilterModel(int columnIndex) {
        return new ComparableRowFilterModel(columnIndex);
    }

    @Override
    protected JComponent createFilteringComponent() {
        this.filterField = new JYFormattedSearchField((Format)NumberFormat.getInstance());
        this.filterField.setHorizontalAlignment(4);
        this.installFilterFieldListeners((JYTextField)this.filterField);
        this.toField = new JYFormattedTextField((Format)NumberFormat.getInstance());
        this.toField.setHorizontalAlignment(4);
        this.toField.setVisible(false);
        this.installFilterFieldListeners((JYTextField)this.toField);
        FilterContainer panel = new FilterContainer();
        panel.add((Component)this.filterField, "Before");
        panel.add((Component)this.toField);
        return panel;
    }

    private void installFilterFieldListeners(JYTextField field) {
        this.getTextFieldSupport().addTextField(field);
        if (field instanceof JYSearchField) {
            Action searchAction = this.getTextFieldSupport().createSearchAction();
            ((JYSearchField)field).setSearchAction(searchAction);
        }
    }

    private ColumnFilter.TextFieldSupport getTextFieldSupport() {
        if (this.textFieldSupport == null) {
            this.textFieldSupport = new ColumnFilter.TextFieldSupport();
        }
        return this.textFieldSupport;
    }
}

