/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.filter;

import de.javasoft.swing.JYFormattedSearchField;
import de.javasoft.swing.JYSearchField;
import de.javasoft.swing.JYTextField;
import de.javasoft.swing.filter.AbstractRowFilterModel;
import de.javasoft.swing.filter.ColumnFilter;
import de.javasoft.swing.filter.IRowFilterFactory;
import de.javasoft.swing.filter.SimpleRowFilterModel;
import java.util.logging.Logger;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.swingx.util.Contract;

public class SimpleColumnFilter<M>
extends ColumnFilter<M> {
    private static final Logger LOG = Logger.getLogger(SimpleColumnFilter.class.getName());
    private ColumnFilter.TextFieldSupport textFieldSupport;

    public SimpleColumnFilter(int columnIndex) {
        this(columnIndex, (IRowFilterFactory<M>)null);
    }

    public SimpleColumnFilter(int columnIndex, IRowFilterFactory<? super M> factory) {
        super(columnIndex);
        this.setRowFilterFactory(factory);
    }

    public void setFormatter(JFormattedTextField.AbstractFormatter formatter) {
        this.setFormatterFactory(new DefaultFormatterFactory(formatter));
    }

    public void setFormatterFactory(JFormattedTextField.AbstractFormatterFactory formatter) {
        Contract.asNotNull((Object)formatter, (String)"formatter/factory must not be null");
        this.clear();
        this.getFilteringComponent().setFormatterFactory(formatter);
    }

    public void setRowFilterFactory(IRowFilterFactory<? super M> factory) {
        ((SimpleRowFilterModel)this.getRowFilterModel()).setRowFilterFactory(factory);
    }

    @Override
    protected SimpleRowFilterModel<? extends M> createRowFilterModel(int columnIndex) {
        return new SimpleRowFilterModel(columnIndex);
    }

    @Override
    public SimpleRowFilterModel<? extends M> getRowFilterModel() {
        return (SimpleRowFilterModel)super.getRowFilterModel();
    }

    public JYSearchField getFilteringComponent() {
        return (JYSearchField)super.getFilteringComponent();
    }

    @Override
    protected void doRelease() {
        this.uninstallFilterFieldListeners(this.getFilteringComponent());
    }

    @Override
    protected void matchValueChanged() {
        ((AbstractRowFilterModel)this.getRowFilterModel()).setMatchValue(this.getFilteringComponent().getValue());
    }

    @Override
    protected void matchValueChanged(Object oldValue, Object newValue) {
        if (this.areEqual(this.getFilteringComponent().getValue(), newValue)) {
            return;
        }
        this.getFilteringComponent().setValue(newValue);
    }

    protected JYSearchField createFilteringComponent() {
        JYFormattedSearchField field = new JYFormattedSearchField((Object)"");
        this.installFilterFieldListeners((JYSearchField)field);
        return field;
    }

    private void installFilterFieldListeners(JYSearchField field) {
        this.getTextFieldSupport().addTextField((JYTextField)field);
        field.setSearchAction(this.getTextFieldSupport().createSearchAction());
    }

    private void uninstallFilterFieldListeners(JYSearchField field) {
        this.getTextFieldSupport().removeTextField((JYTextField)field);
    }

    protected ColumnFilter.TextFieldSupport getTextFieldSupport() {
        if (this.textFieldSupport == null) {
            this.textFieldSupport = new ColumnFilter.TextFieldSupport();
        }
        return this.textFieldSupport;
    }
}

