/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.catalog.source;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.jensoft.core.catalog.source.SourceScrollPane;
import org.jensoft.core.catalog.styles.SectionStyle;
import org.jensoft.core.catalog.styles.SourceStyle;
import org.jensoft.core.catalog.styles.WordStyle;
import org.jensoft.core.palette.color.RosePalette;
import org.jensoft.core.palette.color.TangoPalette;

public class JavaSourcePane
extends JComponent {
    private static final long serialVersionUID = 3845341077628968936L;
    private DefaultStyledDocument styledDocument;
    private JTextPane sourceTextPane;
    private StyleContext styleContext;

    public JavaSourcePane() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.createStyle();
        this.styledDocument = new DefaultStyledDocument(this.styleContext);
        this.sourceTextPane = new JTextPane(this.styledDocument){
            private static final long serialVersionUID = -1726266447933631743L;

            @Override
            public Insets getInsets() {
                return new Insets(10, 10, 10, 10);
            }
        };
        this.sourceTextPane.setOpaque(false);
        this.sourceTextPane.setMargin(new Insets(10, 10, 10, 10));
        this.sourceTextPane.setEditable(false);
        SourceScrollPane scroll = new SourceScrollPane(this.sourceTextPane);
        scroll.setWheelScrollingEnabled(true);
        this.add((Component)scroll, "Center");
    }

    private void createStyle() {
        this.styleContext = new StyleContext();
        Style javaSourceStyle = this.styleContext.addStyle("java-source", null);
        StyleConstants.setLeftIndent(javaSourceStyle, 60.0f);
        StyleConstants.setRightIndent(javaSourceStyle, 16.0f);
        StyleConstants.setFirstLineIndent(javaSourceStyle, 60.0f);
        StyleConstants.setFontFamily(javaSourceStyle, "lucida console");
        StyleConstants.setFontSize(javaSourceStyle, 11);
        StyleConstants.setForeground(javaSourceStyle, TangoPalette.ALUMINIUM6);
        Style wordJavaStyle = this.styleContext.addStyle("java-modifier", null);
        StyleConstants.setFontFamily(wordJavaStyle, "lucida console");
        StyleConstants.setFontSize(wordJavaStyle, 11);
        StyleConstants.setForeground(wordJavaStyle, RosePalette.COALBLACK);
        StyleConstants.setBold(wordJavaStyle, true);
        Style wordJavaComment = this.styleContext.addStyle("java-comment1", null);
        StyleConstants.setFontFamily(wordJavaComment, "lucida console");
        StyleConstants.setFontSize(wordJavaComment, 11);
        StyleConstants.setForeground(wordJavaComment, RosePalette.CORALRED);
        Style wordJavaComment2 = this.styleContext.addStyle("java-comment2", null);
        StyleConstants.setFontFamily(wordJavaComment2, "lucida console");
        StyleConstants.setFontSize(wordJavaComment2, 11);
        StyleConstants.setForeground(wordJavaComment2, new Color(63, 127, 95));
        StyleConstants.setForeground(wordJavaComment2, RosePalette.COBALT);
        Style wordJavaComment3 = this.styleContext.addStyle("java-comment3", null);
        StyleConstants.setFontFamily(wordJavaComment3, "lucida console");
        StyleConstants.setFontSize(wordJavaComment3, 11);
        StyleConstants.setForeground(wordJavaComment3, new Color(63, 127, 95));
        StyleConstants.setForeground(wordJavaComment3, TangoPalette.ALUMINIUM2);
        Style stringStyle = this.styleContext.addStyle("java-string", null);
        StyleConstants.setFontFamily(stringStyle, "lucida console");
        StyleConstants.setFontSize(stringStyle, 11);
        StyleConstants.setForeground(stringStyle, new Color(63, 127, 95));
        StyleConstants.setForeground(stringStyle, TangoPalette.ORANGE1);
        Style wordJavaAnnotation = this.styleContext.addStyle("java-annotation", null);
        StyleConstants.setFontFamily(wordJavaAnnotation, "lucida console");
        StyleConstants.setFontSize(wordJavaAnnotation, 11);
        StyleConstants.setForeground(wordJavaAnnotation, TangoPalette.BUTTER1);
    }

    private void applyStyles() {
        SourceStyle uijavaStyle = new SourceStyle(this.sourceTextPane, this.styledDocument.getStyle("java-source"));
        uijavaStyle.apply();
        WordStyle uiworldStyle = new WordStyle(this.sourceTextPane, this.styledDocument.getStyle("java-modifier"), " new ", " super", "\tsuper", " private ", "\nprivate ", "\tprivate ", " void ", "\nvoid ", "\npublic ", " public ", "\tpublic ", " class ", "\nclass ", "\npackage ", "\tpackage ", " package ", "\nimport ", "\timport ", " import ", " extends ", " return ", "\nreturn ", "\treturn ", "\nfinal ", " final ", "\nfloat ", " float ", "\ndouble ", " double ", "\nint ", " int ", "\nlong ", " long ", "\nshort ", " short ");
        uiworldStyle.apply();
        SectionStyle uicommentStyle1 = new SectionStyle(this.sourceTextPane, "/**", "*/", this.styledDocument.getStyle("java-comment2"));
        SectionStyle uicommentStyle2 = new SectionStyle(this.sourceTextPane, "/*", "*/", this.styledDocument.getStyle("java-comment1"));
        SectionStyle uicommentStyle3 = new SectionStyle(this.sourceTextPane, "//", "\n", this.styledDocument.getStyle("java-comment3"));
        SectionStyle uistringStyleSection = new SectionStyle(this.sourceTextPane, "\"", "\"", this.styledDocument.getStyle("java-string"));
        uistringStyleSection.apply();
        uicommentStyle3.apply();
        uicommentStyle2.apply();
        uicommentStyle1.apply();
        WordStyle uiannotationStyle = new WordStyle(this.sourceTextPane, this.styledDocument.getStyle("java-annotation"), "@JenSoftAPIDemo", "@Generated", "@FrameUI", "@AppletUI", "@JensoftView", "@JensoftDashboard", "@Override", "@Portfolio");
        uiannotationStyle.apply();
    }

    public void loadSource(Class source) {
        String inputSourceName = "NA";
        try {
            ClassLoader cloader = source.getClassLoader();
            String packageName = source.getPackage().getName();
            inputSourceName = packageName.replace('.', '/') + "/" + source.getSimpleName() + ".java";
            InputStream is = cloader.getResourceAsStream(inputSourceName);
            InputStreamReader isreader = new InputStreamReader(is);
            BufferedReader in = new BufferedReader(isreader);
            String line = null;
            while ((line = in.readLine()) != null) {
                try {
                    this.styledDocument.insertString(this.styledDocument.getLength(), line + "\n", this.styledDocument.getStyle("java-default"));
                }
                catch (Exception e) {}
            }
            this.applyStyles();
            this.sourceTextPane.setCaretPosition(0);
        }
        catch (Exception e) {
            System.err.println("JenSoft API - Load source of demo failed " + inputSourceName);
        }
    }
}

