/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.catalog.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jensoft.core.catalog.component.DemoTab;
import org.jensoft.core.catalog.component.DemoTabSet;
import org.jensoft.core.catalog.nature.JenSoftDashboard;
import org.jensoft.core.catalog.source.JavaSourcePane;
import org.jensoft.core.catalog.ui.Dashboard;
import org.jensoft.core.catalog.ui.ImageResource;
import org.jensoft.core.palette.color.JennyPalette;
import org.jensoft.core.view.View;

public class DashboardFrameUI
extends JFrame {
    private static final long serialVersionUID = 984563357638775171L;
    private Dashboard dashboard;

    public DashboardFrameUI(Dashboard demo) {
        this.dashboard = demo;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DashboardFrameUI.this.create();
            }
        });
        this.pack();
        this.setSize(1024, 700);
    }

    public static void main(String[] args) {
        try {
            Class<?> viewClass = Class.forName(args[0]);
            Dashboard d = (Dashboard)viewClass.newInstance();
            DashboardFrameUI dashboardFrameUI = new DashboardFrameUI(d);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void create() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        ImageIcon iconFrame = ImageResource.getInstance().createImageIcon("jensoft.png", "");
        this.setIconImage(iconFrame.getImage());
        this.setTitle("JenSoft Demo");
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        this.setDefaultCloseOperation(3);
        JPanel masterPane = new JPanel();
        masterPane.setBackground(Color.BLACK);
        masterPane.setBorder(BorderFactory.createEmptyBorder(50, 50, 50, 50));
        masterPane.setLayout(new BorderLayout());
        DemoTabSet tabSet = new DemoTabSet();
        tabSet.setTitle("JenSoft");
        DemoTab demoTab = new DemoTab("Demo");
        demoTab.setTabColor(Color.DARK_GRAY);
        ImageIcon icon1 = ImageResource.getInstance().createImageIcon("demo.png", "");
        demoTab.setTabIcon(icon1);
        tabSet.addComandTab(demoTab, this.dashboard);
        DemoTab dashboardTab = new DemoTab("Dashboard");
        dashboardTab.setTabColor(JennyPalette.JENNY6);
        ImageIcon icon = ImageResource.getInstance().createImageIcon("source.png", "");
        dashboardTab.setTabIcon(icon);
        JavaSourcePane dashboardSourcePane = new JavaSourcePane();
        tabSet.addComandTab(dashboardTab, dashboardSourcePane);
        dashboardSourcePane.loadSource(this.dashboard.getClass());
        if (this.dashboard.getClass().isAnnotationPresent(JenSoftDashboard.class)) {
            JenSoftDashboard dashboardAnnotation = this.dashboard.getClass().getAnnotation(JenSoftDashboard.class);
            Class[] views = dashboardAnnotation.views();
            for (int i = 0; i < views.length; ++i) {
                if (!View.class.isAssignableFrom(views[i])) continue;
                DemoTab viewContributorTab = new DemoTab(views[i].getSimpleName());
                viewContributorTab.setTabColor(JennyPalette.JENNY6);
                ImageIcon vIcon = ImageResource.getInstance().createImageIcon("source.png", "");
                viewContributorTab.setTabIcon(vIcon);
                JavaSourcePane viewSourcePane = new JavaSourcePane();
                tabSet.addComandTab(viewContributorTab, viewSourcePane);
                viewSourcePane.loadSource(views[i]);
            }
        }
        demoTab.setSelected(true);
        masterPane.add((Component)tabSet, "Center");
        this.getContentPane().add((Component)masterPane, "Center");
        this.setVisible(true);
    }
}

