/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.catalog.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jensoft.core.catalog.component.DemoTab;
import org.jensoft.core.catalog.component.DemoTabSet;
import org.jensoft.core.catalog.source.JavaSourcePane;
import org.jensoft.core.catalog.ui.ImageResource;
import org.jensoft.core.palette.color.JennyPalette;
import org.jensoft.core.view.View;

public class ViewAppletUI
extends JApplet {
    private static final long serialVersionUID = -7872212203014369306L;
    private String inset;
    private String drawOutline;
    private String cornerRadius;
    private String className;

    @Override
    public void init() {
        this.inset = this.getParameter("inset");
        this.drawOutline = this.getParameter("drawOutline");
        this.cornerRadius = this.getParameter("cornerRadius");
        this.className = this.getParameter("viewName");
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ViewAppletUI.this.create();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Applet UI didn't successfully complete : " + e.getMessage());
        }
    }

    private void create() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel masterPane = new JPanel();
        masterPane.setBackground(Color.WHITE);
        masterPane.setBorder(BorderFactory.createEmptyBorder(50, 50, 50, 50));
        masterPane.setLayout(new BorderLayout());
        try {
            StringTokenizer tokenizer = new StringTokenizer(this.inset, ",");
            masterPane.setBorder(BorderFactory.createEmptyBorder(Integer.parseInt(tokenizer.nextToken()), Integer.parseInt(tokenizer.nextToken()), Integer.parseInt(tokenizer.nextToken()), Integer.parseInt(tokenizer.nextToken())));
        }
        catch (Throwable e) {
            masterPane.setBorder(BorderFactory.createEmptyBorder(50, 50, 50, 50));
        }
        DemoTabSet tabSet = new DemoTabSet();
        tabSet.setTitle("JenSoft");
        tabSet.setTitle("JenSoft - API");
        if (this.cornerRadius != null) {
            tabSet.setCornerRadius(Integer.parseInt(this.cornerRadius));
        }
        if (this.drawOutline != null) {
            tabSet.setDrawOutline(Boolean.parseBoolean(this.drawOutline));
        }
        DemoTab demoTab = new DemoTab("Demo");
        demoTab.setTabColor(Color.DARK_GRAY);
        ImageIcon icon1 = ImageResource.getInstance().createImageIcon("demo.png", "");
        demoTab.setTabIcon(icon1);
        View view = null;
        try {
            Class<?> viewClass = Class.forName(this.className);
            view = (View)viewClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        tabSet.addComandTab(demoTab, view);
        DemoTab viewSourceTab = new DemoTab("View");
        viewSourceTab.setTabColor(JennyPalette.JENNY6);
        ImageIcon icon = ImageResource.getInstance().createImageIcon("source.png", "");
        viewSourceTab.setTabIcon(icon);
        JavaSourcePane viewSourcePane = new JavaSourcePane();
        tabSet.addComandTab(viewSourceTab, viewSourcePane);
        viewSourcePane.loadSource(view.getClass());
        demoTab.setSelected(true);
        masterPane.add((Component)tabSet, "Center");
        this.getContentPane().add((Component)masterPane, "Center");
        this.setVisible(true);
    }
}

