/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.catalog.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jensoft.core.catalog.component.DemoTab;
import org.jensoft.core.catalog.component.DemoTabSet;
import org.jensoft.core.catalog.source.JavaSourcePane;
import org.jensoft.core.catalog.source.X2DSourcePane;
import org.jensoft.core.catalog.ui.ImageResource;
import org.jensoft.core.palette.color.JennyPalette;
import org.jensoft.core.palette.color.RosePalette;
import org.jensoft.core.x2d.X2D;
import org.jensoft.core.x2d.X2DException;

public abstract class X2DAppletUI
extends JApplet {
    private static final long serialVersionUID = 8128875887813664194L;
    private String inset;
    private String drawOutline;
    private String cornerRadius;

    @Override
    public void init() {
        this.inset = this.getParameter("inset");
        this.drawOutline = this.getParameter("drawOutline");
        this.cornerRadius = this.getParameter("cornerRadius");
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    X2DAppletUI.this.create();
                }
            });
        }
        catch (Exception e) {
            System.err.println("Applet UI didn't successfully complete, " + e.getMessage());
        }
    }

    public abstract String getX2DResourcePath() throws X2DException;

    private void create() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel masterPane = new JPanel();
        masterPane.setBackground(Color.WHITE);
        try {
            StringTokenizer tokenizer = new StringTokenizer(this.inset, ",");
            masterPane.setBorder(BorderFactory.createEmptyBorder(Integer.parseInt(tokenizer.nextToken()), Integer.parseInt(tokenizer.nextToken()), Integer.parseInt(tokenizer.nextToken()), Integer.parseInt(tokenizer.nextToken())));
        }
        catch (Throwable e) {
            masterPane.setBorder(BorderFactory.createEmptyBorder(50, 50, 50, 50));
        }
        masterPane.setLayout(new BorderLayout());
        DemoTabSet tabSet = new DemoTabSet();
        tabSet.setTitle("JenSoft - API");
        if (this.cornerRadius != null) {
            tabSet.setCornerRadius(Integer.parseInt(this.cornerRadius));
        }
        if (this.drawOutline != null) {
            tabSet.setDrawOutline(Boolean.parseBoolean(this.drawOutline));
        }
        DemoTab demoTab = new DemoTab("Demo");
        demoTab.setTabColor(Color.DARK_GRAY);
        ImageIcon icon1 = ImageResource.getInstance().createImageIcon("demo.png", "");
        demoTab.setTabIcon(icon1);
        DemoTab sourceTab = new DemoTab("X2D");
        sourceTab.setTabColor(JennyPalette.JENNY6);
        ImageIcon icon = ImageResource.getInstance().createImageIcon("source.png", "");
        sourceTab.setTabIcon(icon);
        DemoTab uisourceTab = new DemoTab("Applet UI");
        uisourceTab.setTabColor(RosePalette.EMERALD);
        ImageIcon icon2 = ImageResource.getInstance().createImageIcon("source.png", "");
        uisourceTab.setTabIcon(icon2);
        JavaSourcePane uiSourcePane = new JavaSourcePane();
        tabSet.addComandTab(uisourceTab, uiSourcePane);
        X2DSourcePane x2dSourcePane = new X2DSourcePane();
        tabSet.addComandTab(sourceTab, x2dSourcePane);
        uiSourcePane.loadSource(this.getClass());
        demoTab.setSelected(true);
        masterPane.add((Component)tabSet, "Center");
        this.getContentPane().add((Component)masterPane, "Center");
        this.setVisible(true);
    }

    protected X2D getX2DFromClasspath(String x2dFileName) throws X2DException {
        InputStream inputStream = this.getClass().getResourceAsStream(x2dFileName);
        X2D x2d = new X2D();
        x2d.registerX2D(inputStream);
        return x2d;
    }
}

