/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.catalog.xml;

import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.jensoft.core.palette.color.RosePalette;
import org.jensoft.core.palette.color.TangoPalette;

public class XmlView
extends PlainView {
    private static HashMap<Pattern, Color> patternColors;
    private static String TAG_PATTERN;
    private static String TAG_END_PATTERN;
    private static String TAG_ATTRIBUTE_PATTERN;
    private static String TAG_XSIATTRIBUTE_PATTERN;
    private static String TAG_ATTRIBUTE_VALUE;
    private static String TAG_COMMENT;
    private static String TAG_CDATA_START;
    private static String TAG_CDATA_END;

    public XmlView(Element element) {
        super(element);
        this.getDocument().putProperty("tabSize", 4);
    }

    @Override
    protected int drawUnselectedText(Graphics graphics, int x, int y, int p0, int p1) throws BadLocationException {
        Document doc = this.getDocument();
        String text = doc.getText(p0, p1 - p0);
        Segment segment = this.getLineBuffer();
        TreeMap<Integer, Integer> startMap = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Color> colorMap = new TreeMap<Integer, Color>();
        for (Map.Entry<Pattern, Color> entry : patternColors.entrySet()) {
            Matcher matcher = entry.getKey().matcher(text);
            while (matcher.find()) {
                startMap.put(matcher.start(1), matcher.end());
                colorMap.put(matcher.start(1), entry.getValue());
            }
        }
        int i = 0;
        for (Map.Entry entry : startMap.entrySet()) {
            int start = (Integer)entry.getKey();
            int end = (Integer)entry.getValue();
            if (i < start) {
                graphics.setColor(TangoPalette.ALUMINIUM5);
                doc.getText(p0 + i, start - i, segment);
                x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, i);
            }
            graphics.setColor((Color)colorMap.get(start));
            i = end;
            doc.getText(p0 + start, i - start, segment);
            x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, start);
        }
        if (i < text.length()) {
            graphics.setColor(TangoPalette.ALUMINIUM5);
            doc.getText(p0 + i, text.length() - i, segment);
            x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, i);
        }
        return x;
    }

    static {
        TAG_PATTERN = "(</?\\w*-*\\w*-*\\w*)\\s?>?";
        TAG_END_PATTERN = "(/>)";
        TAG_ATTRIBUTE_PATTERN = "\\s(\\w*)\\=";
        TAG_XSIATTRIBUTE_PATTERN = "\\s(\\w*:\\w*)\\=";
        TAG_ATTRIBUTE_VALUE = "[a-z-]*\\=(\"[^\"]*\")";
        TAG_COMMENT = "(<!--.*-->)";
        TAG_CDATA_START = "(\\<!\\[CDATA\\[).*";
        TAG_CDATA_END = ".*(]]>)";
        patternColors = new HashMap();
        patternColors.put(Pattern.compile(TAG_CDATA_START), new Color(128, 128, 128));
        patternColors.put(Pattern.compile(TAG_CDATA_END), new Color(128, 128, 128));
        patternColors.put(Pattern.compile(TAG_PATTERN), RosePalette.COALBLACK);
        patternColors.put(Pattern.compile(TAG_ATTRIBUTE_PATTERN), new Color(127, 0, 127));
        patternColors.put(Pattern.compile(TAG_XSIATTRIBUTE_PATTERN), new Color(127, 0, 127));
        patternColors.put(Pattern.compile(TAG_END_PATTERN), RosePalette.COALBLACK);
        patternColors.put(Pattern.compile(TAG_ATTRIBUTE_VALUE), new Color(42, 0, 255));
        patternColors.put(Pattern.compile(TAG_COMMENT), RosePalette.MANDARIN);
    }
}

