/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.device;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPopupMenu;
import org.jensoft.core.device.ContextEntry;
import org.jensoft.core.device.DevicePartComponent;
import org.jensoft.core.plugin.AbstractPlugin;

public class DeviceMenuManager {
    private JPopupMenu contextMenu;
    private DevicePartComponent device2D;
    private List<AbstractPlugin> plugins;
    private Map<String, List<ContextEntry<?>>> actionRegistry;
    private List<StateContext> pluginsStateContext;
    private List<ContextEntry<?>> deviceContextEntries;

    public DeviceMenuManager(DevicePartComponent deviceComponent) {
        this.device2D = deviceComponent;
        this.contextMenu = new JPopupMenu();
        this.pluginsStateContext = new ArrayList<StateContext>();
        this.deviceContextEntries = new ArrayList();
    }

    public JPopupMenu getContextMenu() {
        return this.contextMenu;
    }

    public List<AbstractPlugin> getPlugins() {
        return this.plugins;
    }

    public StateContext getStateContext(AbstractPlugin plugin) {
        for (StateContext lctx : this.pluginsStateContext) {
            if (!lctx.plugin.equals(plugin)) continue;
            return lctx;
        }
        return null;
    }

    private void preparePluginContext() {
        if (this.plugins == null) {
            return;
        }
        for (StateContext lctx : this.pluginsStateContext) {
            lctx.active = false;
        }
        for (AbstractPlugin plugin : this.plugins) {
            StateContext lctx = this.getStateContext(plugin);
            if (lctx == null) {
                lctx = new StateContext();
                lctx.plugin = plugin;
                plugin.getContextRegistry().buildContext();
                this.pluginsStateContext.add(lctx);
            }
            lctx.active = true;
        }
        ArrayList<StateContext> inactiveContext = new ArrayList<StateContext>();
        for (StateContext lctx : this.pluginsStateContext) {
            if (lctx.active) continue;
            inactiveContext.add(lctx);
        }
        for (StateContext lctx : inactiveContext) {
            this.pluginsStateContext.remove(lctx);
        }
        inactiveContext.clear();
        inactiveContext = null;
    }

    private void mergeContext() {
        for (StateContext lctx : this.pluginsStateContext) {
            this.deviceContextEntries.addAll(lctx.plugin.getContextRegistry().getContextEntries());
        }
    }

    public boolean isActiveContext(ContextEntry<?> agc) {
        for (StateContext lctx : this.pluginsStateContext) {
            if (!lctx.plugin.equals(agc.getHost())) continue;
            return lctx.active;
        }
        return false;
    }

    public void setPlugins(List<AbstractPlugin> plugins) {
        this.plugins = plugins;
    }

    public void show(int x, int y) {
        this.preparePluginContext();
        this.mergeContext();
        this.buildContextMenu();
        this.contextMenu.show(this.device2D, x, y);
    }

    private void resolveGroup() {
        this.actionRegistry = new HashMap();
        for (ContextEntry<?> agc : this.deviceContextEntries) {
            if (!this.isActiveContext(agc)) continue;
            List<ContextEntry<?>> group = this.getGroup(agc.getGroup());
            group.add(agc);
        }
    }

    private List<ContextEntry<?>> getGroup(String group) {
        List<ContextEntry<?>> agcList = this.actionRegistry.get(group);
        if (agcList == null) {
            this.actionRegistry.put(group, new ArrayList());
        }
        return this.actionRegistry.get(group);
    }

    private void buildContextMenu() {
        this.contextMenu.removeAll();
        this.resolveGroup();
        int count = 0;
        for (Map.Entry<String, List<ContextEntry<?>>> entry : this.actionRegistry.entrySet()) {
            List<ContextEntry<?>> entryItems = entry.getValue();
            for (ContextEntry<?> agc : entryItems) {
                this.contextMenu.add(agc.getItem());
            }
            if (++count >= this.actionRegistry.size()) continue;
            this.contextMenu.addSeparator();
        }
    }

    class StateContext {
        AbstractPlugin plugin;
        boolean active;

        StateContext() {
        }
    }
}

