/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.device;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import org.jensoft.core.device.Device;
import org.jensoft.core.device.DeviceMenuManager;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.message.Message;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewEvent;
import org.jensoft.core.view.ViewListener;
import org.jensoft.core.view.ViewPart;

public class DevicePartComponent
extends JComponent
implements Device,
MouseListener,
MouseMotionListener,
MouseWheelListener,
ViewListener,
FocusListener {
    private static final long serialVersionUID = -4082926837715398005L;
    private View view;
    private DeviceMenuManager deviceMenuManager;
    private Vector<Projection> projections = new Vector();

    public DevicePartComponent() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.setFocusable(true);
        this.deviceMenuManager = new DeviceMenuManager(this);
    }

    public void removeMessage(Message message) {
        this.remove(message);
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    @Override
    public DeviceMenuManager getDeviceMenuManager() {
        return this.deviceMenuManager;
    }

    public void setDeviceMenuManager(DeviceMenuManager deviceMenuManager) {
        this.deviceMenuManager = deviceMenuManager;
    }

    private void checkPopup(MouseEvent e) {
        if (this.view.getActiveProjection() != null) {
            List<AbstractPlugin> layouts = this.view.getActiveProjection().getPluginRegistry();
            this.deviceMenuManager.setPlugins(layouts);
        }
        if (e.isPopupTrigger()) {
            this.deviceMenuManager.show(e.getX(), e.getY());
        }
    }

    @Override
    protected void paintBorder(Graphics g) {
    }

    @Override
    public int getDeviceHeight() {
        return this.getHeight();
    }

    @Override
    public int getDeviceWidth() {
        return this.getWidth();
    }

    @Override
    public int getOriginX() {
        return 0;
    }

    @Override
    public int getOriginY() {
        return 0;
    }

    @Override
    public void repaintDevice() {
        this.repaint();
    }

    @Override
    public void repaintDevice(int x, int y, int width, int height) {
        this.repaint(x, y, width, height);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        this.paintBackground(g2d);
        this.paintPlugins(g2d);
    }

    private void paintBackground(Graphics2D g2d) {
        if (!this.isOpaque()) {
            return;
        }
        if (this.getBackground() != null) {
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, this.getDeviceWidth(), this.getDeviceHeight());
        }
    }

    public void registerProjection(Projection proj) {
        this.projections.add(proj);
    }

    public void unregisterProjection(Projection proj) {
        this.projections.remove(proj);
    }

    private void paintPlugins(Graphics2D g2d) {
        List<Projection> w2ds = this.view.getProjections();
        for (Projection w2d : w2ds) {
            if (!w2d.isVisible() || w2d.equals(this.view.getActiveProjection())) continue;
            List<AbstractPlugin> plugins = w2d.getPluginRegistry();
            Collections.sort(plugins, AbstractPlugin.getPriorityComparator());
            if (plugins == null) continue;
            for (int j = 0; j < plugins.size(); ++j) {
                AbstractPlugin plugin = plugins.get(j);
                try {
                    plugin.paint(this.getView(), g2d, ViewPart.Device);
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.view.getActiveProjection() != null && this.view.getActiveProjection().isVisible()) {
            List<AbstractPlugin> plugins = this.view.getActiveProjection().getPluginRegistry();
            Collections.sort(plugins, AbstractPlugin.getPriorityComparator());
            if (plugins != null) {
                for (int j = 0; j < plugins.size(); ++j) {
                    AbstractPlugin plugin = plugins.get(j);
                    try {
                        plugin.paint(this.getView(), g2d, ViewPart.Device);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        try {
            this.view.getWidgetPlugin().paint(this.view, g2d, ViewPart.Device);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        List<AbstractPlugin> plugins;
        this.checkPopup(e);
        if (this.view.getActiveProjection() != null && (plugins = this.view.getActiveProjection().getPluginRegistry()) != null) {
            for (int j = 0; j < plugins.size(); ++j) {
                AbstractPlugin plugin = plugins.get(j);
                AbstractPlugin.OnClickListener ocl = plugin.getOnClickListener();
                if (ocl == null) continue;
                ocl.onClick(e);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        List<AbstractPlugin> plugins;
        if (this.view.getActiveProjection() != null && (plugins = this.view.getActiveProjection().getPluginRegistry()) != null) {
            for (int j = 0; j < plugins.size(); ++j) {
                AbstractPlugin plugin = plugins.get(j);
                AbstractPlugin.OnEnterListener oml = plugin.getOnEnterListener();
                if (oml == null) continue;
                oml.onEnter(e);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        List<AbstractPlugin> plugins;
        if (this.view.getActiveProjection() != null && (plugins = this.view.getActiveProjection().getPluginRegistry()) != null) {
            for (int j = 0; j < plugins.size(); ++j) {
                AbstractPlugin plugin = plugins.get(j);
                AbstractPlugin.OnExitListener oml = plugin.getOnExitListener();
                if (oml == null) continue;
                oml.onExit(e);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        List<AbstractPlugin> plugins;
        this.checkPopup(e);
        if (this.view.getActiveProjection() != null && (plugins = this.view.getActiveProjection().getPluginRegistry()) != null) {
            for (int j = 0; j < plugins.size(); ++j) {
                AbstractPlugin plugin = plugins.get(j);
                AbstractPlugin.OnPressListener oml = plugin.getOnPressListener();
                if (oml == null) continue;
                oml.onPress(e);
            }
        }
        this.view.getWidgetPlugin().getOnPressListener().onPress(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        List<AbstractPlugin> plugins;
        this.checkPopup(e);
        if (this.view.getActiveProjection() != null && (plugins = this.view.getActiveProjection().getPluginRegistry()) != null) {
            for (int j = 0; j < plugins.size(); ++j) {
                AbstractPlugin plugin = plugins.get(j);
                AbstractPlugin.OnReleaseListener oml = plugin.getOnReleaseListener();
                if (oml == null) continue;
                oml.onRelease(e);
            }
        }
        this.view.getWidgetPlugin().getOnReleaseListener().onRelease(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        List<AbstractPlugin> plugins;
        if (this.view.getActiveProjection() != null && (plugins = this.view.getActiveProjection().getPluginRegistry()) != null) {
            for (int j = 0; j < plugins.size(); ++j) {
                AbstractPlugin plugin = plugins.get(j);
                AbstractPlugin.OnDragListener oml = plugin.getOnDragListener();
                if (oml == null) continue;
                oml.onDrag(e);
            }
        }
        this.view.getWidgetPlugin().getOnDragListener().onDrag(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        List<AbstractPlugin> layouts;
        if (this.view.getActiveProjection() != null && (layouts = this.view.getActiveProjection().getPluginRegistry()) != null) {
            for (int j = 0; j < layouts.size(); ++j) {
                AbstractPlugin plugin = layouts.get(j);
                AbstractPlugin.OnMoveListener oml = plugin.getOnMoveListener();
                if (oml == null) continue;
                oml.onMove(e);
            }
        }
        this.view.getWidgetPlugin().getOnMoveListener().onMove(e);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        List<AbstractPlugin> plugins;
        if (this.view.getActiveProjection() != null && (plugins = this.view.getActiveProjection().getPluginRegistry()) != null) {
            for (int j = 0; j < plugins.size(); ++j) {
                AbstractPlugin plugin = plugins.get(j);
                AbstractPlugin.OnWheelListener oml = plugin.getOnWheelListener();
                if (oml == null) continue;
                oml.onWheel(e);
            }
        }
    }

    @Override
    public void viewProjectionSelected(ViewEvent event) {
    }

    @Override
    public void viewMoved(ViewEvent event) {
    }

    @Override
    public void viewResized(ViewEvent event) {
    }

    @Override
    public void viewHidden(ViewEvent event) {
    }

    @Override
    public void viewShown(ViewEvent event) {
    }

    @Override
    public void viewFocusGained(ViewEvent event) {
    }

    @Override
    public void viewFocusLost(ViewEvent event) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }
}

