/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.drawable.screw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.jensoft.core.drawable.Drawable;

public class Bolt
implements Drawable {
    private double x;
    private double y;
    private double btrRadius;

    public Bolt(double x, double y, double btrRadius) {
        this.x = x;
        this.y = y;
        this.btrRadius = btrRadius;
    }

    @Override
    public void draw(Graphics2D g2d) {
        Ellipse2D.Double bodyBTR = new Ellipse2D.Double(this.x - this.btrRadius, this.y - this.btrRadius, 2.0 * this.btrRadius, 2.0 * this.btrRadius);
        Area a = new Area(bodyBTR);
        Point2D.Double center = new Point2D.Double(this.x, this.y);
        double btrInternal = this.btrRadius - this.btrRadius / 3.0;
        float fraction = (float)(btrInternal / this.btrRadius);
        float[] dist0 = new float[]{0.0f, 0.8f, 0.9f, 1.0f};
        Color[] colors0 = new Color[]{Color.LIGHT_GRAY, Color.LIGHT_GRAY, Color.LIGHT_GRAY, Color.DARK_GRAY};
        RadialGradientPaint p0 = new RadialGradientPaint(center, (float)this.btrRadius, dist0, colors0, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        g2d.setPaint(p0);
        Point2D.Double start0 = new Point2D.Double(((Point2D)center).getX() - this.btrRadius, ((Point2D)center).getY());
        Point2D.Double end0 = new Point2D.Double(((Point2D)center).getX() + this.btrRadius, ((Point2D)center).getY());
        float[] dist00 = new float[]{0.0f, 0.5f, 0.7f, 1.0f};
        Color[] colors00 = new Color[]{Color.WHITE, Color.LIGHT_GRAY, Color.GRAY, Color.DARK_GRAY};
        LinearGradientPaint p00 = new LinearGradientPaint(start0, end0, dist00, colors00);
        new Color(188, 184, 183);
        g2d.setPaint(p00);
        g2d.fill(a);
        GeneralPath starMorphePath = new GeneralPath();
        GeneralPath c1 = new GeneralPath();
        GeneralPath c2 = new GeneralPath();
        GeneralPath c3 = new GeneralPath();
        GeneralPath c4 = new GeneralPath();
        double angleStar = 60.0;
        for (int i = 0; i <= 6; ++i) {
            double px = this.x + btrInternal * Math.cos(Math.toRadians(btrInternal + angleStar * (double)i));
            double py = this.y - btrInternal * Math.sin(Math.toRadians(btrInternal + angleStar * (double)i));
            if (i == 0) {
                c1.moveTo(px, py);
            }
            if (i == 2) {
                c2.moveTo(px, py);
            }
            if (i == 3) {
                c3.moveTo(px, py);
            }
            if (i == 5) {
                c4.moveTo(px, py);
            }
            if (i == 0) {
                starMorphePath.moveTo(px, py);
            }
            if (i <= 0) continue;
            starMorphePath.lineTo(px, py);
            if (i <= 2) {
                c1.lineTo(px, py);
            }
            if (i >= 2 && i <= 3) {
                c2.lineTo(px, py);
            }
            if (i >= 3) {
                c3.lineTo(px, py);
            }
            if (i < 5) continue;
            c4.lineTo(px, py);
        }
        starMorphePath.closePath();
        float[] dist1 = new float[]{0.0f, 0.2f, 1.0f};
        Color[] colors1 = new Color[]{Color.DARK_GRAY, Color.GRAY, Color.BLACK};
        RadialGradientPaint p1 = new RadialGradientPaint(center, (float)btrInternal, dist1, colors1, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        Point2D.Double start = new Point2D.Double(((Point2D)center).getX(), ((Point2D)center).getY() - this.btrRadius);
        Point2D.Double end = new Point2D.Double(((Point2D)center).getX(), ((Point2D)center).getY() + this.btrRadius);
        float[] dist = new float[]{0.0f, 0.5f, 0.7f, 1.0f};
        Color[] colors = new Color[]{Color.WHITE, Color.LIGHT_GRAY, Color.GRAY, Color.DARK_GRAY};
        LinearGradientPaint p2 = new LinearGradientPaint(start, end, dist, colors);
        g2d.setStroke(new BasicStroke(1.4f, 1, 1));
        g2d.setColor(Color.BLACK);
        g2d.draw(c1);
        g2d.setColor(Color.GRAY);
        g2d.draw(c2);
        g2d.setColor(Color.WHITE);
        g2d.draw(c3);
        g2d.setColor(Color.GRAY);
        g2d.draw(c4);
        g2d.setPaint(p2);
        g2d.fill(starMorphePath);
        g2d.setStroke(new BasicStroke(0.8f, 1, 1));
    }
}

