/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.drawable.screw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import org.jensoft.core.drawable.basic.Star;

public class Torx
extends Star {
    double torxRadius;

    public Torx(double x, double y, double radius) {
        super(x, y, 2.0 * radius / 3.0 - 2.0, radius - 2.0, 6.0);
        this.torxRadius = radius;
    }

    @Override
    public void draw(Graphics2D g2d) {
        this.createMorphe();
        Ellipse2D.Double bodyTorx = new Ellipse2D.Double(this.getX() - this.torxRadius, this.getY() - this.torxRadius, 2.0 * this.torxRadius, 2.0 * this.torxRadius);
        Shape sStar = this.getStarMorphe();
        Area a = new Area(bodyTorx);
        Area b = new Area(sStar);
        a.subtract(b);
        Point2D.Double center = new Point2D.Double(this.getX(), this.getY());
        float radius0 = (float)this.torxRadius;
        float fraction = (float)(this.getInternalRadius() / this.torxRadius);
        float[] dist0 = new float[]{fraction, 1.0f};
        Color[] colors0 = new Color[]{Color.WHITE, Color.BLACK};
        RadialGradientPaint p0 = new RadialGradientPaint(center, radius0, dist0, colors0, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        g2d.setPaint(p0);
        g2d.fill(a);
        float radius = (float)this.getExternalRadius();
        float[] dist = new float[]{0.0f, 0.2f, 1.0f};
        Color[] colors = new Color[]{Color.DARK_GRAY, Color.GRAY, Color.BLACK};
        RadialGradientPaint p = new RadialGradientPaint(center, radius, dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        g2d.setPaint(p);
        g2d.fill(b);
    }
}

