/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.glyphmetrics;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.glyphmetrics.AbstractMetricsPath;
import org.jensoft.core.glyphmetrics.GeometryPath;
import org.jensoft.core.glyphmetrics.GlyphGeometry;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.glyphmetrics.GlyphUtil;
import org.jensoft.core.glyphmetrics.Marker;
import org.jensoft.core.glyphmetrics.Side;
import org.jensoft.core.glyphmetrics.StylePosition;

public class GeneralMetricsPath
extends AbstractMetricsPath {
    private double min;
    private double max;
    private List<GlyphMetric> pmetrics;
    private List<SegmentEntry> entries;
    private boolean reverseAll = false;
    private GeometryPath geometry;
    private float lengthPathDevice;
    private double userWidth;
    private double unitUserToDevice;
    private List<GlyphMetric> volatileMetrics = new ArrayList<GlyphMetric>();

    public GeneralMetricsPath() {
        this.setProjectionNature(AbstractMetricsPath.ProjectionNature.USER);
        this.pmetrics = new ArrayList<GlyphMetric>();
        this.entries = new ArrayList<SegmentEntry>();
    }

    public void setRange(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public boolean isReverseAll() {
        return this.reverseAll;
    }

    public void setReverseAll(boolean reverseAll) {
        this.reverseAll = reverseAll;
    }

    public void lockReverseAll() {
        this.reverseAll = true;
    }

    public void unlockReverseAll() {
        this.reverseAll = false;
    }

    public void moveTo(double x, double y) {
        this.entries.add(new MoveTo(x, y));
    }

    public void lineTo(double x, double y) {
        this.entries.add(new LineTo(x, y));
    }

    public void quadTo(double cx, double cy, double x, double y) {
        this.entries.add(new QuadTo(cx, cy, x, y));
    }

    public void curveTo(double cx1, double cy1, double cx2, double cy2, double x, double y) {
        this.entries.add(new CurveTo(cx1, cy1, cx2, cy2, x, y));
    }

    public void append(Shape shape) {
        this.entries.add(new ShapeGeometry(shape));
    }

    public void resetPath() {
        this.entries.clear();
    }

    public void registerGeometrySegment(SegmentEntry entry) {
        this.entries.add(entry);
    }

    public boolean isEmpty(Shape s) {
        PathIterator pi = s.getPathIterator(null);
        while (!pi.isDone()) {
            double[] coordinates = new double[6];
            int type = pi.currentSegment(coordinates);
            if (type == 0) {
                return false;
            }
            pi.next();
        }
        return true;
    }

    @Override
    protected GeneralPath createPathMetrics() {
        GeneralPath path = new GeneralPath();
        for (SegmentEntry entry : this.entries) {
            entry.validEntry(path);
        }
        return path;
    }

    private void scalePath() {
        this.geometry = this.getOrCreateGeometry();
        this.lengthPathDevice = this.geometry.lengthOfPath();
        this.userWidth = this.max - this.min;
        this.unitUserToDevice = new Double(this.lengthPathDevice) / this.userWidth;
    }

    public void addMetric(GlyphMetric metric) {
        if (this.volatileMetrics.contains(metric)) {
            return;
        }
        this.volatileMetrics.add(metric);
    }

    public void clearMetric() {
        this.volatileMetrics.clear();
    }

    public Point2D getMetricsPoint(double metricsValue) {
        if (metricsValue < this.getMin() || metricsValue > this.getMax()) {
            throw new IllegalArgumentException("metrics value out of path range.");
        }
        this.scalePath();
        if (metricsValue == this.getMax()) {
            return this.geometry.pointAtLength(this.geometry.lengthOfPath());
        }
        double deviceLength = this.unitUserToDevice * metricsValue;
        Point2D p = this.geometry.pointAtLength((float)deviceLength);
        return p;
    }

    public Point2D getRadialPoint(double metricsValue, int radius, Side side) {
        double py;
        double px;
        this.scalePath();
        double deviceLength = this.unitUserToDevice * metricsValue;
        Point2D p = this.geometry.pointAtLength((float)deviceLength);
        float metricAngle = this.geometry.angleAtLength((float)deviceLength);
        if (side == Side.SideRight) {
            px = p.getX() - (double)radius * Math.sin(metricAngle);
            py = p.getY() + (double)radius * Math.cos(metricAngle);
        } else {
            px = p.getX() + (double)radius * Math.sin(metricAngle);
            py = p.getY() - (double)radius * Math.cos(metricAngle);
        }
        return new Point2D.Double(px, py);
    }

    public GlyphMetric solveMetrics(GlyphMetric glyphMetrics) {
        GlyphGeometry metricGlyphGeometry;
        Point2D.Double dstWest;
        Point2D.Double srcWest;
        Point2D.Double dstEast;
        Point2D.Double srcEast;
        Point2D.Double dstSouth;
        Point2D.Double srcSouth;
        Point2D.Double dstNorth;
        Point2D.Double srcNorth;
        Shape glyphTransformed;
        float angle;
        Point2D pointGlyph;
        float px;
        int j;
        this.scalePath();
        glyphMetrics.clearGlyphGeometry();
        if (this.getFontRenderContext() == null) {
            throw new NullPointerException("FontRenderContext should be supplied");
        }
        if (this.geometry.lengthOfPath() == 0.0f) {
            return glyphMetrics;
        }
        double userVal = glyphMetrics.getValue();
        double deviceLength = this.unitUserToDevice * userVal;
        glyphMetrics.setLengthOnPath(deviceLength);
        glyphMetrics.setMetricPointRef(this.geometry.pointAtLength((float)deviceLength));
        glyphMetrics.setMetricGlyphMarker(new Marker(this.geometry.pointAtLength((float)deviceLength)));
        glyphMetrics.setMetricAngle(this.geometry.angleAtLength((float)deviceLength));
        if (this.isReverseAll()) {
            glyphMetrics.setLockReverse(this.isReverseAll());
        }
        Font f = glyphMetrics.getFont();
        GlyphVector glyphVector = f.createGlyphVector(this.getFontRenderContext(), glyphMetrics.getMetricsLabel());
        if (glyphMetrics.getStylePosition() == StylePosition.Tangent) {
            AffineTransform af = new AffineTransform();
            float gvWidth = GlyphUtil.getGlyphWidth(glyphVector);
            float startLength = (float)deviceLength - gvWidth / 2.0f;
            float endLength = (float)deviceLength + gvWidth / 2.0f;
            Point2D pointStart = this.geometry.pointAtLength(startLength);
            Point2D pointEnd = this.geometry.pointAtLength(endLength);
            glyphMetrics.setPointStart(pointStart);
            glyphMetrics.setPointEnd(pointEnd);
            if (pointStart == null || pointEnd == null) {
                return glyphMetrics;
            }
            boolean needRevert = glyphMetrics.isLockReverse();
            if (this.isAutoReverseGlyph() && pointStart.getX() > pointEnd.getX()) {
                needRevert = true;
            }
            for (j = 0; j < glyphVector.getNumGlyphs(); ++j) {
                Point2D p = glyphVector.getGlyphPosition(j);
                px = (float)p.getX();
                float py = (float)p.getY();
                pointGlyph = !needRevert ? this.geometry.pointAtLength(startLength + GlyphUtil.getGlyphWidthAtToken(glyphVector, j)) : this.geometry.pointAtLength(endLength - GlyphUtil.getGlyphWidthAtToken(glyphVector, j));
                if (pointGlyph == null) continue;
                glyphMetrics.addGlyphPoint(pointGlyph);
                af.setToTranslation(pointGlyph.getX(), pointGlyph.getY());
                angle = 0.0f;
                angle = !needRevert ? this.geometry.angleAtLength(startLength + GlyphUtil.getGlyphWidthAtToken(glyphVector, j)) : this.geometry.angleAtLength(endLength - GlyphUtil.getGlyphWidthAtToken(glyphVector, j));
                if (!needRevert) {
                    af.rotate(angle);
                } else {
                    af.rotate((double)angle + Math.PI);
                }
                af.translate(-px, (double)(-py) + glyphVector.getVisualBounds().getHeight() / 2.0 - (double)glyphMetrics.getDivergence());
                Shape glyph = glyphVector.getGlyphOutline(j);
                glyphTransformed = af.createTransformedShape(glyph);
                srcNorth = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY());
                dstNorth = new Point2D.Double();
                srcSouth = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY() + glyph.getBounds2D().getHeight());
                dstSouth = new Point2D.Double();
                srcEast = new Point2D.Double(glyph.getBounds2D().getX() + glyph.getBounds2D().getWidth(), glyph.getBounds2D().getCenterY());
                dstEast = new Point2D.Double();
                srcWest = new Point2D.Double(glyph.getBounds2D().getX(), glyph.getBounds2D().getCenterY());
                dstWest = new Point2D.Double();
                af.transform(srcNorth, dstNorth);
                af.transform(srcSouth, dstSouth);
                af.transform(srcEast, dstEast);
                af.transform(srcWest, dstWest);
                metricGlyphGeometry = new GlyphGeometry(glyphTransformed, dstNorth, dstSouth, dstWest, dstEast);
                glyphMetrics.addMetricsGlyphGeometry(metricGlyphGeometry);
            }
        }
        if (glyphMetrics.getStylePosition() == StylePosition.Radial) {
            float gvWidth = GlyphUtil.getGlyphWidth(glyphVector);
            Point2D pStart = glyphMetrics.getRadialPoint(glyphMetrics.getDivergence());
            Point2D pEnd = glyphMetrics.getRadialPoint((int)((float)glyphMetrics.getDivergence() + gvWidth + 10.0f));
            if (pStart == null || pEnd == null) {
                return glyphMetrics;
            }
            Line2D.Double radialFragment = pStart.getX() > pEnd.getX() ? new Line2D.Double(pEnd.getX(), pEnd.getY(), pStart.getX(), pStart.getY()) : new Line2D.Double(pStart.getX(), pStart.getY(), pEnd.getX(), pEnd.getY());
            AffineTransform af = new AffineTransform();
            GeometryPath geometryRadialpath = new GeometryPath(radialFragment);
            for (int j2 = 0; j2 < glyphVector.getNumGlyphs(); ++j2) {
                Point2D p = glyphVector.getGlyphPosition(j2);
                float px2 = (float)p.getX();
                float py = (float)p.getY();
                Point2D pointGlyph2 = geometryRadialpath.pointAtLength(GlyphUtil.getGlyphWidthAtToken(glyphVector, j2));
                if (pointGlyph2 == null) continue;
                glyphMetrics.addGlyphPoint(pointGlyph2);
                Shape glyph = glyphVector.getGlyphOutline(j2);
                angle = geometryRadialpath.angleAtLength(GlyphUtil.getGlyphWidthAtToken(glyphVector, j2));
                af.setToTranslation(pointGlyph2.getX(), pointGlyph2.getY());
                af.rotate(angle);
                af.translate(-px2, (double)(-py) + glyphVector.getVisualBounds().getHeight() / 2.0);
                Shape glyphTransformed2 = af.createTransformedShape(glyph);
                Point2D.Double srcNorth2 = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY());
                Point2D.Double dstNorth2 = new Point2D.Double();
                Point2D.Double srcSouth2 = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY() + glyph.getBounds2D().getHeight());
                Point2D.Double dstSouth2 = new Point2D.Double();
                Point2D.Double srcEast2 = new Point2D.Double(glyph.getBounds2D().getX() + glyph.getBounds2D().getWidth(), glyph.getBounds2D().getCenterY());
                Point2D.Double dstEast2 = new Point2D.Double();
                Point2D.Double srcWest2 = new Point2D.Double(glyph.getBounds2D().getX(), glyph.getBounds2D().getCenterY());
                Point2D.Double dstWest2 = new Point2D.Double();
                af.transform(srcNorth2, dstNorth2);
                af.transform(srcSouth2, dstSouth2);
                af.transform(srcEast2, dstEast2);
                af.transform(srcWest2, dstWest2);
                GlyphGeometry metricGlyphGeometry2 = new GlyphGeometry(glyphTransformed2, dstNorth2, dstSouth2, dstWest2, dstEast2);
                glyphMetrics.addMetricsGlyphGeometry(metricGlyphGeometry2);
            }
        }
        if (glyphMetrics.getStylePosition() == StylePosition.Default) {
            float gvWidth = GlyphUtil.getGlyphWidth(glyphVector);
            Point2D pRadial = glyphMetrics.getRadialPoint(-glyphMetrics.getDivergence());
            Point2D.Double pStart = new Point2D.Double(pRadial.getX() - (double)(gvWidth / 2.0f), pRadial.getY());
            Point2D.Double pEnd = new Point2D.Double(pRadial.getX() + (double)(gvWidth / 2.0f), pRadial.getY());
            Line2D.Double l = new Line2D.Double(((Point2D)pStart).getX(), ((Point2D)pStart).getY(), ((Point2D)pEnd).getX(), ((Point2D)pEnd).getY());
            AffineTransform af = new AffineTransform();
            GeometryPath geometryRadialpath = new GeometryPath(l);
            for (j = 0; j < glyphVector.getNumGlyphs(); ++j) {
                Point2D p = glyphVector.getGlyphPosition(j);
                px = (float)p.getX();
                float py = (float)p.getY();
                pointGlyph = geometryRadialpath.pointAtLength(GlyphUtil.getGlyphWidthAtToken(glyphVector, j));
                if (pointGlyph == null) continue;
                Shape glyph = glyphVector.getGlyphOutline(j);
                float angle2 = geometryRadialpath.angleAtLength(GlyphUtil.getGlyphWidthAtToken(glyphVector, j));
                af.setToTranslation(pointGlyph.getX(), pointGlyph.getY());
                af.rotate(angle2);
                af.translate(-px, (double)(-py) + glyphVector.getVisualBounds().getHeight() / 2.0);
                glyphTransformed = af.createTransformedShape(glyph);
                srcNorth = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY());
                dstNorth = new Point2D.Double();
                srcSouth = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY() + glyph.getBounds2D().getHeight());
                dstSouth = new Point2D.Double();
                srcEast = new Point2D.Double(glyph.getBounds2D().getX() + glyph.getBounds2D().getWidth(), glyph.getBounds2D().getCenterY());
                dstEast = new Point2D.Double();
                srcWest = new Point2D.Double(glyph.getBounds2D().getX(), glyph.getBounds2D().getCenterY());
                dstWest = new Point2D.Double();
                af.transform(srcNorth, dstNorth);
                af.transform(srcSouth, dstSouth);
                af.transform(srcEast, dstEast);
                af.transform(srcWest, dstWest);
                metricGlyphGeometry = new GlyphGeometry(glyphTransformed, dstNorth, dstSouth, dstWest, dstEast);
                glyphMetrics.addMetricsGlyphGeometry(metricGlyphGeometry);
            }
        }
        return glyphMetrics;
    }

    @Override
    public List<GlyphMetric> getMetrics() {
        this.pmetrics.clear();
        this.scalePath();
        if (this.getFontRenderContext() == null) {
            throw new NullPointerException("FontRenderContext should be supplied");
        }
        if (this.geometry.lengthOfPath() == 0.0f) {
            return this.pmetrics;
        }
        for (GlyphMetric vm : this.volatileMetrics) {
            GlyphGeometry metricGlyphGeometry;
            Point2D.Double dstWest;
            Point2D.Double srcWest;
            Point2D.Double dstEast;
            Point2D.Double srcEast;
            Point2D.Double dstSouth;
            Point2D.Double srcSouth;
            Point2D.Double dstNorth;
            Point2D.Double srcNorth;
            Shape glyphTransformed;
            float angle;
            Point2D pointGlyph;
            float px;
            int j;
            if (vm.getValue() < this.getMin() || vm.getValue() > this.getMax()) {
                throw new IllegalArgumentException("metrics value out of path range :" + vm.getValue());
            }
            GlyphMetric m = new GlyphMetric();
            this.pmetrics.add(m);
            m.setValue(vm.getValue());
            double userVal = vm.getValue();
            double deviceLength = this.unitUserToDevice * userVal;
            m.setLengthOnPath(deviceLength);
            m.setMetricPointRef(this.geometry.pointAtLength((float)deviceLength));
            m.setMetricGlyphMarker(new Marker(this.geometry.pointAtLength((float)deviceLength)));
            m.setMetricAngle(this.geometry.angleAtLength((float)deviceLength));
            m.setStylePosition(vm.getStylePosition());
            m.setFont(vm.getFont());
            m.setDivergence(vm.getDivergence());
            m.setMetricsLabel(vm.getMetricsLabel());
            m.setMetricsNature(vm.getMetricsNature());
            m.setGlyphMetricDraw(vm.getGlyphMetricDraw());
            m.setGlyphMetricFill(vm.getGlyphMetricFill());
            m.setGlyphMetricEffect(vm.getGlyphMetricEffect());
            m.setGlyphMetricMarkerPainter(vm.getGlyphMetricMarkerPainter());
            m.setLockReverse(vm.isLockReverse());
            if (this.isReverseAll()) {
                m.setLockReverse(this.isReverseAll());
            }
            Font f = m.getFont();
            if (m.getMetricsLabel() == null) {
                m.setMetricsLabel(vm.getValue() + "");
            }
            GlyphVector glyphVector = f.createGlyphVector(this.getFontRenderContext(), m.getMetricsLabel());
            if (m.getStylePosition() == StylePosition.Tangent) {
                AffineTransform af = new AffineTransform();
                float gvWidth = GlyphUtil.getGlyphWidth(glyphVector);
                float startLength = (float)deviceLength - gvWidth / 2.0f;
                float endLength = (float)deviceLength + gvWidth / 2.0f;
                Point2D pointStart = this.geometry.pointAtLength(startLength);
                Point2D pointEnd = this.geometry.pointAtLength(endLength);
                m.setPointStart(pointStart);
                m.setPointEnd(pointEnd);
                if (pointStart == null || pointEnd == null) continue;
                boolean needRevert = m.isLockReverse();
                if (this.isAutoReverseGlyph() && pointStart.getX() > pointEnd.getX()) {
                    needRevert = true;
                }
                for (j = 0; j < glyphVector.getNumGlyphs(); ++j) {
                    Point2D p = glyphVector.getGlyphPosition(j);
                    px = (float)p.getX();
                    float py = (float)p.getY();
                    pointGlyph = !needRevert ? this.geometry.pointAtLength(startLength + GlyphUtil.getGlyphWidthAtToken(glyphVector, j)) : this.geometry.pointAtLength(endLength - GlyphUtil.getGlyphWidthAtToken(glyphVector, j));
                    if (pointGlyph == null) continue;
                    m.addGlyphPoint(pointGlyph);
                    af.setToTranslation(pointGlyph.getX(), pointGlyph.getY());
                    angle = 0.0f;
                    angle = !needRevert ? this.geometry.angleAtLength(startLength + GlyphUtil.getGlyphWidthAtToken(glyphVector, j)) : this.geometry.angleAtLength(endLength - GlyphUtil.getGlyphWidthAtToken(glyphVector, j));
                    if (!needRevert) {
                        af.rotate(angle);
                    } else {
                        af.rotate((double)angle + Math.PI);
                    }
                    af.translate(-px, (double)(-py) + glyphVector.getVisualBounds().getHeight() / 2.0 - (double)m.getDivergence());
                    Shape glyph = glyphVector.getGlyphOutline(j);
                    glyphTransformed = af.createTransformedShape(glyph);
                    srcNorth = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY());
                    dstNorth = new Point2D.Double();
                    srcSouth = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY() + glyph.getBounds2D().getHeight());
                    dstSouth = new Point2D.Double();
                    srcEast = new Point2D.Double(glyph.getBounds2D().getX() + glyph.getBounds2D().getWidth(), glyph.getBounds2D().getCenterY());
                    dstEast = new Point2D.Double();
                    srcWest = new Point2D.Double(glyph.getBounds2D().getX(), glyph.getBounds2D().getCenterY());
                    dstWest = new Point2D.Double();
                    af.transform(srcNorth, dstNorth);
                    af.transform(srcSouth, dstSouth);
                    af.transform(srcEast, dstEast);
                    af.transform(srcWest, dstWest);
                    metricGlyphGeometry = new GlyphGeometry(glyphTransformed, dstNorth, dstSouth, dstWest, dstEast);
                    m.addMetricsGlyphGeometry(metricGlyphGeometry);
                }
            }
            if (m.getStylePosition() == StylePosition.Radial) {
                float gvWidth = GlyphUtil.getGlyphWidth(glyphVector);
                Point2D pStart = m.getRadialPoint(m.getDivergence());
                Point2D pEnd = m.getRadialPoint((int)((float)m.getDivergence() + gvWidth + 10.0f));
                if (pStart == null || pEnd == null) continue;
                Line2D.Double radialFragment = pStart.getX() > pEnd.getX() ? new Line2D.Double(pEnd.getX(), pEnd.getY(), pStart.getX(), pStart.getY()) : new Line2D.Double(pStart.getX(), pStart.getY(), pEnd.getX(), pEnd.getY());
                AffineTransform af = new AffineTransform();
                GeometryPath geometryRadialpath = new GeometryPath(radialFragment);
                for (int j2 = 0; j2 < glyphVector.getNumGlyphs(); ++j2) {
                    Point2D p = glyphVector.getGlyphPosition(j2);
                    float px2 = (float)p.getX();
                    float py = (float)p.getY();
                    Point2D pointGlyph2 = geometryRadialpath.pointAtLength(GlyphUtil.getGlyphWidthAtToken(glyphVector, j2));
                    if (pointGlyph2 == null) continue;
                    m.addGlyphPoint(pointGlyph2);
                    Shape glyph = glyphVector.getGlyphOutline(j2);
                    angle = geometryRadialpath.angleAtLength(GlyphUtil.getGlyphWidthAtToken(glyphVector, j2));
                    af.setToTranslation(pointGlyph2.getX(), pointGlyph2.getY());
                    af.rotate(angle);
                    af.translate(-px2, (double)(-py) + glyphVector.getVisualBounds().getHeight() / 2.0);
                    Shape glyphTransformed2 = af.createTransformedShape(glyph);
                    Point2D.Double srcNorth2 = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY());
                    Point2D.Double dstNorth2 = new Point2D.Double();
                    Point2D.Double srcSouth2 = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY() + glyph.getBounds2D().getHeight());
                    Point2D.Double dstSouth2 = new Point2D.Double();
                    Point2D.Double srcEast2 = new Point2D.Double(glyph.getBounds2D().getX() + glyph.getBounds2D().getWidth(), glyph.getBounds2D().getCenterY());
                    Point2D.Double dstEast2 = new Point2D.Double();
                    Point2D.Double srcWest2 = new Point2D.Double(glyph.getBounds2D().getX(), glyph.getBounds2D().getCenterY());
                    Point2D.Double dstWest2 = new Point2D.Double();
                    af.transform(srcNorth2, dstNorth2);
                    af.transform(srcSouth2, dstSouth2);
                    af.transform(srcEast2, dstEast2);
                    af.transform(srcWest2, dstWest2);
                    GlyphGeometry metricGlyphGeometry2 = new GlyphGeometry(glyphTransformed2, dstNorth2, dstSouth2, dstWest2, dstEast2);
                    m.addMetricsGlyphGeometry(metricGlyphGeometry2);
                }
            }
            if (m.getStylePosition() != StylePosition.Default) continue;
            float gvWidth = GlyphUtil.getGlyphWidth(glyphVector);
            Point2D pRadial = m.getRadialPoint(-m.getDivergence());
            Point2D.Double pStart = new Point2D.Double(pRadial.getX() - (double)(gvWidth / 2.0f), pRadial.getY());
            Point2D.Double pEnd = new Point2D.Double(pRadial.getX() + (double)(gvWidth / 2.0f), pRadial.getY());
            Line2D.Double l = new Line2D.Double(((Point2D)pStart).getX(), ((Point2D)pStart).getY(), ((Point2D)pEnd).getX(), ((Point2D)pEnd).getY());
            AffineTransform af = new AffineTransform();
            GeometryPath geometryRadialpath = new GeometryPath(l);
            for (j = 0; j < glyphVector.getNumGlyphs(); ++j) {
                Point2D p = glyphVector.getGlyphPosition(j);
                px = (float)p.getX();
                float py = (float)p.getY();
                pointGlyph = geometryRadialpath.pointAtLength(GlyphUtil.getGlyphWidthAtToken(glyphVector, j));
                if (pointGlyph == null) continue;
                Shape glyph = glyphVector.getGlyphOutline(j);
                float angle2 = geometryRadialpath.angleAtLength(GlyphUtil.getGlyphWidthAtToken(glyphVector, j));
                af.setToTranslation(pointGlyph.getX(), pointGlyph.getY());
                af.rotate(angle2);
                af.translate(-px, (double)(-py) + glyphVector.getVisualBounds().getHeight() / 2.0);
                glyphTransformed = af.createTransformedShape(glyph);
                srcNorth = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY());
                dstNorth = new Point2D.Double();
                srcSouth = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY() + glyph.getBounds2D().getHeight());
                dstSouth = new Point2D.Double();
                srcEast = new Point2D.Double(glyph.getBounds2D().getX() + glyph.getBounds2D().getWidth(), glyph.getBounds2D().getCenterY());
                dstEast = new Point2D.Double();
                srcWest = new Point2D.Double(glyph.getBounds2D().getX(), glyph.getBounds2D().getCenterY());
                dstWest = new Point2D.Double();
                af.transform(srcNorth, dstNorth);
                af.transform(srcSouth, dstSouth);
                af.transform(srcEast, dstEast);
                af.transform(srcWest, dstWest);
                metricGlyphGeometry = new GlyphGeometry(glyphTransformed, dstNorth, dstSouth, dstWest, dstEast);
                m.addMetricsGlyphGeometry(metricGlyphGeometry);
            }
        }
        return this.pmetrics;
    }

    public class CurveTo
    extends SegmentEntry {
        double xcontrol1;
        double ycontrol1;
        double xcontrol2;
        double ycontrol2;
        double x;
        double y;

        public CurveTo(double xcontrol1, double ycontrol1, double xcontrol2, double ycontrol2, double x, double y) {
            this.xcontrol1 = xcontrol1;
            this.ycontrol1 = ycontrol1;
            this.xcontrol2 = xcontrol2;
            this.ycontrol2 = ycontrol2;
            this.x = x;
            this.y = y;
            this.setType(EntryType.SEG_CUBICTO);
        }

        @Override
        protected void validEntry(GeneralPath path) {
            if (GeneralMetricsPath.this.getProjectionNature() == AbstractMetricsPath.ProjectionNature.USER) {
                Point2D p2dDeviceControl1 = GeneralMetricsPath.this.getProjection().userToPixel(new Point2D.Double(this.xcontrol1, this.ycontrol1));
                Point2D p2dDeviceControl2 = GeneralMetricsPath.this.getProjection().userToPixel(new Point2D.Double(this.xcontrol2, this.ycontrol2));
                Point2D p2dDevice = GeneralMetricsPath.this.getProjection().userToPixel(new Point2D.Double(this.x, this.y));
                path.curveTo(p2dDeviceControl1.getX(), p2dDeviceControl1.getY(), p2dDeviceControl2.getX(), p2dDeviceControl2.getY(), p2dDevice.getX(), p2dDevice.getY());
            } else {
                path.curveTo(this.xcontrol1, this.ycontrol1, this.xcontrol2, this.ycontrol2, this.x, this.y);
            }
        }
    }

    public class QuadTo
    extends SegmentEntry {
        double xcontrol;
        double ycontrol;
        double x;
        double y;

        public QuadTo(double xcontrol, double ycontrol, double x, double y) {
            this.xcontrol = xcontrol;
            this.ycontrol = ycontrol;
            this.x = x;
            this.y = y;
            this.setType(EntryType.SEG_QUADTO);
        }

        @Override
        protected void validEntry(GeneralPath path) {
            if (GeneralMetricsPath.this.getProjectionNature() == AbstractMetricsPath.ProjectionNature.USER) {
                Point2D p2dDeviceControl = GeneralMetricsPath.this.getProjection().userToPixel(new Point2D.Double(this.xcontrol, this.ycontrol));
                Point2D p2dDevice = GeneralMetricsPath.this.getProjection().userToPixel(new Point2D.Double(this.x, this.y));
                path.quadTo(p2dDeviceControl.getX(), p2dDeviceControl.getY(), p2dDevice.getX(), p2dDevice.getY());
            } else {
                path.quadTo(this.xcontrol, this.ycontrol, this.x, this.y);
            }
        }
    }

    public class LineTo
    extends SegmentEntry {
        double x;
        double y;

        public LineTo(double x, double y) {
            this.x = x;
            this.y = y;
            this.setType(EntryType.SEG_LINETO);
        }

        @Override
        protected void validEntry(GeneralPath path) {
            if (GeneralMetricsPath.this.getProjectionNature() == AbstractMetricsPath.ProjectionNature.USER) {
                Point2D p2dDevice = GeneralMetricsPath.this.getProjection().userToPixel(new Point2D.Double(this.x, this.y));
                path.lineTo(p2dDevice.getX(), p2dDevice.getY());
            } else {
                path.lineTo(this.x, this.y);
            }
        }
    }

    public class MoveTo
    extends SegmentEntry {
        double x;
        double y;

        public MoveTo(double x, double y) {
            this.x = x;
            this.y = y;
            this.setType(EntryType.SEG_MOVETO);
        }

        @Override
        protected void validEntry(GeneralPath path) {
            if (GeneralMetricsPath.this.getProjectionNature() == AbstractMetricsPath.ProjectionNature.USER) {
                Point2D p2dDevice = GeneralMetricsPath.this.getProjection().userToPixel(new Point2D.Double(this.x, this.y));
                path.moveTo(p2dDevice.getX(), p2dDevice.getY());
            } else {
                path.moveTo(this.x, this.y);
            }
        }
    }

    public class Close
    extends SegmentEntry {
        public Close() {
            this.setType(EntryType.SEG_CLOSE);
        }

        @Override
        protected void validEntry(GeneralPath path) {
            path.closePath();
        }
    }

    public class ShapeGeometry
    extends SegmentEntry {
        private Shape shape;

        public ShapeGeometry(Shape shape) {
            if (shape == null) {
                throw new IllegalArgumentException("shape is null, shape should be supplied.");
            }
            this.shape = shape;
            this.setType(EntryType.SEG_SHAPE);
        }

        public void validCurentSegment(PathIterator pi, GeneralPath path, AbstractMetricsPath.ProjectionNature nature) {
            double[] coordinates = new double[6];
            int type = pi.currentSegment(coordinates);
            switch (type) {
                case 0: {
                    Point2D pm = null;
                    pm = GeneralMetricsPath.this.getProjectionNature() == AbstractMetricsPath.ProjectionNature.USER ? GeneralMetricsPath.this.getProjection().userToPixel(new Point2D.Double(coordinates[0], coordinates[1])) : new Point2D.Double(coordinates[0], coordinates[1]);
                    if (GeneralMetricsPath.this.isEmpty(path)) {
                        path.moveTo(pm.getX(), pm.getY());
                        break;
                    }
                    path.lineTo(pm.getX(), pm.getY());
                    break;
                }
                case 1: {
                    Point2D pl = GeneralMetricsPath.this.getProjectionNature() == AbstractMetricsPath.ProjectionNature.USER ? GeneralMetricsPath.this.getProjection().userToPixel(new Point2D.Double(coordinates[0], coordinates[1])) : new Point2D.Double(coordinates[0], coordinates[1]);
                    path.lineTo(pl.getX(), pl.getY());
                    break;
                }
                case 2: {
                    Point2D pq2;
                    Point2D pq1;
                    if (GeneralMetricsPath.this.getProjectionNature() == AbstractMetricsPath.ProjectionNature.USER) {
                        pq1 = GeneralMetricsPath.this.getProjection().userToPixel(new Point2D.Double(coordinates[0], coordinates[1]));
                        pq2 = GeneralMetricsPath.this.getProjection().userToPixel(new Point2D.Double(coordinates[2], coordinates[3]));
                    } else {
                        pq1 = new Point2D.Double(coordinates[0], coordinates[1]);
                        pq2 = new Point2D.Double(coordinates[2], coordinates[3]);
                    }
                    path.quadTo(pq1.getX(), pq1.getY(), pq2.getX(), pq2.getY());
                    break;
                }
                case 3: {
                    Point2D pc3;
                    Point2D pc2;
                    Point2D pc1;
                    if (GeneralMetricsPath.this.getProjectionNature() == AbstractMetricsPath.ProjectionNature.USER) {
                        pc1 = GeneralMetricsPath.this.getProjection().userToPixel(new Point2D.Double(coordinates[0], coordinates[1]));
                        pc2 = GeneralMetricsPath.this.getProjection().userToPixel(new Point2D.Double(coordinates[2], coordinates[3]));
                        pc3 = GeneralMetricsPath.this.getProjection().userToPixel(new Point2D.Double(coordinates[4], coordinates[5]));
                    } else {
                        pc1 = new Point2D.Double(coordinates[0], coordinates[1]);
                        pc2 = new Point2D.Double(coordinates[2], coordinates[3]);
                        pc3 = new Point2D.Double(coordinates[4], coordinates[5]);
                    }
                    path.curveTo(pc1.getX(), pc1.getY(), pc2.getX(), pc2.getY(), pc3.getX(), pc3.getY());
                    break;
                }
                case 4: {
                    path.closePath();
                    break;
                }
            }
        }

        @Override
        protected void validEntry(GeneralPath path) {
            if (this.shape == null) {
                throw new IllegalArgumentException("shape should be supplied.");
            }
            if (GeneralMetricsPath.this.getProjectionNature() == AbstractMetricsPath.ProjectionNature.DEVICE) {
                PathIterator pi = this.shape.getPathIterator(new AffineTransform());
                while (!pi.isDone()) {
                    this.validCurentSegment(pi, path, GeneralMetricsPath.this.getProjectionNature());
                    pi.next();
                }
            } else {
                PathIterator pi = this.shape.getPathIterator(new AffineTransform());
                while (!pi.isDone()) {
                    this.validCurentSegment(pi, path, GeneralMetricsPath.this.getProjectionNature());
                    pi.next();
                }
            }
        }
    }

    public abstract class SegmentEntry {
        private EntryType type;

        public EntryType getType() {
            return this.type;
        }

        public void setType(EntryType type) {
            this.type = type;
        }

        protected abstract void validEntry(GeneralPath var1);
    }

    static enum EntryType {
        SEG_MOVETO,
        SEG_LINETO,
        SEG_QUADTO,
        SEG_CUBICTO,
        SEG_CLOSE,
        SEG_SHAPE;

    }
}

