/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.glyphmetrics;

import java.awt.Font;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.glyphmetrics.GlyphGeometry;
import org.jensoft.core.glyphmetrics.GlyphMetricsNature;
import org.jensoft.core.glyphmetrics.Marker;
import org.jensoft.core.glyphmetrics.Side;
import org.jensoft.core.glyphmetrics.StylePosition;
import org.jensoft.core.glyphmetrics.painter.GlyphMetricDraw;
import org.jensoft.core.glyphmetrics.painter.GlyphMetricEffect;
import org.jensoft.core.glyphmetrics.painter.GlyphMetricFill;
import org.jensoft.core.glyphmetrics.painter.GlyphMetricMarkerPainter;
import org.jensoft.core.plugin.metrics.format.IMetricsFormat;

public class GlyphMetric {
    private double lengthOnPath;
    private double value;
    private Font font = new Font("Dialog", 0, 12);
    private StylePosition stylePosition = StylePosition.Default;
    private GlyphMetricsNature metricNature = GlyphMetricsNature.Median;
    private int divergence = 10;
    private Point2D metricPointRef;
    private float metricAngle;
    private Point2D pointStart;
    private Point2D pointEnd;
    private List<GlyphGeometry> metricsGlyphGeometry;
    private List<Point2D> glyphsPoints;
    private GlyphMetricDraw glyphMetricDraw;
    private GlyphMetricFill glyphMetricFill;
    private GlyphMetricEffect glyphMetricEffect;
    private GlyphMetricMarkerPainter glyphMetricMarkerPainter;
    private IMetricsFormat format;
    private String metricsLabel;
    private Marker metricGlyphMarker;
    private boolean lockReverse = false;
    private boolean isVisible = true;

    public Marker getMetricGlyphMarker() {
        return this.metricGlyphMarker;
    }

    public void setMetricGlyphMarker(Marker metricGlyphMarker) {
        this.metricGlyphMarker = metricGlyphMarker;
    }

    public void setLockReverse(boolean lockReverse) {
        this.lockReverse = lockReverse;
    }

    public boolean isLockReverse() {
        return this.lockReverse;
    }

    public void lockReverse() {
        this.lockReverse = true;
    }

    public void unlockReverse() {
        this.lockReverse = false;
    }

    public float getMetricAngle() {
        return this.metricAngle;
    }

    public void setMetricAngle(float metricAngle) {
        this.metricAngle = metricAngle;
    }

    public Point2D getRadialPoint(int div, Side side) {
        double py;
        double px;
        if (this.metricPointRef == null) {
            return null;
        }
        if (side == Side.SideRight) {
            px = this.metricPointRef.getX() - (double)div * Math.sin(this.metricAngle);
            py = this.metricPointRef.getY() + (double)div * Math.cos(this.metricAngle);
        } else {
            px = this.metricPointRef.getX() + (double)div * Math.sin(this.metricAngle);
            py = this.metricPointRef.getY() - (double)div * Math.cos(this.metricAngle);
        }
        return new Point2D.Double(px, py);
    }

    public Point2D getOrthoLeftPoint(int div) {
        return this.getOrthoLeftPoint(div, 0);
    }

    public Point2D getOrthoLeftPoint(int divOrtho, int divRadial) {
        if (this.metricPointRef == null) {
            return null;
        }
        double px = this.metricPointRef.getX() + (double)divRadial * Math.sin(this.metricAngle) + (double)divOrtho * Math.sin((double)this.metricAngle + 1.5707963267948966);
        double py = this.metricPointRef.getY() - (double)divRadial * Math.cos(this.metricAngle) - (double)divOrtho * Math.cos((double)this.metricAngle + 1.5707963267948966);
        return new Point2D.Double(px, py);
    }

    public Point2D getOrthoRightPoint(int divOrtho) {
        return this.getOrthoRightPoint(divOrtho, 0);
    }

    public Point2D getOrthoRightPoint(int divOrtho, int divRadial) {
        if (this.metricPointRef == null) {
            return null;
        }
        double px = this.metricPointRef.getX() + (double)divRadial * Math.sin(this.metricAngle) + (double)divOrtho * Math.sin((double)this.metricAngle - 1.5707963267948966);
        double py = this.metricPointRef.getY() - (double)divRadial * Math.cos(this.metricAngle) - (double)divOrtho * Math.cos((double)this.metricAngle - 1.5707963267948966);
        return new Point2D.Double(px, py);
    }

    public Point2D getRadialPoint(int divergence) {
        if (this.metricPointRef == null) {
            return null;
        }
        double px = this.metricPointRef.getX() + (double)divergence * Math.sin(this.metricAngle);
        double py = this.metricPointRef.getY() - (double)divergence * Math.cos(this.metricAngle);
        return new Point2D.Double(px, py);
    }

    public Point2D getMetricPointRef() {
        return this.metricPointRef;
    }

    public void setMetricPointRef(Point2D metricPointRef) {
        this.metricPointRef = metricPointRef;
    }

    public int getDivergence() {
        return this.divergence;
    }

    public void setDivergence(int divergence) {
        this.divergence = divergence;
    }

    public List<GlyphGeometry> getMetricsGlyphGeometry() {
        return this.metricsGlyphGeometry;
    }

    public void clearGlyphGeometry() {
        if (this.metricsGlyphGeometry != null) {
            this.metricsGlyphGeometry.clear();
        }
    }

    public void setMetricsGlyphGeometry(List<GlyphGeometry> metricsGlyphGeometry) {
        this.metricsGlyphGeometry = metricsGlyphGeometry;
    }

    public void addMetricsGlyphGeometry(GlyphGeometry metricGlyphGeometry) {
        if (this.metricsGlyphGeometry == null) {
            this.metricsGlyphGeometry = new ArrayList<GlyphGeometry>();
        }
        this.metricsGlyphGeometry.add(metricGlyphGeometry);
    }

    public void addGlyphPoint(Point2D glyphPoint) {
        if (this.glyphsPoints == null) {
            this.glyphsPoints = new ArrayList<Point2D>();
        }
        this.glyphsPoints.add(glyphPoint);
    }

    public List<Point2D> getGlyphsPoints() {
        return this.glyphsPoints;
    }

    public StylePosition getStylePosition() {
        return this.stylePosition;
    }

    public void setStylePosition(StylePosition style) {
        this.stylePosition = style;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public GlyphMetricsNature getMetricsNature() {
        return this.metricNature;
    }

    public void setMetricsNature(GlyphMetricsNature metricNature) {
        this.metricNature = metricNature;
    }

    public double getLengthOnPath() {
        return this.lengthOnPath;
    }

    public void setLengthOnPath(double lengthOnPath) {
        this.lengthOnPath = lengthOnPath;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public IMetricsFormat getFormat() {
        return this.format;
    }

    public void setFormat(IMetricsFormat format) {
        this.format = format;
    }

    public String getMetricsLabel() {
        return this.metricsLabel;
    }

    public void setMetricsLabel(String metricsLabel) {
        this.metricsLabel = metricsLabel;
    }

    public Point2D getPointStart() {
        return this.pointStart;
    }

    public void setPointStart(Point2D pointStart) {
        this.pointStart = pointStart;
    }

    public Point2D getPointEnd() {
        return this.pointEnd;
    }

    public void setPointEnd(Point2D pointEnd) {
        this.pointEnd = pointEnd;
    }

    public GlyphMetricDraw getGlyphMetricDraw() {
        return this.glyphMetricDraw;
    }

    public void setGlyphMetricDraw(GlyphMetricDraw glyphMetricDraw) {
        this.glyphMetricDraw = glyphMetricDraw;
    }

    public GlyphMetricFill getGlyphMetricFill() {
        return this.glyphMetricFill;
    }

    public void setGlyphMetricFill(GlyphMetricFill glyphMetricFill) {
        this.glyphMetricFill = glyphMetricFill;
    }

    public GlyphMetricEffect getGlyphMetricEffect() {
        return this.glyphMetricEffect;
    }

    public void setGlyphMetricEffect(GlyphMetricEffect glyphMetricEffect) {
        this.glyphMetricEffect = glyphMetricEffect;
    }

    public GlyphMetricMarkerPainter getGlyphMetricMarkerPainter() {
        return this.glyphMetricMarkerPainter;
    }

    public void setGlyphMetricMarkerPainter(GlyphMetricMarkerPainter glyphMetricMarkerPainter) {
        this.glyphMetricMarkerPainter = glyphMetricMarkerPainter;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }
}

