/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.glyphmetrics.painter.fill;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import org.jensoft.core.glyphmetrics.GlyphGeometry;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.glyphmetrics.painter.GlyphMetricFill;

public class GlyphDefaultFill
extends GlyphMetricFill {
    private Color fillColor;

    public GlyphDefaultFill(Color fillColor) {
        this.fillColor = fillColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    @Override
    public void paintGlyphMetricFill(Graphics2D g2d, GlyphMetric glyphMetric) {
        if (this.fillColor == null) {
            return;
        }
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        List<GlyphGeometry> glyphShapes = glyphMetric.getMetricsGlyphGeometry();
        if (glyphShapes == null) {
            return;
        }
        g2d.setStroke(new BasicStroke(1.0f));
        for (GlyphGeometry glyphShape : glyphShapes) {
            g2d.setColor(this.fillColor);
            g2d.fill(glyphShape.getGlyphShape());
        }
    }
}

