/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.glyphmetrics.painter.fill;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Point2D;
import java.util.List;
import org.jensoft.core.glyphmetrics.GlyphGeometry;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.glyphmetrics.painter.GlyphMetricFill;

public class GlyphFill
extends GlyphMetricFill {
    private Color themeColor1;
    private Color themeColor2;

    public GlyphFill(Color themeColor1, Color themeColor2) {
        this.themeColor1 = themeColor1;
        this.themeColor2 = themeColor2;
    }

    @Override
    public void paintGlyphMetricFill(Graphics2D g2d, GlyphMetric glyphMetric) {
        if (glyphMetric == null) {
            return;
        }
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2d.setStroke(new BasicStroke(1.0f));
        List<GlyphGeometry> metricsGlyphGeometry = glyphMetric.getMetricsGlyphGeometry();
        if (metricsGlyphGeometry == null) {
            return;
        }
        for (GlyphGeometry legendGlyph : metricsGlyphGeometry) {
            Point2D.Double end;
            Point2D.Double start = new Point2D.Double(legendGlyph.getNorthTransform().getX(), legendGlyph.getNorthTransform().getY());
            if (start.equals(end = new Point2D.Double(legendGlyph.getSouthTransform().getX(), legendGlyph.getSouthTransform().getY()))) continue;
            float[] dist = new float[]{0.0f, 1.0f};
            Color[] colors = new Color[]{this.themeColor1, this.themeColor2};
            LinearGradientPaint pg = new LinearGradientPaint(start, end, dist, colors);
            g2d.setPaint(pg);
            g2d.fill(legendGlyph.getGlyphShape());
        }
    }
}

