/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.layer.highway;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class Glyph {
    private String glyphText;
    private int glyphIndex;
    private Vector<Shape> glyphOutlines = new Vector();
    private boolean lock = true;
    private Area glyphAreaBound;
    private Vector<Shape> glyphBoundTransforms = new Vector();

    public Glyph(String glyphText, int glyphIndex) {
        this.glyphText = glyphText;
        this.glyphIndex = glyphIndex;
    }

    public String getGlyphText() {
        return this.glyphText;
    }

    public int getGlyphIndex() {
        return this.glyphIndex;
    }

    public boolean intersect(Glyph gi) {
        Vector<Shape> giShapes = gi.getGlyphOutlines();
        for (int i = 0; i < giShapes.size(); ++i) {
            Shape s = giShapes.get(i);
            for (int j = 0; j < this.glyphOutlines.size(); ++j) {
                if (!s.intersects(this.glyphOutlines.get(j).getBounds2D())) continue;
                return true;
            }
        }
        return false;
    }

    public void addGlyphOutline(Shape glyphCharacter) {
        this.glyphOutlines.add(glyphCharacter);
    }

    public void addGlyphTransformBound(Shape glyphBoundTransform) {
        this.glyphBoundTransforms.add(glyphBoundTransform);
    }

    public void lock() {
        this.lock = true;
    }

    public void unlock() {
        this.lock = false;
    }

    public boolean islock() {
        return this.lock;
    }

    private Area calculateBound() {
        Area area = new Area();
        for (Shape s : this.glyphBoundTransforms) {
            Area a = new Area(s);
            area.add(a);
        }
        return area;
    }

    public Area getGlyphAreaBound() {
        if (this.glyphAreaBound == null) {
            this.glyphAreaBound = this.calculateBound();
        }
        return this.glyphAreaBound;
    }

    public Vector<Shape> getGlyphOutlines() {
        return this.glyphOutlines;
    }

    public Shape getGlyphOutline(int index) {
        return this.glyphOutlines.get(index);
    }

    public Rectangle2D getGlyphBound2D() {
        double minX = this.getGlyphBound2D(0).getMinX();
        double maxX = this.getGlyphBound2D(0).getMaxX();
        double minY = this.getGlyphBound2D(0).getMinY();
        double maxY = this.getGlyphBound2D(0).getMaxY();
        for (int i = 0; i < this.glyphOutlines.size(); ++i) {
            double maxy;
            double miny;
            double maxx;
            Rectangle2D b2d = this.getGlyphBound2D(i);
            double minx = b2d.getMinX();
            if (minx < minX) {
                minX = minx;
            }
            if ((maxx = b2d.getMaxX()) > maxX) {
                maxX = maxx;
            }
            if ((miny = b2d.getMinY()) < minY) {
                minY = miny;
            }
            if (!((maxy = b2d.getMaxY()) > maxY)) continue;
            maxY = maxy;
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public Rectangle2D getGlyphBound2D(int index) {
        return this.glyphOutlines.get(index).getBounds2D();
    }

    public Vector<Shape> getGlyphBoundTransforms() {
        return this.glyphBoundTransforms;
    }

    public Shape getGlyphBoundTransform(int index) {
        return this.glyphBoundTransforms.get(index);
    }
}

