/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.layer.highway;

import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.jensoft.core.map.primitive.Node;
import org.jensoft.core.map.primitive.Primitive;
import org.jensoft.core.map.projection.GeoPosition;

public class Highway {
    private Primitive primitive;
    private int id;
    private GeneralPath highwayPath;
    private String nature;
    private String name = "";

    public Highway(int id, String nature) {
        this.id = id;
        this.nature = nature;
    }

    public Primitive getPrimitive() {
        return this.primitive;
    }

    public void setPrimitive(Primitive primitive) {
        this.primitive = primitive;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Highway) {
            Highway h = (Highway)obj;
            return h.getId() == this.id;
        }
        return false;
    }

    public boolean needToReverse() {
        if (this.primitive.getNodes() != null && this.primitive.getNodes().size() >= 2) {
            GeoPosition positionStart = this.primitive.getNodes().get(0).getGeoPosition();
            GeoPosition positionEnd = this.primitive.getNodes().get(this.primitive.getNodes().size() - 1).getGeoPosition();
            return positionStart.getLongitude() > positionEnd.getLongitude();
        }
        return false;
    }

    public void calculatePath() {
        GeneralPath path = new GeneralPath();
        Point2D ptInitial = this.primitive.getNodes().get(0).getProjection();
        path.moveTo(this.primitive.getNodes().get(0).getProjection().getX(), ptInitial.getY());
        for (Node n : this.primitive.getNodes()) {
            path.lineTo(n.getProjection().getX(), n.getProjection().getY());
        }
        this.setHighwayPath(path);
    }

    public GeneralPath getReversePath() {
        GeneralPath path = new GeneralPath();
        Point2D ptInitial = this.primitive.getNodes().get(this.primitive.getNodes().size() - 1).getProjection();
        path.moveTo(ptInitial.getX(), ptInitial.getY());
        for (int i = this.primitive.getNodes().size() - 1; i >= 0; --i) {
            Point2D pp = this.primitive.getNodes().get(i).getProjection();
            path.lineTo(pp.getX(), pp.getY());
        }
        return path;
    }

    public String getNature() {
        return this.nature;
    }

    public void setNature(String nature) {
        this.nature = nature;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GeneralPath getHighwayPath() {
        return this.highwayPath;
    }

    public void setHighwayPath(GeneralPath highwayPath) {
        this.highwayPath = highwayPath;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

