/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.layer.highway;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.jensoft.core.map.layer.highway.HighwayPath;

public class NeedleLayout {
    private GeneralPath path;
    private HighwayPath pathLength;
    private int needlePeriode = 250;
    private Color needleColor = Color.LIGHT_GRAY;

    public NeedleLayout(GeneralPath path, Color needleColor) {
        this.path = path;
        this.needleColor = needleColor;
        this.pathLength = new HighwayPath(path);
    }

    public void drawNeedle(Graphics2D g2d) {
        float lengthOfPath = this.pathLength.lengthOfPath();
        float curentLength = 10.0f;
        while (curentLength <= lengthOfPath && !((curentLength += (float)(this.needlePeriode / 2)) >= lengthOfPath - 50.0f)) {
            float angle = this.pathLength.angleAtLength(curentLength);
            Point2D p2dA = this.pathLength.pointAtLength(curentLength);
            Point2D p2dB = this.pathLength.pointAtLength(curentLength + 5.0f);
            GeneralPath needlePath = new GeneralPath();
            int deltaWidth = 1;
            needlePath.moveTo(-deltaWidth, 0.0f);
            needlePath.lineTo(-deltaWidth, -8.0f);
            needlePath.lineTo(-2 * deltaWidth, -8.0f);
            needlePath.lineTo(0.0f, -12.0f);
            needlePath.lineTo(2 * deltaWidth, -8.0f);
            needlePath.lineTo(deltaWidth, -8.0f);
            needlePath.lineTo(deltaWidth, 0.0f);
            needlePath.closePath();
            AffineTransform afTest = new AffineTransform();
            afTest.translate(50.0, 50.0);
            AffineTransform af = new AffineTransform();
            af.translate(p2dA.getX(), p2dA.getY());
            af.rotate((double)angle + 1.5707963267948966);
            Shape s = af.createTransformedShape(needlePath);
            Area a = new Area(s);
            g2d.setColor(this.needleColor);
            g2d.fill(a);
        }
    }
}

