/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.layer.highway;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jensoft.core.map.layer.highway.Glyph;
import org.jensoft.core.map.layer.highway.GlyphLayout;
import org.jensoft.core.map.layer.highway.Highway;
import org.jensoft.core.map.layer.highway.HighwayGroup;
import org.jensoft.core.map.layer.highway.HighwayNature;

public class Skelet {
    private Vector<HighwayGroup> higwaysGroup;
    private List<GlyphLayout> glyphLayouts;
    private GeneralPath skeletPath;
    private Area skeletArea;
    private Color skeletBackground = Color.WHITE;
    private FontRenderContext frc;

    public Skelet(FontRenderContext frc) {
        this.frc = frc;
        this.higwaysGroup = new Vector();
        this.glyphLayouts = new Vector<GlyphLayout>();
        this.skeletArea = new Area();
        this.skeletPath = new GeneralPath();
    }

    public Color getSkeletBackground() {
        return this.skeletBackground;
    }

    public void setSkeletBackground(Color skeletBackground) {
        this.skeletBackground = skeletBackground;
    }

    public void addHighwayGroup(HighwayGroup highwayGroup) {
        this.higwaysGroup.add(highwayGroup);
    }

    public HighwayGroup getGroup(String nature) {
        for (HighwayGroup hg : this.higwaysGroup) {
            if (!hg.getNature().equals(nature)) continue;
            return hg;
        }
        return null;
    }

    public void makeOutlineSkelet() {
        BasicStroke groupStroke;
        HighwayGroup group;
        if (this.getGroup(HighwayNature.SERVICE) != null) {
            GeneralPath serviceGroupPath = this.buildGroupPath(this.getGroup(HighwayNature.SERVICE));
            BasicStroke serviceStroke = new BasicStroke(6.0f, 1, 1);
            Shape serviceShape = serviceStroke.createStrokedShape(serviceGroupPath);
            Area serviceArea = new Area(serviceShape);
            this.skeletArea.add(serviceArea);
        }
        if (this.getGroup(HighwayNature.RESIDENTIAL) != null) {
            HighwayGroup residentialGroup = this.getGroup(HighwayNature.RESIDENTIAL);
            GeneralPath residentialGroupPath = this.buildGroupPath(residentialGroup);
            BasicStroke residentialStroke = new BasicStroke(residentialGroup.getRenderingProperties().getSkeletWidth(), 1, 1);
            Shape residentialShape = residentialStroke.createStrokedShape(residentialGroupPath);
            Area residentialArea = new Area(residentialShape);
            this.skeletArea.add(residentialArea);
        }
        if (this.getGroup(HighwayNature.UNCLASSIFIED) != null) {
            GeneralPath unclassifiedGroupPath = this.buildGroupPath(this.getGroup(HighwayNature.UNCLASSIFIED));
            BasicStroke unclassifiedStroke = new BasicStroke(14.0f, 1, 1);
            Shape unclassifiedShape = unclassifiedStroke.createStrokedShape(unclassifiedGroupPath);
            Area unclassifiedArea = new Area(unclassifiedShape);
            this.skeletArea.add(unclassifiedArea);
        }
        if (this.getGroup(HighwayNature.ROAD) != null) {
            GeneralPath roadGroupPath = this.buildGroupPath(this.getGroup(HighwayNature.ROAD));
            BasicStroke roadStroke = new BasicStroke(14.0f, 1, 1);
            Shape roadShape = roadStroke.createStrokedShape(roadGroupPath);
            Area roadArea = new Area(roadShape);
            this.skeletArea.add(roadArea);
        }
        if (this.getGroup(HighwayNature.TERTIARY) != null) {
            group = this.getGroup(HighwayNature.TERTIARY);
            GeneralPath tertiaryGroupPath = this.buildGroupPath(group);
            groupStroke = new BasicStroke(group.getRenderingProperties().getSkeletWidth(), 1, 1);
            Shape tertiaryShape = groupStroke.createStrokedShape(tertiaryGroupPath);
            Area tertiaryArea = new Area(tertiaryShape);
            this.skeletArea.add(tertiaryArea);
            GeneralPath tertiarySkelet = new GeneralPath();
            tertiarySkelet.append(tertiaryArea.getPathIterator(null), false);
            this.getGroup(HighwayNature.TERTIARY).setSkelet(tertiarySkelet);
        }
        if (this.getGroup(HighwayNature.SECONDARY) != null) {
            group = this.getGroup(HighwayNature.SECONDARY);
            GeneralPath secondaryGroupPath = this.buildGroupPath(group);
            groupStroke = new BasicStroke(group.getRenderingProperties().getSkeletWidth(), 1, 1);
            Shape secondaryShape = groupStroke.createStrokedShape(secondaryGroupPath);
            Area secondaryArea = new Area(secondaryShape);
            this.skeletArea.add(secondaryArea);
            GeneralPath secondarySkelet = new GeneralPath();
            secondarySkelet.append(secondaryArea.getPathIterator(null), false);
            this.getGroup(HighwayNature.SECONDARY).setSkelet(secondarySkelet);
        }
        if (this.getGroup(HighwayNature.PRIMARY) != null) {
            group = this.getGroup(HighwayNature.PRIMARY);
            GeneralPath primaryGroupPath = this.buildGroupPath(group);
            groupStroke = new BasicStroke(group.getRenderingProperties().getSkeletWidth(), 1, 1);
            Shape primaryShape = groupStroke.createStrokedShape(primaryGroupPath);
            Area primaryArea = new Area(primaryShape);
            this.skeletArea.add(primaryArea);
            GeneralPath primarySkelet = new GeneralPath();
            primarySkelet.append(primaryArea.getPathIterator(null), false);
            this.getGroup(HighwayNature.PRIMARY).setSkelet(primarySkelet);
        }
        if (this.getGroup(HighwayNature.TRUNK) != null) {
            group = this.getGroup(HighwayNature.TRUNK);
            GeneralPath trunkGroupPath = this.buildGroupPath(group);
            groupStroke = new BasicStroke(group.getRenderingProperties().getSkeletWidth(), 1, 1);
            Shape trunkShape = groupStroke.createStrokedShape(trunkGroupPath);
            Area trunkArea = new Area(trunkShape);
            this.skeletArea.add(trunkArea);
            GeneralPath trunkSkelet = new GeneralPath();
            trunkSkelet.append(trunkArea.getPathIterator(null), false);
            this.getGroup(HighwayNature.TRUNK).setSkelet(trunkSkelet);
        }
        if (this.getGroup(HighwayNature.TRUNK_LINK) != null) {
            group = this.getGroup(HighwayNature.TRUNK_LINK);
            GeneralPath trunkLinkGroupPath = this.buildGroupPath(group);
            groupStroke = new BasicStroke(group.getRenderingProperties().getSkeletWidth(), 1, 1);
            Shape trunkLinkShape = groupStroke.createStrokedShape(trunkLinkGroupPath);
            Area trunkLinkArea = new Area(trunkLinkShape);
            this.skeletArea.add(trunkLinkArea);
            GeneralPath trunkLinkSkelet = new GeneralPath();
            trunkLinkSkelet.append(trunkLinkArea.getPathIterator(null), false);
            this.getGroup(HighwayNature.TRUNK_LINK).setSkelet(trunkLinkSkelet);
        }
        if (this.getGroup(HighwayNature.MOTORWAY) != null) {
            group = this.getGroup(HighwayNature.MOTORWAY);
            GeneralPath motorwayGroupPath = this.buildGroupPath(this.getGroup(HighwayNature.MOTORWAY));
            groupStroke = new BasicStroke(group.getRenderingProperties().getSkeletWidth(), 1, 1);
            Shape motorwayShape = groupStroke.createStrokedShape(motorwayGroupPath);
            Area motowayArea = new Area(motorwayShape);
            this.skeletArea.add(motowayArea);
            GeneralPath motorwaySkelet = new GeneralPath();
            motorwaySkelet.append(motowayArea.getPathIterator(null), false);
            this.getGroup(HighwayNature.MOTORWAY).setSkelet(motorwaySkelet);
        }
        if (this.getGroup(HighwayNature.MOTORWAY_LINK) != null) {
            group = this.getGroup(HighwayNature.MOTORWAY_LINK);
            GeneralPath motorwayLinkGroupPath = this.buildGroupPath(group);
            groupStroke = new BasicStroke(group.getRenderingProperties().getSkeletWidth(), 1, 1);
            Shape motorwayLinkShape = groupStroke.createStrokedShape(motorwayLinkGroupPath);
            Area motorwayLinkArea = new Area(motorwayLinkShape);
            this.skeletArea.add(motorwayLinkArea);
            GeneralPath motorwayLinkSkelet = new GeneralPath();
            motorwayLinkSkelet.append(motorwayLinkArea.getPathIterator(null), false);
            this.getGroup(HighwayNature.MOTORWAY_LINK).setSkelet(motorwayLinkSkelet);
        }
        if (this.getGroup(HighwayNature.PEDESTRIAN) != null) {
            group = this.getGroup(HighwayNature.PEDESTRIAN);
            GeneralPath pedestrianGroupPath = this.buildGroupPath(this.getGroup(HighwayNature.PEDESTRIAN));
            groupStroke = new BasicStroke(group.getRenderingProperties().getSkeletWidth(), 1, 1);
            Shape pedestrianShape = groupStroke.createStrokedShape(pedestrianGroupPath);
            Area pedestrianArea = new Area(pedestrianShape);
            this.skeletArea.add(pedestrianArea);
            GeneralPath pedestrianSkelet = new GeneralPath();
            pedestrianSkelet.append(pedestrianArea.getPathIterator(null), false);
            this.getGroup(HighwayNature.PEDESTRIAN).setSkelet(pedestrianSkelet);
        }
        this.skeletPath.append(this.skeletArea.getPathIterator(null), false);
    }

    private GeneralPath buildGroupPath(HighwayGroup group) {
        GeneralPath groupPath = new GeneralPath();
        List<Highway> ghighways = group.getHighways();
        for (int i = 0; i < ghighways.size(); ++i) {
            Highway highway = ghighways.get(i);
            highway.calculatePath();
            groupPath.append(highway.getHighwayPath(), false);
        }
        return groupPath;
    }

    public GeneralPath getSkeletPath() {
        return this.skeletPath;
    }

    public Area getSkeletArea() {
        return this.skeletArea;
    }

    public void makeGlyphSkelet() {
        this.glyphLayouts.clear();
        for (HighwayGroup group : this.higwaysGroup) {
            ArrayList<GlyphLayout> glg = new ArrayList<GlyphLayout>();
            group.setGlyphLayouts(glg);
            if (!group.getRenderingProperties().isLockGlyph()) continue;
            for (Highway h : group.getHighways()) {
                GeneralPath path = null;
                path = h.needToReverse() ? h.getReversePath() : h.getHighwayPath();
                GlyphLayout glyphLayout = new GlyphLayout(h.getName(), path, this.frc, group.getRenderingProperties().getGlyphFont());
                glyphLayout.calculateGlyph();
                this.glyphLayouts.add(glyphLayout);
                glg.add(glyphLayout);
            }
        }
        this.resolveLayout();
    }

    private void resolveLayout() {
        for (GlyphLayout gl : this.glyphLayouts) {
            Vector<Glyph> items = gl.getGlyphItems();
            for (Glyph gi : items) {
                if (!gi.islock() || !this.intersects(gi)) continue;
                gi.unlock();
            }
        }
    }

    private boolean intersects(Glyph item) {
        for (GlyphLayout gl : this.glyphLayouts) {
            Vector<Glyph> items = gl.getGlyphItems();
            for (Glyph gi : items) {
                if (item.equals(gi) || !gi.intersect(item) || !item.islock()) continue;
                return true;
            }
        }
        return false;
    }

    public List<GlyphLayout> getGlyphLayouts() {
        return this.glyphLayouts;
    }
}

