/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.layer.landuse;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.map.layer.AbstractMapLayer;
import org.jensoft.core.map.layer.landuse.CimeteryLanduseRenderer;
import org.jensoft.core.map.layer.landuse.Landuse;
import org.jensoft.core.map.layer.landuse.LanduseNature;
import org.jensoft.core.map.projection.Map2D;

public class LanduseLayer
extends AbstractMapLayer {
    private CimeteryLanduseRenderer cimeteryLanduseRenderer;
    private List<Landuse> registeredLanduse = new ArrayList<Landuse>();

    public LanduseLayer() {
        this.cimeteryLanduseRenderer = new CimeteryLanduseRenderer();
    }

    public void registerLanduse(Landuse landuse) {
        if (!this.isAlreadyRegister(landuse)) {
            this.registeredLanduse.add(landuse);
            super.registerPrimitive(landuse.getPrimitive());
        }
    }

    @Override
    public void clearLayer() {
    }

    public void registerLanduses(List<Landuse> landuse) {
        for (Landuse l : landuse) {
            this.registerLanduse(l);
        }
    }

    private boolean isAlreadyRegister(Landuse l) {
        for (Landuse landuse : this.registeredLanduse) {
            if (!landuse.equals(l)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void doPaintMap(Map2D map2D) {
        this.project();
        for (Landuse l : this.registeredLanduse) {
            if (!l.getNature().equals(LanduseNature.CIMETERY)) continue;
            this.cimeteryLanduseRenderer.paintLanduse(map2D.getGraphics2D(), l);
        }
    }

    @Override
    public void doPaint(Graphics2D g2d) {
        this.project();
        for (Landuse l : this.registeredLanduse) {
            if (!l.getNature().equals(LanduseNature.CIMETERY)) continue;
            this.cimeteryLanduseRenderer.paintLanduse(g2d, l);
        }
    }
}

