/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.layer.leisure;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.map.layer.leisure.LeisureRenderer;
import org.jensoft.core.map.primitive.Primitive;
import org.jensoft.core.map.projection.GeoPosition;

public class Leisure {
    private int id;
    private LeisureRenderer leisureRenderer;
    private List<GeoPosition> leisureGeoLimits;
    private List<Point2D> leisurePointLimits;
    private String nature;
    private String name = "";
    private Primitive primitive;

    public Leisure(int id, String nature) {
        this.id = id;
        this.leisureGeoLimits = new ArrayList<GeoPosition>();
        this.leisurePointLimits = new ArrayList<Point2D>();
        this.nature = nature;
    }

    public Primitive getPrimitive() {
        return this.primitive;
    }

    public void setPrimitive(Primitive primitive) {
        this.primitive = primitive;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Leisure) {
            Leisure l = (Leisure)obj;
            return l.getId() == this.id;
        }
        return false;
    }

    public void addLimitPosition(GeoPosition limitPosition) {
        this.leisureGeoLimits.add(limitPosition);
    }

    public void addLimitPosition(Point2D limitPosition) {
        this.leisurePointLimits.add(limitPosition);
    }

    public List<GeoPosition> getLimitGeoPositions() {
        return this.leisureGeoLimits;
    }

    public List<Point2D> getLimitProjectionPositions() {
        return this.leisurePointLimits;
    }

    public LeisureRenderer getLeisureRenderer() {
        return this.leisureRenderer;
    }

    public void setLeisureRenderer(LeisureRenderer regionRenderer) {
        this.leisureRenderer = regionRenderer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getNature() {
        return this.nature;
    }

    public void setNature(String nature) {
        this.nature = nature;
    }
}

