/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.layer.leisure;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import org.jensoft.core.map.layer.leisure.Leisure;
import org.jensoft.core.map.layer.leisure.LeisureRenderer;
import org.jensoft.core.map.primitive.Node;

public class WaterParkLeisureRenderer
implements LeisureRenderer {
    @Override
    public boolean paintLeisure(Graphics2D g2d, Leisure leisure) {
        Polygon poly = new Polygon();
        for (Node n : leisure.getPrimitive().getNodes()) {
            poly.addPoint((int)n.getProjection().getX(), (int)n.getProjection().getY());
        }
        int centerX = (int)poly.getBounds2D().getCenterX();
        int centerY = (int)poly.getBounds2D().getCenterY();
        String name = leisure.getName();
        g2d.setFont(new Font("verdana", 0, 10));
        FontMetrics fm = g2d.getFontMetrics();
        int w = fm.stringWidth(name);
        g2d.setColor(new Color(157, 223, 255));
        g2d.fill(poly);
        g2d.setColor(Color.WHITE);
        g2d.drawString(name, centerX - w / 2 - 1, centerY);
        g2d.drawString(name, centerX - w / 2 + 1, centerY);
        g2d.drawString(name, centerX - w / 2, centerY - 1);
        g2d.drawString(name, centerX - w / 2, centerY + 1);
        g2d.setColor(Color.BLACK);
        g2d.drawString(name, centerX - w / 2, centerY);
        return false;
    }
}

