/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.layer.manmade;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jensoft.core.map.layer.manmade.ManMade;
import org.jensoft.core.map.layer.manmade.ManMadeRenderer;
import org.jensoft.core.map.primitive.Node;

public class BuildingRenderer
implements ManMadeRenderer {
    private Font font = new Font("Sansation", 0, 10);

    @Override
    public boolean paintManMade(Graphics2D g2d, ManMade manMade) {
        Polygon poly = new Polygon();
        for (Node n : manMade.getPrimitive().getNodes()) {
            poly.addPoint((int)n.getProjection().getX(), (int)n.getProjection().getY());
        }
        g2d.setColor(new Color(193, 176, 175));
        g2d.fill(poly);
        g2d.setColor(new Color(138, 108, 149));
        g2d.draw(poly);
        g2d.setFont(this.font);
        String name = manMade.getName();
        if (name != null && name.length() > 0) {
            float wrappingWidth = (float)poly.getBounds2D().getWidth();
            List<TextLayout> layouts = this.getLayouts(wrappingWidth, name, g2d.getFontRenderContext());
            g2d.setColor(Color.black);
            int penX = (int)poly.getBounds2D().getX();
            int penY = (int)poly.getBounds2D().getY();
            Point pen = new Point(penX, penY);
            g2d.setFont(this.font);
            Iterator<TextLayout> it0 = layouts.iterator();
            float hLayouts = 0.0f;
            while (it0.hasNext()) {
                TextLayout layout = it0.next();
                hLayouts = (float)((double)hLayouts + layout.getBounds().getHeight());
            }
            pen.y += (int)(poly.getBounds2D().getHeight() - (double)hLayouts) / 2;
            for (TextLayout layout : layouts) {
                pen.x = (int)(poly.getBounds2D().getX() + (double)((wrappingWidth - layout.getAdvance()) / 2.0f));
                pen.y = (int)((float)pen.y + layout.getAscent());
                g2d.setColor(Color.white);
                layout.draw(g2d, pen.x + 1, pen.y);
                layout.draw(g2d, pen.x - 1, pen.y);
                layout.draw(g2d, pen.x, pen.y + 1);
                layout.draw(g2d, pen.x, pen.y - 1);
                g2d.setColor(new Color(34, 89, 255));
                layout.draw(g2d, pen.x, pen.y);
                pen.y = (int)((float)pen.y + layout.getDescent());
            }
        }
        return false;
    }

    private List<TextLayout> getLayouts(float wrappingWidth, String text, FontRenderContext frc) {
        ArrayList<TextLayout> layouts = new ArrayList<TextLayout>();
        AttributedString attrStr = new AttributedString(text);
        attrStr.addAttribute(TextAttribute.FONT, this.font, 0, text.length());
        LineBreakMeasurer measurer = new LineBreakMeasurer(attrStr.getIterator(), frc);
        while (measurer.getPosition() < text.length()) {
            TextLayout layout = measurer.nextLayout(wrappingWidth);
            layouts.add(layout);
        }
        return layouts;
    }
}

