/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.layer.manmade;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.map.layer.AbstractMapLayer;
import org.jensoft.core.map.layer.manmade.BuildingRenderer;
import org.jensoft.core.map.layer.manmade.ManMade;
import org.jensoft.core.map.layer.manmade.ManMadeNature;
import org.jensoft.core.map.projection.Map2D;

public class ManMadeLayer
extends AbstractMapLayer {
    private BuildingRenderer buildingRenderer;
    private List<ManMade> registeredManMade = new ArrayList<ManMade>();

    public ManMadeLayer() {
        this.buildingRenderer = new BuildingRenderer();
    }

    public void registerManMade(ManMade manMade) {
        if (!this.isAlreadyRegister(manMade)) {
            this.registeredManMade.add(manMade);
            super.registerPrimitive(manMade.getPrimitive());
        }
    }

    public void registerManMades(List<ManMade> manMades) {
        for (ManMade mm : manMades) {
            this.registerManMade(mm);
        }
    }

    private boolean isAlreadyRegister(ManMade mm) {
        for (ManMade manMade : this.registeredManMade) {
            if (!manMade.equals(mm)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void doPaintMap(Map2D map2D) {
        this.project();
        for (ManMade rmm : this.registeredManMade) {
            if (!rmm.getNature().equals(ManMadeNature.BUILDING)) continue;
            this.buildingRenderer.paintManMade(map2D.getGraphics2D(), rmm);
        }
    }

    @Override
    public void doPaint(Graphics2D g2d) {
        this.project();
        for (ManMade rmm : this.registeredManMade) {
            if (!rmm.getNature().equals(ManMadeNature.BUILDING)) continue;
            this.buildingRenderer.paintManMade(g2d, rmm);
        }
    }
}

