/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.layer.natural;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.map.layer.natural.Coordinate;
import org.jensoft.core.map.layer.natural.LineString;
import org.jensoft.core.map.layer.natural.Natural;
import org.jensoft.core.map.primitive.Node;

public class Coastline {
    private List<Natural> segments = new ArrayList<Natural>();

    public Natural getFirstSegment() {
        return this.segments.get(0);
    }

    public Natural getLastSegment() {
        return this.segments.get(this.segments.size() - 1);
    }

    public Natural getSegment(int index) {
        return this.segments.get(index);
    }

    public void addSegment(Natural segment) {
        this.segments.add(segment);
    }

    public int countSegment() {
        return this.segments.size();
    }

    public List<Natural> getSegments() {
        return this.segments;
    }

    public LineString getGeometry() {
        LineString lineString = null;
        ArrayList<Point2D> linePoints = new ArrayList<Point2D>();
        for (Natural natural : this.segments) {
            for (Node n : natural.getPrimitive().getNodes()) {
                linePoints.add(n.getProjection());
            }
        }
        int len = linePoints.size();
        Coordinate[] cs = new Coordinate[len];
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = new Coordinate(((Point2D)linePoints.get(i)).getX(), ((Point2D)linePoints.get(i)).getY());
        }
        return lineString;
    }
}

