/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.layer.natural;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.map.layer.AbstractMapLayer;
import org.jensoft.core.map.layer.natural.CoastlineSkelet;
import org.jensoft.core.map.layer.natural.Natural;
import org.jensoft.core.map.layer.natural.NaturalNature;
import org.jensoft.core.map.projection.Map2D;

public class NaturalLayer
extends AbstractMapLayer {
    private List<Natural> registeredNatural = new ArrayList<Natural>();

    public void registerNatural(Natural natural) {
        if (!this.isAlreadyRegister(natural)) {
            this.registeredNatural.add(natural);
            super.registerPrimitive(natural.getPrimitive());
        }
    }

    public void registerNatural(List<Natural> naturals) {
        for (Natural mm : naturals) {
            this.registerNatural(mm);
        }
    }

    private boolean isAlreadyRegister(Natural n) {
        for (Natural natural : this.registeredNatural) {
            if (!natural.equals(n)) continue;
            return true;
        }
        return false;
    }

    private void paintCoastlineSkelet(Graphics2D g2d) {
        this.project();
        CoastlineSkelet skelet = new CoastlineSkelet(this.getGeoBound(), this.getProjection2D());
        for (Natural natural : this.registeredNatural) {
            if (!natural.getNature().equals(NaturalNature.COASTLINE_NATURE)) continue;
            skelet.register(natural);
        }
        skelet.createSkelet();
        Area closedCoastline = skelet.getCoastlineSkelet();
        g2d.setColor(new Color(181, 208, 208));
        g2d.fill(closedCoastline);
    }

    @Override
    public void doPaintMap(Map2D map2D) {
        this.paintCoastlineSkelet(map2D.getGraphics2D());
    }

    @Override
    public void doPaint(Graphics2D g2d) {
        this.paintCoastlineSkelet(g2d);
    }
}

