/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.layer.natural;

import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.map.layer.natural.Coordinate;
import org.jensoft.core.map.layer.natural.LineString;

public class Relio {
    private double W;
    private double E;
    private double N;
    private double S;
    private Point2D input;
    private Point2D output;
    private List<LineString> lines = new ArrayList<LineString>();
    private List<ClosedLine> closedLines = new ArrayList<ClosedLine>();

    public Relio(double W2, double E2, double N2, double S2) {
        this.W = W2;
        this.E = E2;
        this.N = N2;
        this.S = S2;
    }

    private Point2D getInput(LineString ls) {
        Coordinate[] C = ls.getCoordinates();
        Coordinate cStart = C[0];
        return new Point2D.Double(cStart.x, cStart.y);
    }

    private Point2D getOutput(LineString ls) {
        Coordinate[] C = ls.getCoordinates();
        Coordinate cEnd = C[C.length - 1];
        return new Point2D.Double(cEnd.x, cEnd.y);
    }

    private boolean isS(Point2D p2d) {
        double y = p2d.getY();
        return y == this.S;
    }

    private boolean isN(Point2D p2d) {
        double y = p2d.getY();
        return y == this.N;
    }

    private boolean isW(Point2D p2d) {
        double x = p2d.getX();
        return x == this.W;
    }

    private boolean isE(Point2D p2d) {
        double x = p2d.getX();
        return x == this.E;
    }

    private boolean isSW(Point2D p2d) {
        double x = p2d.getX();
        double y = p2d.getY();
        return y == this.S && x == this.W;
    }

    private boolean isNW(Point2D p2d) {
        double x = p2d.getX();
        double y = p2d.getY();
        return y == this.N && x == this.W;
    }

    private boolean isNE(Point2D p2d) {
        double x = p2d.getX();
        double y = p2d.getY();
        return x == this.E && y == this.N;
    }

    private boolean isSE(Point2D p2d) {
        double x = p2d.getX();
        double y = p2d.getY();
        return x == this.E && y == this.S;
    }

    public void addInputOutput(LineString ls) {
        this.lines.add(ls);
    }

    public void reliableIO() {
        for (LineString ls : this.lines) {
            if (!this.isFree(ls)) continue;
            ClosedLine cl = new ClosedLine();
            cl.append(ls);
            this.closedLines.add(cl);
            this.close(cl);
        }
    }

    public List<GeneralPath> getClosedPaths() {
        ArrayList<GeneralPath> closedPathCoastlines = new ArrayList<GeneralPath>();
        for (ClosedLine cl : this.closedLines) {
            closedPathCoastlines.add(cl.getClosePath());
        }
        return closedPathCoastlines;
    }

    private void close(ClosedLine cl) {
        LineString ls = cl.getFirstLine();
        Point2D output = this.getOutput(ls);
        boolean flag = true;
        boolean count = false;
        while (flag) {
            Object compatibleInput = this.getCompatibleInput(output);
            if (compatibleInput == null) continue;
            if (compatibleInput instanceof LineString && ((LineString)compatibleInput).equals(cl.getFirstLine())) {
                flag = false;
            }
            if (!flag) continue;
            if (compatibleInput instanceof Point2D) {
                cl.append((Point2D)compatibleInput);
                output = (Point2D)compatibleInput;
                continue;
            }
            if (!(compatibleInput instanceof LineString)) continue;
            cl.append((LineString)compatibleInput);
            output = this.getOutput((LineString)compatibleInput);
        }
    }

    private LineString getReliableWest(Point2D output) {
        ArrayList<LineString> reliableWest = new ArrayList<LineString>();
        for (LineString ls : this.lines) {
            if (!this.isW(this.getInput(ls)) || !(this.getInput(ls).getY() > output.getY())) continue;
            reliableWest.add(ls);
        }
        LineString reliable = null;
        for (LineString lw : reliableWest) {
            if (reliable == null) {
                reliable = lw;
            }
            Point2D reliableInput = this.getInput(reliable);
            Point2D curentInput = this.getInput(lw);
            if (!(curentInput.getY() < reliableInput.getY())) continue;
            reliable = lw;
        }
        return reliable;
    }

    private LineString getReliableNorth(Point2D output) {
        ArrayList<LineString> reliableNorth = new ArrayList<LineString>();
        for (LineString ls : this.lines) {
            if (!this.isN(this.getInput(ls)) || !(this.getInput(ls).getX() < output.getX())) continue;
            reliableNorth.add(ls);
        }
        LineString reliable = null;
        for (LineString ln : reliableNorth) {
            if (reliable == null) {
                reliable = ln;
            }
            Point2D reliableInput = this.getInput(reliable);
            Point2D curentInput = this.getInput(ln);
            if (!(curentInput.getX() > reliableInput.getX())) continue;
            reliable = ln;
        }
        return reliable;
    }

    private LineString getReliableSouth(Point2D output) {
        ArrayList<LineString> reliableSouth = new ArrayList<LineString>();
        for (LineString ls : this.lines) {
            if (!this.isS(this.getInput(ls)) || !(this.getInput(ls).getX() > output.getX())) continue;
            reliableSouth.add(ls);
        }
        LineString reliable = null;
        for (LineString ls : reliableSouth) {
            if (reliable == null) {
                reliable = ls;
            }
            Point2D reliableInput = this.getInput(reliable);
            Point2D curentInput = this.getInput(ls);
            if (!(curentInput.getX() < reliableInput.getX())) continue;
            reliable = ls;
        }
        return reliable;
    }

    private LineString getReliableEast(Point2D output) {
        ArrayList<LineString> reliableEast = new ArrayList<LineString>();
        for (LineString ls : this.lines) {
            if (!this.isE(this.getInput(ls)) || !(this.getInput(ls).getY() < output.getY())) continue;
            reliableEast.add(ls);
        }
        LineString reliable = null;
        for (LineString le : reliableEast) {
            if (reliable == null) {
                reliable = le;
            }
            Point2D reliableInput = this.getInput(reliable);
            Point2D curentInput = this.getInput(le);
            if (!(curentInput.getY() > reliableInput.getY())) continue;
            reliable = le;
        }
        return reliable;
    }

    private Object getCompatibleInput(Point2D output) {
        if (this.isN(output)) {
            if (this.isNW(output)) {
                LineString l = this.getReliableWest(output);
                if (l != null) {
                    return l;
                }
                return new Point2D.Double(this.W, this.S);
            }
            LineString l = this.getReliableNorth(output);
            if (l != null) {
                return l;
            }
            return new Point2D.Double(this.W, this.N);
        }
        if (this.isW(output)) {
            if (this.isSW(output)) {
                LineString l = this.getReliableSouth(output);
                if (l != null) {
                    return l;
                }
                return new Point2D.Double(this.E, this.S);
            }
            LineString l = this.getReliableWest(output);
            if (l != null) {
                return l;
            }
            return new Point2D.Double(this.W, this.S);
        }
        if (this.isS(output)) {
            if (this.isSE(output)) {
                LineString l = this.getReliableEast(output);
                if (l != null) {
                    return l;
                }
                return new Point2D.Double(this.E, this.N);
            }
            LineString l = this.getReliableSouth(output);
            if (l != null) {
                return l;
            }
            return new Point2D.Double(this.E, this.S);
        }
        if (this.isE(output)) {
            if (this.isNE(output)) {
                LineString l = this.getReliableNorth(output);
                if (l != null) {
                    return l;
                }
                return new Point2D.Double(this.W, this.N);
            }
            LineString l = this.getReliableEast(output);
            if (l != null) {
                return l;
            }
            return new Point2D.Double(this.E, this.N);
        }
        return null;
    }

    private boolean isFree(LineString ls) {
        for (ClosedLine cl : this.closedLines) {
            if (!cl.isRegister(ls)) continue;
            return false;
        }
        return true;
    }

    class ClosedLine {
        private List<LineString> lss = new ArrayList<LineString>();
        private GeneralPath closedPath;

        public GeneralPath getClosePath() {
            return this.closedPath;
        }

        public void append(LineString ls) {
            this.addLine(ls);
            Coordinate[] C = ls.getCoordinates();
            if (this.closedPath == null) {
                this.closedPath = new GeneralPath();
                Coordinate cStart = C[0];
                this.closedPath.moveTo(cStart.x, cStart.y);
                for (int i = 0; i < C.length; ++i) {
                    this.closedPath.lineTo(C[i].x, C[i].y);
                }
            } else {
                for (int i = 0; i < C.length; ++i) {
                    this.closedPath.lineTo(C[i].x, C[i].y);
                }
            }
        }

        public void append(Point2D p2d) {
            this.closedPath.lineTo(p2d.getX(), p2d.getY());
        }

        public LineString getFirstLine() {
            return this.lss.get(0);
        }

        public LineString getLastLine() {
            return this.lss.get(this.lss.size() - 1);
        }

        private void addLine(LineString ls) {
            this.lss.add(ls);
        }

        private boolean isRegister(LineString ls) {
            for (LineString locallLS : this.lss) {
                if (!locallLS.equals(ls)) continue;
                return true;
            }
            return false;
        }
    }
}

