/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.layer.railway;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.map.layer.AbstractMapLayer;
import org.jensoft.core.map.layer.railway.RailRenderer;
import org.jensoft.core.map.layer.railway.Railway;
import org.jensoft.core.map.layer.railway.RailwayNature;
import org.jensoft.core.map.layer.railway.tramway.TramRailwayRenderer;
import org.jensoft.core.map.projection.Map2D;

public class RailwayLayer
extends AbstractMapLayer {
    private RailRenderer railRenderer;
    private TramRailwayRenderer tramRailRenderer;
    private List<Railway> registeredRailway = new ArrayList<Railway>();

    public RailwayLayer() {
        this.railRenderer = new RailRenderer();
        this.tramRailRenderer = new TramRailwayRenderer();
    }

    public void registerRailway(Railway railway) {
        if (!this.isAlreadyRegister(railway)) {
            this.registeredRailway.add(railway);
            super.registerPrimitive(railway.getPrimitive());
        }
    }

    public void registerRailways(List<Railway> railways) {
        for (Railway rw : railways) {
            this.registerRailway(rw);
        }
    }

    private boolean isAlreadyRegister(Railway rw) {
        for (Railway railway : this.registeredRailway) {
            if (!railway.equals(rw)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void doPaintMap(Map2D map2D) {
        this.project();
        for (Railway rmm : this.registeredRailway) {
            if (!rmm.getNature().equals(RailwayNature.TRAM)) continue;
            this.tramRailRenderer.paintRailway(map2D.getGraphics2D(), rmm);
        }
    }

    @Override
    public void doPaint(Graphics2D g2d) {
        this.project();
        for (Railway rmm : this.registeredRailway) {
            if (!rmm.getNature().equals(RailwayNature.TRAM)) continue;
            this.tramRailRenderer.paintRailway(g2d, rmm);
        }
    }
}

