/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.layer.waterway;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.map.layer.AbstractMapLayer;
import org.jensoft.core.map.layer.waterway.RiverWaterwayRenderer;
import org.jensoft.core.map.layer.waterway.RiverbankWaterwayRenderer;
import org.jensoft.core.map.layer.waterway.Waterway;
import org.jensoft.core.map.layer.waterway.WaterwayNature;
import org.jensoft.core.map.projection.Map2D;

public class WaterwayLayer
extends AbstractMapLayer {
    private RiverbankWaterwayRenderer riverBankRenderer;
    private RiverWaterwayRenderer riverenderer;
    private List<Waterway> registeredWarterways = new ArrayList<Waterway>();

    public WaterwayLayer() {
        this.riverBankRenderer = new RiverbankWaterwayRenderer();
        this.riverenderer = new RiverWaterwayRenderer();
    }

    public void registerWaterway(Waterway waterWay) {
        if (!this.isAlreadyRegister(waterWay)) {
            this.registeredWarterways.add(waterWay);
            super.registerPrimitive(waterWay.getPrimitive());
        }
    }

    public void registerWaterway(List<Waterway> waterWays) {
        for (Waterway ww : waterWays) {
            this.registerWaterway(ww);
        }
    }

    private boolean isAlreadyRegister(Waterway ww) {
        for (Waterway waterway : this.registeredWarterways) {
            if (!waterway.equals(ww)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void doPaintMap(Map2D map2D) {
        this.project();
        for (Waterway ww : this.registeredWarterways) {
            if (!ww.getNature().equals(WaterwayNature.RIVERBANK)) continue;
            this.riverBankRenderer.paintWaterway(map2D.getGraphics2D(), ww);
        }
    }

    @Override
    public void doPaint(Graphics2D g2d) {
        this.project();
        for (Waterway ww : this.registeredWarterways) {
            if (!ww.getNature().equals(WaterwayNature.RIVERBANK)) continue;
            this.riverBankRenderer.paintWaterway(g2d, ww);
        }
    }
}

