/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.primitive;

import java.awt.geom.Point2D;
import java.util.Vector;
import org.jensoft.core.map.primitive.Tag;
import org.jensoft.core.map.projection.GeoPosition;

public class Node {
    private int id;
    private String timestamp;
    private String user;
    private String lat;
    private String lon;
    private GeoPosition geoPosition;
    private Point2D projection;
    private Vector<Tag> tags = new Vector();

    public Node() {
    }

    public Node(int id) {
        this.id = id;
    }

    public boolean equals(Node n) {
        if (n == null) {
            return false;
        }
        if (n.getId() == this.id) {
            return true;
        }
        return n.getGeoPosition().equals(this.getGeoPosition());
    }

    public GeoPosition getGeoPosition() {
        if (this.geoPosition == null) {
            this.geoPosition = new GeoPosition(this.getLatitudeAsDouble(), this.getLongitudeAsDouble());
        }
        return this.geoPosition;
    }

    public void setGeoPosition(GeoPosition geoPosition) {
        this.geoPosition = geoPosition;
    }

    public Point2D getProjection() {
        return this.projection;
    }

    public void setProjection(Point2D projection) {
        this.projection = projection;
    }

    public void addTag(String key, String value) {
        this.tags.add(new Tag(key, value));
    }

    public void addTag(Tag t) {
        this.tags.add(t);
    }

    public Tag getTag(int index) {
        return this.tags.get(index);
    }

    public Tag getTag(String key) {
        for (Tag t : this.tags) {
            if (!t.getKey().equals(key)) continue;
            return t;
        }
        return null;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getLat() {
        return this.lat;
    }

    public double getLatitudeAsDouble() {
        return Double.parseDouble(this.lat);
    }

    public void setLat(String lat) {
        this.lat = lat;
    }

    public String getLon() {
        return this.lon;
    }

    public double getLongitudeAsDouble() {
        return Double.parseDouble(this.lon);
    }

    public void setLon(String lon) {
        this.lon = lon;
    }

    public Vector<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Vector<Tag> tags) {
        this.tags = tags;
    }
}

