/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.primitive;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jensoft.core.map.primitive.Node;
import org.jensoft.core.map.primitive.Relation;
import org.jensoft.core.map.primitive.Tag;
import org.jensoft.core.map.primitive.Way;

public class Stream {
    private Vector<Way> ways = new Vector();
    private Vector<Node> nodes = new Vector();
    private Vector<Relation> relations = new Vector();

    public void addWay(Way w) {
        this.ways.add(w);
    }

    public Way getWay(int wayID) {
        for (Way w : this.ways) {
            if (w.getId() != wayID) continue;
            w.setNodes(this.getNodes(w.getId()));
            return w;
        }
        return null;
    }

    public List<Way> getWays(String tagKey) {
        ArrayList<Way> taggedWays = new ArrayList<Way>();
        for (Way w : this.ways) {
            for (Tag t : w.getTags()) {
                if (!t.getKey().equals(tagKey)) continue;
                w.setNodes(this.getNodes(w.getId()));
                taggedWays.add(w);
            }
        }
        return taggedWays;
    }

    public List<Way> getWays(String tagKey, String tagValue) {
        ArrayList<Way> filteredTaggedWays = new ArrayList<Way>();
        for (Way w : this.ways) {
            for (Tag t : w.getTags()) {
                if (!t.getKey().equals(tagKey) || !t.getValue().equals(tagValue)) continue;
                w.setNodes(this.getNodes(w.getId()));
                filteredTaggedWays.add(w);
            }
        }
        return filteredTaggedWays;
    }

    public Vector<Way> getWays() {
        for (Way w : this.ways) {
            w.setNodes(this.getNodes(w.getId()));
        }
        return this.ways;
    }

    public void addNode(Node n) {
        this.nodes.add(n);
    }

    public Node getNode(int nodeID) {
        for (Node n : this.nodes) {
            if (n.getId() != nodeID) continue;
            return n;
        }
        return null;
    }

    public List<Node> getNodes(int wayID) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Way w : this.ways) {
            if (w.getId() != wayID) continue;
            for (Integer ref : w.getNodesRef()) {
                Node n = this.getNode(ref);
                if (n == null) continue;
                nodes.add(n);
            }
        }
        return nodes;
    }

    public void addRelation(Relation r) {
        this.relations.add(r);
    }

    public void clear() {
        this.ways.clear();
        this.nodes.clear();
        this.relations.clear();
    }
}

