/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.projection;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.map.layer.AbstractMapLayer;
import org.jensoft.core.map.projection.GeoPosition;
import org.jensoft.core.map.projection.Map2D;
import org.jensoft.core.map.projection.Projection2D;

public class DalleProjection
implements Projection2D {
    private int squareTileSize = 256;
    private int maxTileIndex = 0;
    private int zoom;
    private List<AbstractMapLayer> mapLayers = new ArrayList<AbstractMapLayer>();

    public DalleProjection(int zoom) {
        this.zoom = zoom;
        this.maxTileIndex = (int)Math.pow(2.0, zoom) - 1;
    }

    public DalleProjection(int zoom, int squareTileSize) {
        this.zoom = zoom;
        this.squareTileSize = squareTileSize;
        this.maxTileIndex = (int)Math.pow(2.0, zoom) - 1;
    }

    public int getZoom() {
        return this.zoom;
    }

    public int getSquareTileSize() {
        return this.squareTileSize;
    }

    public int getMaxTileIndex() {
        return this.maxTileIndex;
    }

    public String toString() {
        return "projection dalle[Level:" + this.zoom + ";square:" + this.squareTileSize + "]";
    }

    public Dimension getDalleDimension() {
        int max = (int)Math.pow(2.0, this.zoom);
        return new Dimension(max * this.squareTileSize, max * this.squareTileSize);
    }

    public Map2D createMap2D(int startX, int endX, int startY, int endY) {
        Map2D map2D = new Map2D(startX, endX, startY, endY, this.squareTileSize, this.zoom, this);
        return map2D;
    }

    public void registerLayer(AbstractMapLayer mapLayer) {
        mapLayer.setProjection2D(this);
        this.mapLayers.add(mapLayer);
    }

    public Point2D getDalleCenter() {
        Dimension dim = this.getDalleDimension();
        return new Point2D.Double(dim.getWidth() / 2.0, dim.getHeight() / 2.0);
    }

    @Override
    public Point2D geoToPixel(GeoPosition geoPosition) {
        Dimension dalleDimension = this.getDalleDimension();
        double pixelX = dalleDimension.getWidth() * ((geoPosition.getLongitude() + 180.0) / 360.0);
        double pixelY = dalleDimension.getHeight() / 2.0 - Math.log(Math.tan(0.7853981633974483 + Math.toRadians(geoPosition.getLatitude()) / 2.0)) / (Math.PI * 2) * dalleDimension.getWidth();
        return new Point2D.Double(pixelX, pixelY);
    }

    @Override
    public double latitudeToPixel(double latitude) {
        Dimension dalleDimension = this.getDalleDimension();
        double pixelY = dalleDimension.getHeight() / 2.0 - Math.log(Math.tan(0.7853981633974483 + Math.toRadians(latitude) / 2.0)) / (Math.PI * 2) * dalleDimension.getWidth();
        return pixelY;
    }

    @Override
    public double longitudeToPixel(double longitude) {
        Dimension dalleDimension = this.getDalleDimension();
        double pixelX = dalleDimension.getWidth() * ((longitude + 180.0) / 360.0);
        return pixelX;
    }

    @Override
    public GeoPosition pixelToGeo(Point2D point) {
        Dimension dalleDimension = this.getDalleDimension();
        double longitude = point.getX() / dalleDimension.getWidth() * 360.0 - 180.0;
        double A = Math.PI * 2 / dalleDimension.getWidth();
        double B = dalleDimension.getHeight() / 2.0 - point.getY();
        double C = Math.exp(A * B);
        double D = Math.atan(C);
        double latitudeRadian = 2.0 * (D - 0.7853981633974483);
        double latitude = Math.toDegrees(latitudeRadian);
        return new GeoPosition(latitude, longitude);
    }

    @Override
    public double pixelToLatitude(double pixelY) {
        Dimension dalleDimension = this.getDalleDimension();
        double A = Math.PI * 2 / dalleDimension.getWidth();
        double B = dalleDimension.getHeight() / 2.0 - pixelY;
        double C = Math.exp(A * B);
        double D = Math.atan(C);
        double latitudeRadian = 2.0 * (D - 0.7853981633974483);
        double latitude = Math.toDegrees(latitudeRadian);
        return latitude;
    }

    @Override
    public double pixelToLongitude(double pixelX) {
        Dimension dalleDimension = this.getDalleDimension();
        double longitude = pixelX / dalleDimension.getWidth() * 360.0 - 180.0;
        return longitude;
    }
}

