/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.projection;

import java.awt.geom.Point2D;

public class GeoPosition {
    private double latitude;
    private double longitude;

    public GeoPosition(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public GeoPosition(double[] coords) {
        this.latitude = coords[0];
        this.longitude = coords[1];
    }

    public GeoPosition(double latDegrees, double latMinutes, double latSeconds, double lonDegrees, double lonMinutes, double lonSeconds) {
        this(latDegrees + (latMinutes + latSeconds / 60.0) / 60.0, lonDegrees + (lonMinutes + lonSeconds / 60.0) / 60.0);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GeoPosition) {
            GeoPosition coord = (GeoPosition)obj;
            return coord.latitude == this.latitude && coord.longitude == this.longitude;
        }
        return false;
    }

    public Point2D toPoint2D() {
        return new Point2D.Double(this.longitude, this.latitude);
    }

    public String toString() {
        return "[" + this.latitude + ", " + this.longitude + "]";
    }
}

