/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.projection;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jensoft.core.map.layer.AbstractMapLayer;
import org.jensoft.core.map.projection.GeoBound;
import org.jensoft.core.map.projection.MapUtil;
import org.jensoft.core.map.projection.Projection2D;

public class Map2D {
    private int startX;
    private int endX;
    private int startY;
    private int endY;
    private int level;
    private int squareTileSize;
    private BufferedImage bufferedMap;
    private RenderingHints hints;
    private Graphics2D graphics2D;
    private GeoBound geoBound;
    private Projection2D projection;
    private double longWest;
    private double longEast;
    private double latNorth;
    private double latSouth;

    public Map2D(int startX, int endX, int startY, int endY, int squareTileSize, int level, Projection2D projection) {
        this.startX = startX;
        this.endX = endX;
        this.startY = startY;
        this.endY = endY;
        this.squareTileSize = squareTileSize;
        this.level = level;
        this.projection = projection;
        this.longWest = MapUtil.tile2long(startX, level);
        this.longEast = MapUtil.tile2long(endX + 1, level);
        this.latNorth = MapUtil.tile2lat(startY, level);
        this.latSouth = MapUtil.tile2lat(endY + 1, level);
        this.geoBound = new GeoBound(this.longWest, this.latSouth, this.longEast, this.latNorth);
        this.geoBound.setProjection(projection);
    }

    private void createGraphics() {
        this.bufferedMap = new BufferedImage((this.endX - this.startX + 1) * this.squareTileSize, (this.endY - this.startY + 1) * this.squareTileSize, 2);
        this.graphics2D = this.bufferedMap.createGraphics();
        this.graphics2D.translate(-this.startX * this.squareTileSize, -this.startY * this.squareTileSize);
        this.hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        this.hints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        this.hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        this.graphics2D.setRenderingHints(this.hints);
    }

    public FontRenderContext getFontRenderContext() {
        if (this.bufferedMap == null) {
            this.createGraphics();
        }
        return this.graphics2D.getFontRenderContext();
    }

    public GeoBound getGeoBound() {
        return this.geoBound;
    }

    public void writeMap(String mapContainer, String mapName) throws IOException {
        if (this.bufferedMap == null) {
            this.createGraphics();
        }
        this.graphics2D.dispose();
        File fileMapContainer = new File(mapContainer);
        fileMapContainer.mkdirs();
        File file = new File(mapContainer + File.separator + mapName);
        try {
            ImageIO.write((RenderedImage)this.bufferedMap, "png", file);
        }
        catch (IOException e) {
            throw new IOException("Map write error ");
        }
    }

    public void writeTiles(String tilesContainer) throws IOException {
        if (this.bufferedMap == null) {
            this.createGraphics();
        }
        this.graphics2D.dispose();
        File fileTilesContainer = new File(tilesContainer);
        fileTilesContainer.mkdirs();
        File fileTilesLevelContainer = new File(tilesContainer + File.separator + this.level + "");
        fileTilesLevelContainer.mkdirs();
        for (int x = 0; x <= this.endX - this.startX; ++x) {
            File fileTilesLevelXContainer = new File(tilesContainer + File.separator + this.level + "" + File.separator + (this.startX + x) + "");
            fileTilesLevelXContainer.mkdirs();
            for (int y = 0; y <= this.endY - this.startY; ++y) {
                BufferedImage tileImage = this.bufferedMap.getSubimage(x * this.squareTileSize, y * this.squareTileSize, this.squareTileSize, this.squareTileSize);
                String tileName = tilesContainer + File.separator + this.level + "" + File.separator + (this.startX + x) + File.separator + (this.startY + y) + ".png";
                File tileFile = new File(tileName);
                try {
                    ImageIO.write((RenderedImage)tileImage, "png", tileFile);
                    continue;
                }
                catch (IOException e) {
                    throw new IOException("Map tile " + tileName + " write error ");
                }
            }
        }
    }

    public int getStartX() {
        return this.startX;
    }

    public void setStartX(int startX) {
        this.startX = startX;
    }

    public int getEndX() {
        return this.endX;
    }

    public void setEndX(int endX) {
        this.endX = endX;
    }

    public int getStartY() {
        return this.startY;
    }

    public void setStartY(int startY) {
        this.startY = startY;
    }

    public int getEndY() {
        return this.endY;
    }

    public void setEndY(int endY) {
        this.endY = endY;
    }

    public int getSquareTileSize() {
        return this.squareTileSize;
    }

    public void setSquareTileSize(int squareTileSize) {
        this.squareTileSize = squareTileSize;
    }

    public int getLevel() {
        return this.level;
    }

    public BufferedImage getBufferedMap() {
        return this.bufferedMap;
    }

    private void assignProjection(AbstractMapLayer layer) {
        layer.setProjection2D(this.projection);
    }

    private void boundLayer(AbstractMapLayer layer) {
        layer.setGeoBound(this.geoBound);
    }

    public void paint(AbstractMapLayer layer) {
        if (this.bufferedMap == null) {
            this.createGraphics();
        }
        this.boundLayer(layer);
        this.assignProjection(layer);
        layer.doPaintMap(this);
    }

    public Graphics2D getGraphics2D() {
        return this.graphics2D;
    }

    public double getLongWest() {
        return this.longWest;
    }

    public Projection2D getProjection() {
        return this.projection;
    }

    public double getLongEast() {
        return this.longEast;
    }

    public double getLatNorth() {
        return this.latNorth;
    }

    public double getLatSouth() {
        return this.latSouth;
    }
}

