/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.projection;

import org.jensoft.core.map.projection.GeoPosition;

public class MapUtil {
    public static int latToY(double latitude, int zoom) {
        int ytile = (int)Math.floor((1.0 - Math.log(Math.tan(latitude * Math.PI / 180.0) + 1.0 / Math.cos(latitude * Math.PI / 180.0)) / Math.PI) / 2.0 * (double)(1 << zoom));
        return ytile;
    }

    public static int longToX(double longitude, int zoom) {
        int xtile = (int)Math.floor((longitude + 180.0) / 360.0 * (double)(1 << zoom));
        return xtile;
    }

    public static double tile2long(int x, int zoom) {
        return (double)x / Math.pow(2.0, zoom) * 360.0 - 180.0;
    }

    public static double tile2lat(int y, int zoom) {
        double n = Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, zoom);
        return 57.29577951308232 * Math.atan(0.5 * (Math.exp(n) - Math.exp(-n)));
    }

    public static void main(String[] args) {
        GeoPosition centerWindow = new GeoPosition(44.8380405, -0.5938274);
        System.out.println(MapUtil.latToY(centerWindow.getLatitude(), 15));
        System.out.println(MapUtil.longToX(centerWindow.getLongitude(), 15));
        System.out.println(MapUtil.tile2long(65319, 17));
        System.out.println(MapUtil.tile2lat(47233, 17));
        System.out.println(MapUtil.tile2lat(0, 17));
        System.out.println(MapUtil.tile2lat(0, 14));
    }
}

