/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.rendering;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.map.layer.AbstractMapLayer;
import org.jensoft.core.map.layer.background.BackgroundLayer;
import org.jensoft.core.map.layer.highway.GroupRenderingProperties;
import org.jensoft.core.map.layer.highway.HighwayGroup;
import org.jensoft.core.map.layer.highway.HighwayLayer;
import org.jensoft.core.map.layer.highway.HighwayNature;
import org.jensoft.core.map.layer.landuse.LanduseLayer;
import org.jensoft.core.map.layer.leisure.LeisureLayer;
import org.jensoft.core.map.layer.manmade.ManMadeLayer;
import org.jensoft.core.map.layer.natural.NaturalLayer;
import org.jensoft.core.map.layer.railway.RailwayLayer;
import org.jensoft.core.map.layer.waterway.WaterwayLayer;
import org.jensoft.core.map.projection.DalleProjection;
import org.jensoft.core.map.projection.Map2D;

public class RendererEngine {
    private List<AbstractMapLayer> layers;
    private DalleProjection D21_256 = new DalleProjection(21, 256);
    private DalleProjection D21_128 = new DalleProjection(21, 128);
    private DalleProjection D20_256 = new DalleProjection(20, 256);
    private DalleProjection D20_128 = new DalleProjection(20, 128);
    private DalleProjection D19_256 = new DalleProjection(19, 256);
    private DalleProjection D19_128 = new DalleProjection(19, 128);
    private DalleProjection D18_256 = new DalleProjection(18, 256);
    private DalleProjection D18_128 = new DalleProjection(18, 128);
    private DalleProjection D17_256 = new DalleProjection(17, 256);
    private DalleProjection D17_128 = new DalleProjection(17, 128);
    private DalleProjection D16_256 = new DalleProjection(16, 256);
    private DalleProjection D16_128 = new DalleProjection(16, 128);
    private DalleProjection D15_256 = new DalleProjection(15, 256);
    private DalleProjection D15_128 = new DalleProjection(15, 128);
    private DalleProjection D14 = new DalleProjection(14, 256);
    private DalleProjection D13 = new DalleProjection(13, 256);
    private DalleProjection D12 = new DalleProjection(12, 256);
    private BackgroundLayer backgroundLayer = new BackgroundLayer();
    private HighwayLayer highwayLayer = new HighwayLayer();
    private NaturalLayer naturalLayer = new NaturalLayer();
    private LeisureLayer leisureLayer = new LeisureLayer();
    private LanduseLayer landuseLayer = new LanduseLayer();
    private RailwayLayer railwayLayer = new RailwayLayer();
    private ManMadeLayer manmadeLayer = new ManMadeLayer();
    private WaterwayLayer waterwayLayer = new WaterwayLayer();

    public RendererEngine() {
        this.layers = new ArrayList<AbstractMapLayer>();
        this.registerLayer(this.backgroundLayer);
        this.registerLayer(this.leisureLayer);
        this.registerLayer(this.landuseLayer);
        this.registerLayer(this.manmadeLayer);
        this.registerLayer(this.highwayLayer);
        this.registerLayer(this.railwayLayer);
        this.registerLayer(this.waterwayLayer);
    }

    public List<AbstractMapLayer> getLayers() {
        return this.layers;
    }

    public HighwayLayer getHighwayLayer() {
        return this.highwayLayer;
    }

    public NaturalLayer getNaturalLayer() {
        return this.naturalLayer;
    }

    public LeisureLayer getLeisureLayer() {
        return this.leisureLayer;
    }

    public LanduseLayer getLanduseLayer() {
        return this.landuseLayer;
    }

    public RailwayLayer getRailwayLayer() {
        return this.railwayLayer;
    }

    public ManMadeLayer getManmadeLayer() {
        return this.manmadeLayer;
    }

    public WaterwayLayer getWaterwayLayer() {
        return this.waterwayLayer;
    }

    private void registerLayer(AbstractMapLayer layer) {
        this.layers.add(layer);
    }

    public Map2D createMapD21_256(int startX, int endX, int startY, int endY) {
        Map2D map2D = this.D21_256.createMap2D(startX, endX, startY, endY);
        HighwayGroup residentialGroup = this.highwayLayer.getGroup(HighwayNature.RESIDENTIAL);
        GroupRenderingProperties residentialProperties = new GroupRenderingProperties(14, Color.WHITE);
        residentialGroup.setRenderingProperties(residentialProperties);
        HighwayGroup unclassifiedGroup = this.highwayLayer.getGroup(HighwayNature.UNCLASSIFIED);
        GroupRenderingProperties unclassifiedProperties = new GroupRenderingProperties(14, Color.WHITE);
        unclassifiedGroup.setRenderingProperties(unclassifiedProperties);
        HighwayGroup roadGroup = this.highwayLayer.getGroup(HighwayNature.ROAD);
        GroupRenderingProperties roadProperties = new GroupRenderingProperties(14, Color.WHITE);
        roadGroup.setRenderingProperties(roadProperties);
        HighwayGroup primaryGroup = this.highwayLayer.getGroup(HighwayNature.PRIMARY);
        GroupRenderingProperties primaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        primaryGroup.setRenderingProperties(primaryProperties);
        HighwayGroup secondaryGroup = this.highwayLayer.getGroup(HighwayNature.SECONDARY);
        GroupRenderingProperties secondaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        secondaryGroup.setRenderingProperties(secondaryProperties);
        HighwayGroup tertiaryGroup = this.highwayLayer.getGroup(HighwayNature.TERTIARY);
        GroupRenderingProperties tertiaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        tertiaryGroup.setRenderingProperties(tertiaryProperties);
        HighwayGroup serviceGroup = this.highwayLayer.getGroup(HighwayNature.SERVICE);
        GroupRenderingProperties serviceProperties = new GroupRenderingProperties(6, Color.WHITE);
        serviceGroup.setRenderingProperties(serviceProperties);
        HighwayGroup motorwayGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY);
        GroupRenderingProperties motorwayProperties = new GroupRenderingProperties(14, Color.WHITE);
        motorwayGroup.setRenderingProperties(motorwayProperties);
        HighwayGroup motorwayLinkGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY_LINK);
        GroupRenderingProperties motorwayLinkProperties = new GroupRenderingProperties(14, Color.WHITE);
        motorwayLinkGroup.setRenderingProperties(motorwayLinkProperties);
        HighwayGroup trunkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK);
        GroupRenderingProperties trunkProperties = new GroupRenderingProperties(14, Color.WHITE);
        trunkGroup.setRenderingProperties(trunkProperties);
        HighwayGroup trunkLinkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK_LINK);
        GroupRenderingProperties trunkLinkProperties = new GroupRenderingProperties(14, Color.WHITE);
        trunkLinkGroup.setRenderingProperties(trunkLinkProperties);
        HighwayGroup pedestrianGroup = this.highwayLayer.getGroup(HighwayNature.PEDESTRIAN);
        GroupRenderingProperties pedestrianProperties = new GroupRenderingProperties(6, Color.WHITE);
        pedestrianGroup.setRenderingProperties(pedestrianProperties);
        for (AbstractMapLayer layer : this.layers) {
            map2D.paint(layer);
        }
        return map2D;
    }

    public Map2D createMapD20_256(int startX, int endX, int startY, int endY) {
        Map2D map2D = this.D20_256.createMap2D(startX, endX, startY, endY);
        HighwayGroup residentialGroup = this.highwayLayer.getGroup(HighwayNature.RESIDENTIAL);
        GroupRenderingProperties residentialProperties = new GroupRenderingProperties(14, Color.WHITE);
        residentialGroup.setRenderingProperties(residentialProperties);
        HighwayGroup unclassifiedGroup = this.highwayLayer.getGroup(HighwayNature.UNCLASSIFIED);
        GroupRenderingProperties unclassifiedProperties = new GroupRenderingProperties(14, Color.WHITE);
        unclassifiedGroup.setRenderingProperties(unclassifiedProperties);
        HighwayGroup roadGroup = this.highwayLayer.getGroup(HighwayNature.ROAD);
        GroupRenderingProperties roadProperties = new GroupRenderingProperties(14, Color.WHITE);
        roadGroup.setRenderingProperties(roadProperties);
        HighwayGroup primaryGroup = this.highwayLayer.getGroup(HighwayNature.PRIMARY);
        GroupRenderingProperties primaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        primaryGroup.setRenderingProperties(primaryProperties);
        HighwayGroup secondaryGroup = this.highwayLayer.getGroup(HighwayNature.SECONDARY);
        GroupRenderingProperties secondaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        secondaryGroup.setRenderingProperties(secondaryProperties);
        HighwayGroup tertiaryGroup = this.highwayLayer.getGroup(HighwayNature.TERTIARY);
        GroupRenderingProperties tertiaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        tertiaryGroup.setRenderingProperties(tertiaryProperties);
        HighwayGroup serviceGroup = this.highwayLayer.getGroup(HighwayNature.SERVICE);
        GroupRenderingProperties serviceProperties = new GroupRenderingProperties(6, Color.WHITE);
        serviceGroup.setRenderingProperties(serviceProperties);
        HighwayGroup motorwayGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY);
        GroupRenderingProperties motorwayProperties = new GroupRenderingProperties(14, Color.WHITE);
        motorwayGroup.setRenderingProperties(motorwayProperties);
        HighwayGroup motorwayLinkGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY_LINK);
        GroupRenderingProperties motorwayLinkProperties = new GroupRenderingProperties(14, Color.WHITE);
        motorwayLinkGroup.setRenderingProperties(motorwayLinkProperties);
        HighwayGroup trunkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK);
        GroupRenderingProperties trunkProperties = new GroupRenderingProperties(14, Color.WHITE);
        trunkGroup.setRenderingProperties(trunkProperties);
        HighwayGroup trunkLinkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK_LINK);
        GroupRenderingProperties trunkLinkProperties = new GroupRenderingProperties(14, Color.WHITE);
        trunkLinkGroup.setRenderingProperties(trunkLinkProperties);
        HighwayGroup pedestrianGroup = this.highwayLayer.getGroup(HighwayNature.PEDESTRIAN);
        GroupRenderingProperties pedestrianProperties = new GroupRenderingProperties(6, Color.WHITE);
        pedestrianGroup.setRenderingProperties(pedestrianProperties);
        for (AbstractMapLayer layer : this.layers) {
            map2D.paint(layer);
        }
        return map2D;
    }

    public Map2D createMapD19_256(int startX, int endX, int startY, int endY) {
        Map2D map2D = this.D19_256.createMap2D(startX, endX, startY, endY);
        HighwayGroup residentialGroup = this.highwayLayer.getGroup(HighwayNature.RESIDENTIAL);
        GroupRenderingProperties residentialProperties = new GroupRenderingProperties(14, Color.WHITE);
        residentialGroup.setRenderingProperties(residentialProperties);
        HighwayGroup unclassifiedGroup = this.highwayLayer.getGroup(HighwayNature.UNCLASSIFIED);
        GroupRenderingProperties unclassifiedProperties = new GroupRenderingProperties(14, Color.WHITE);
        unclassifiedGroup.setRenderingProperties(unclassifiedProperties);
        HighwayGroup roadGroup = this.highwayLayer.getGroup(HighwayNature.ROAD);
        GroupRenderingProperties roadProperties = new GroupRenderingProperties(14, Color.WHITE);
        roadGroup.setRenderingProperties(roadProperties);
        HighwayGroup primaryGroup = this.highwayLayer.getGroup(HighwayNature.PRIMARY);
        GroupRenderingProperties primaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        primaryGroup.setRenderingProperties(primaryProperties);
        HighwayGroup secondaryGroup = this.highwayLayer.getGroup(HighwayNature.SECONDARY);
        GroupRenderingProperties secondaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        secondaryGroup.setRenderingProperties(secondaryProperties);
        HighwayGroup tertiaryGroup = this.highwayLayer.getGroup(HighwayNature.TERTIARY);
        GroupRenderingProperties tertiaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        tertiaryGroup.setRenderingProperties(tertiaryProperties);
        HighwayGroup serviceGroup = this.highwayLayer.getGroup(HighwayNature.SERVICE);
        GroupRenderingProperties serviceProperties = new GroupRenderingProperties(6, Color.WHITE);
        serviceGroup.setRenderingProperties(serviceProperties);
        HighwayGroup motorwayGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY);
        GroupRenderingProperties motorwayProperties = new GroupRenderingProperties(14, Color.WHITE);
        motorwayGroup.setRenderingProperties(motorwayProperties);
        HighwayGroup motorwayLinkGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY_LINK);
        GroupRenderingProperties motorwayLinkProperties = new GroupRenderingProperties(14, Color.WHITE);
        motorwayLinkGroup.setRenderingProperties(motorwayLinkProperties);
        HighwayGroup trunkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK);
        GroupRenderingProperties trunkProperties = new GroupRenderingProperties(14, Color.WHITE);
        trunkGroup.setRenderingProperties(trunkProperties);
        HighwayGroup trunkLinkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK_LINK);
        GroupRenderingProperties trunkLinkProperties = new GroupRenderingProperties(14, Color.WHITE);
        trunkLinkGroup.setRenderingProperties(trunkLinkProperties);
        HighwayGroup pedestrianGroup = this.highwayLayer.getGroup(HighwayNature.PEDESTRIAN);
        GroupRenderingProperties pedestrianProperties = new GroupRenderingProperties(6, Color.WHITE);
        pedestrianGroup.setRenderingProperties(pedestrianProperties);
        for (AbstractMapLayer layer : this.layers) {
            map2D.paint(layer);
        }
        return map2D;
    }

    public Map2D createMapD18_256(int startX, int endX, int startY, int endY) {
        Map2D map2D = this.D18_256.createMap2D(startX, endX, startY, endY);
        HighwayGroup residentialGroup = this.highwayLayer.getGroup(HighwayNature.RESIDENTIAL);
        GroupRenderingProperties residentialProperties = new GroupRenderingProperties(14, Color.WHITE);
        residentialGroup.setRenderingProperties(residentialProperties);
        HighwayGroup unclassifiedGroup = this.highwayLayer.getGroup(HighwayNature.UNCLASSIFIED);
        GroupRenderingProperties unclassifiedProperties = new GroupRenderingProperties(14, Color.WHITE);
        unclassifiedGroup.setRenderingProperties(unclassifiedProperties);
        HighwayGroup roadGroup = this.highwayLayer.getGroup(HighwayNature.ROAD);
        GroupRenderingProperties roadProperties = new GroupRenderingProperties(14, Color.WHITE);
        roadGroup.setRenderingProperties(roadProperties);
        HighwayGroup primaryGroup = this.highwayLayer.getGroup(HighwayNature.PRIMARY);
        GroupRenderingProperties primaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        primaryGroup.setRenderingProperties(primaryProperties);
        HighwayGroup secondaryGroup = this.highwayLayer.getGroup(HighwayNature.SECONDARY);
        GroupRenderingProperties secondaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        secondaryGroup.setRenderingProperties(secondaryProperties);
        HighwayGroup tertiaryGroup = this.highwayLayer.getGroup(HighwayNature.TERTIARY);
        GroupRenderingProperties tertiaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        tertiaryGroup.setRenderingProperties(tertiaryProperties);
        HighwayGroup serviceGroup = this.highwayLayer.getGroup(HighwayNature.SERVICE);
        GroupRenderingProperties serviceProperties = new GroupRenderingProperties(6, Color.WHITE);
        serviceGroup.setRenderingProperties(serviceProperties);
        HighwayGroup motorwayGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY);
        GroupRenderingProperties motorwayProperties = new GroupRenderingProperties(14, Color.WHITE);
        motorwayGroup.setRenderingProperties(motorwayProperties);
        HighwayGroup motorwayLinkGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY_LINK);
        GroupRenderingProperties motorwayLinkProperties = new GroupRenderingProperties(14, Color.WHITE);
        motorwayLinkGroup.setRenderingProperties(motorwayLinkProperties);
        HighwayGroup trunkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK);
        GroupRenderingProperties trunkProperties = new GroupRenderingProperties(14, Color.WHITE);
        trunkGroup.setRenderingProperties(trunkProperties);
        HighwayGroup trunkLinkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK_LINK);
        GroupRenderingProperties trunkLinkProperties = new GroupRenderingProperties(14, Color.WHITE);
        trunkLinkGroup.setRenderingProperties(trunkLinkProperties);
        HighwayGroup pedestrianGroup = this.highwayLayer.getGroup(HighwayNature.PEDESTRIAN);
        GroupRenderingProperties pedestrianProperties = new GroupRenderingProperties(6, Color.WHITE);
        pedestrianGroup.setRenderingProperties(pedestrianProperties);
        for (AbstractMapLayer layer : this.layers) {
            map2D.paint(layer);
        }
        return map2D;
    }

    public Map2D createMapD17_256(int startX, int endX, int startY, int endY) {
        Map2D map2D = this.D17_256.createMap2D(startX, endX, startY, endY);
        HighwayGroup residentialGroup = this.highwayLayer.getGroup(HighwayNature.RESIDENTIAL);
        GroupRenderingProperties residentialProperties = new GroupRenderingProperties(14, Color.WHITE);
        residentialGroup.setRenderingProperties(residentialProperties);
        HighwayGroup unclassifiedGroup = this.highwayLayer.getGroup(HighwayNature.UNCLASSIFIED);
        GroupRenderingProperties unclassifiedProperties = new GroupRenderingProperties(14, Color.WHITE);
        unclassifiedGroup.setRenderingProperties(unclassifiedProperties);
        HighwayGroup roadGroup = this.highwayLayer.getGroup(HighwayNature.ROAD);
        GroupRenderingProperties roadProperties = new GroupRenderingProperties(14, Color.WHITE);
        roadGroup.setRenderingProperties(roadProperties);
        HighwayGroup primaryGroup = this.highwayLayer.getGroup(HighwayNature.PRIMARY);
        GroupRenderingProperties primaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        primaryGroup.setRenderingProperties(primaryProperties);
        HighwayGroup secondaryGroup = this.highwayLayer.getGroup(HighwayNature.SECONDARY);
        GroupRenderingProperties secondaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        secondaryGroup.setRenderingProperties(secondaryProperties);
        HighwayGroup tertiaryGroup = this.highwayLayer.getGroup(HighwayNature.TERTIARY);
        GroupRenderingProperties tertiaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        tertiaryGroup.setRenderingProperties(tertiaryProperties);
        HighwayGroup serviceGroup = this.highwayLayer.getGroup(HighwayNature.SERVICE);
        GroupRenderingProperties serviceProperties = new GroupRenderingProperties(6, Color.WHITE);
        serviceGroup.setRenderingProperties(serviceProperties);
        HighwayGroup motorwayGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY);
        GroupRenderingProperties motorwayProperties = new GroupRenderingProperties(14, Color.WHITE);
        motorwayGroup.setRenderingProperties(motorwayProperties);
        HighwayGroup motorwayLinkGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY_LINK);
        GroupRenderingProperties motorwayLinkProperties = new GroupRenderingProperties(14, Color.WHITE);
        motorwayLinkGroup.setRenderingProperties(motorwayLinkProperties);
        HighwayGroup trunkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK);
        GroupRenderingProperties trunkProperties = new GroupRenderingProperties(14, Color.WHITE);
        trunkGroup.setRenderingProperties(trunkProperties);
        HighwayGroup trunkLinkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK_LINK);
        GroupRenderingProperties trunkLinkProperties = new GroupRenderingProperties(14, Color.WHITE);
        trunkLinkGroup.setRenderingProperties(trunkLinkProperties);
        HighwayGroup pedestrianGroup = this.highwayLayer.getGroup(HighwayNature.PEDESTRIAN);
        GroupRenderingProperties pedestrianProperties = new GroupRenderingProperties(6, Color.WHITE);
        pedestrianGroup.setRenderingProperties(pedestrianProperties);
        for (AbstractMapLayer layer : this.layers) {
            map2D.paint(layer);
        }
        return map2D;
    }

    public Map2D createMapD17_128(int startX, int endX, int startY, int endY) {
        Map2D map2D = this.D17_128.createMap2D(startX, endX, startY, endY);
        HighwayGroup residentialGroup = this.highwayLayer.getGroup(HighwayNature.RESIDENTIAL);
        GroupRenderingProperties residentialProperties = new GroupRenderingProperties(14, Color.WHITE);
        residentialGroup.setRenderingProperties(residentialProperties);
        HighwayGroup unclassifiedGroup = this.highwayLayer.getGroup(HighwayNature.UNCLASSIFIED);
        GroupRenderingProperties unclassifiedProperties = new GroupRenderingProperties(14, Color.WHITE);
        unclassifiedGroup.setRenderingProperties(unclassifiedProperties);
        HighwayGroup roadGroup = this.highwayLayer.getGroup(HighwayNature.ROAD);
        GroupRenderingProperties roadProperties = new GroupRenderingProperties(14, Color.WHITE);
        roadGroup.setRenderingProperties(roadProperties);
        HighwayGroup primaryGroup = this.highwayLayer.getGroup(HighwayNature.PRIMARY);
        GroupRenderingProperties primaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        primaryGroup.setRenderingProperties(primaryProperties);
        HighwayGroup secondaryGroup = this.highwayLayer.getGroup(HighwayNature.SECONDARY);
        GroupRenderingProperties secondaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        secondaryGroup.setRenderingProperties(secondaryProperties);
        HighwayGroup tertiaryGroup = this.highwayLayer.getGroup(HighwayNature.TERTIARY);
        GroupRenderingProperties tertiaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        tertiaryGroup.setRenderingProperties(tertiaryProperties);
        HighwayGroup serviceGroup = this.highwayLayer.getGroup(HighwayNature.SERVICE);
        GroupRenderingProperties serviceProperties = new GroupRenderingProperties(6, Color.WHITE);
        serviceGroup.setRenderingProperties(serviceProperties);
        HighwayGroup motorwayGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY);
        GroupRenderingProperties motorwayProperties = new GroupRenderingProperties(14, Color.WHITE);
        motorwayGroup.setRenderingProperties(motorwayProperties);
        HighwayGroup motorwayLinkGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY_LINK);
        GroupRenderingProperties motorwayLinkProperties = new GroupRenderingProperties(14, Color.WHITE);
        motorwayLinkGroup.setRenderingProperties(motorwayLinkProperties);
        HighwayGroup trunkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK);
        GroupRenderingProperties trunkProperties = new GroupRenderingProperties(14, Color.WHITE);
        trunkGroup.setRenderingProperties(trunkProperties);
        HighwayGroup trunkLinkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK_LINK);
        GroupRenderingProperties trunkLinkProperties = new GroupRenderingProperties(14, Color.WHITE);
        trunkLinkGroup.setRenderingProperties(trunkLinkProperties);
        HighwayGroup pedestrianGroup = this.highwayLayer.getGroup(HighwayNature.PEDESTRIAN);
        GroupRenderingProperties pedestrianProperties = new GroupRenderingProperties(6, Color.WHITE);
        pedestrianGroup.setRenderingProperties(pedestrianProperties);
        for (AbstractMapLayer layer : this.layers) {
            map2D.paint(layer);
        }
        return map2D;
    }

    public Map2D createMapD16_256(int startX, int endX, int startY, int endY) {
        Map2D map2D = this.D16_256.createMap2D(startX, endX, startY, endY);
        HighwayGroup residentialGroup = this.highwayLayer.getGroup(HighwayNature.RESIDENTIAL);
        GroupRenderingProperties residentialProperties = new GroupRenderingProperties(10, Color.WHITE);
        residentialGroup.setRenderingProperties(residentialProperties);
        HighwayGroup unclassifiedGroup = this.highwayLayer.getGroup(HighwayNature.UNCLASSIFIED);
        GroupRenderingProperties unclassifiedProperties = new GroupRenderingProperties(10, Color.WHITE);
        unclassifiedGroup.setRenderingProperties(unclassifiedProperties);
        HighwayGroup roadGroup = this.highwayLayer.getGroup(HighwayNature.ROAD);
        GroupRenderingProperties roadProperties = new GroupRenderingProperties(10, Color.WHITE);
        roadGroup.setRenderingProperties(roadProperties);
        HighwayGroup primaryGroup = this.highwayLayer.getGroup(HighwayNature.PRIMARY);
        GroupRenderingProperties primaryProperties = new GroupRenderingProperties(12, Color.WHITE);
        primaryGroup.setRenderingProperties(primaryProperties);
        HighwayGroup secondaryGroup = this.highwayLayer.getGroup(HighwayNature.SECONDARY);
        GroupRenderingProperties secondaryProperties = new GroupRenderingProperties(12, Color.WHITE);
        secondaryGroup.setRenderingProperties(secondaryProperties);
        HighwayGroup tertiaryGroup = this.highwayLayer.getGroup(HighwayNature.TERTIARY);
        GroupRenderingProperties tertiaryProperties = new GroupRenderingProperties(12, Color.WHITE);
        tertiaryGroup.setRenderingProperties(tertiaryProperties);
        HighwayGroup serviceGroup = this.highwayLayer.getGroup(HighwayNature.SERVICE);
        GroupRenderingProperties serviceProperties = new GroupRenderingProperties(4, Color.WHITE);
        serviceGroup.setRenderingProperties(serviceProperties);
        HighwayGroup motorwayGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY);
        GroupRenderingProperties motorwayProperties = new GroupRenderingProperties(14, Color.WHITE);
        motorwayGroup.setRenderingProperties(motorwayProperties);
        HighwayGroup motorwayLinkGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY_LINK);
        GroupRenderingProperties motorwayLinkProperties = new GroupRenderingProperties(14, Color.WHITE);
        motorwayLinkGroup.setRenderingProperties(motorwayLinkProperties);
        HighwayGroup trunkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK);
        GroupRenderingProperties trunkProperties = new GroupRenderingProperties(14, Color.WHITE);
        trunkGroup.setRenderingProperties(trunkProperties);
        HighwayGroup trunkLinkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK_LINK);
        GroupRenderingProperties trunkLinkProperties = new GroupRenderingProperties(14, Color.WHITE);
        trunkLinkGroup.setRenderingProperties(trunkLinkProperties);
        HighwayGroup pedestrianGroup = this.highwayLayer.getGroup(HighwayNature.PEDESTRIAN);
        GroupRenderingProperties pedestrianProperties = new GroupRenderingProperties(6, Color.WHITE);
        pedestrianGroup.setRenderingProperties(pedestrianProperties);
        for (AbstractMapLayer layer : this.layers) {
            map2D.paint(layer);
        }
        return map2D;
    }

    public Map2D createMapD16_128(int startX, int endX, int startY, int endY) {
        Map2D map2D = this.D16_256.createMap2D(startX, endX, startY, endY);
        HighwayGroup residentialGroup = this.highwayLayer.getGroup(HighwayNature.RESIDENTIAL);
        GroupRenderingProperties residentialProperties = new GroupRenderingProperties(10, Color.WHITE);
        residentialGroup.setRenderingProperties(residentialProperties);
        HighwayGroup unclassifiedGroup = this.highwayLayer.getGroup(HighwayNature.UNCLASSIFIED);
        GroupRenderingProperties unclassifiedProperties = new GroupRenderingProperties(10, Color.WHITE);
        unclassifiedGroup.setRenderingProperties(unclassifiedProperties);
        HighwayGroup roadGroup = this.highwayLayer.getGroup(HighwayNature.ROAD);
        GroupRenderingProperties roadProperties = new GroupRenderingProperties(10, Color.WHITE);
        roadGroup.setRenderingProperties(roadProperties);
        HighwayGroup primaryGroup = this.highwayLayer.getGroup(HighwayNature.PRIMARY);
        GroupRenderingProperties primaryProperties = new GroupRenderingProperties(12, Color.WHITE);
        primaryGroup.setRenderingProperties(primaryProperties);
        HighwayGroup secondaryGroup = this.highwayLayer.getGroup(HighwayNature.SECONDARY);
        GroupRenderingProperties secondaryProperties = new GroupRenderingProperties(12, Color.WHITE);
        secondaryGroup.setRenderingProperties(secondaryProperties);
        HighwayGroup tertiaryGroup = this.highwayLayer.getGroup(HighwayNature.TERTIARY);
        GroupRenderingProperties tertiaryProperties = new GroupRenderingProperties(12, Color.WHITE);
        tertiaryGroup.setRenderingProperties(tertiaryProperties);
        HighwayGroup serviceGroup = this.highwayLayer.getGroup(HighwayNature.SERVICE);
        GroupRenderingProperties serviceProperties = new GroupRenderingProperties(4, Color.WHITE);
        serviceGroup.setRenderingProperties(serviceProperties);
        HighwayGroup motorwayGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY);
        GroupRenderingProperties motorwayProperties = new GroupRenderingProperties(14, Color.WHITE);
        motorwayGroup.setRenderingProperties(motorwayProperties);
        HighwayGroup motorwayLinkGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY_LINK);
        GroupRenderingProperties motorwayLinkProperties = new GroupRenderingProperties(14, Color.WHITE);
        motorwayLinkGroup.setRenderingProperties(motorwayLinkProperties);
        HighwayGroup trunkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK);
        GroupRenderingProperties trunkProperties = new GroupRenderingProperties(14, Color.WHITE);
        trunkGroup.setRenderingProperties(trunkProperties);
        HighwayGroup trunkLinkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK_LINK);
        GroupRenderingProperties trunkLinkProperties = new GroupRenderingProperties(14, Color.WHITE);
        trunkLinkGroup.setRenderingProperties(trunkLinkProperties);
        HighwayGroup pedestrianGroup = this.highwayLayer.getGroup(HighwayNature.PEDESTRIAN);
        GroupRenderingProperties pedestrianProperties = new GroupRenderingProperties(6, Color.WHITE);
        pedestrianGroup.setRenderingProperties(pedestrianProperties);
        for (AbstractMapLayer layer : this.layers) {
            map2D.paint(layer);
        }
        return map2D;
    }

    public Map2D createMapD15_256(int startX, int endX, int startY, int endY) {
        Map2D map2D = this.D15_256.createMap2D(startX, endX, startY, endY);
        Font streetCompressed12 = new Font("Street - Compressed", 0, 12);
        Font streetCompressed10 = new Font("Street - Compressed", 0, 10);
        Font mentone12 = new Font("Mentone", 0, 12);
        Font mentone10 = new Font("Mentone", 0, 10);
        Font yorkville12 = new Font("yorkville", 0, 12);
        Font yorkville10 = new Font("yorkville", 0, 10);
        Font roadway12 = new Font("Roadway", 0, 12);
        Font roadway10 = new Font("Roadway", 0, 10);
        Font ptfNordic12 = new Font("PTF NORDIC Rnd", 0, 12);
        Font ptfNordic10 = new Font("PTF NORDIC Rnd", 0, 10);
        Font noMovement12 = new Font("N.O.- Movement", 0, 12);
        Font noMovement10 = new Font("N.O.- Movement", 0, 10);
        HighwayGroup residentialGroup = this.highwayLayer.getGroup(HighwayNature.RESIDENTIAL);
        GroupRenderingProperties residentialProperties = new GroupRenderingProperties(8, Color.WHITE);
        residentialProperties.setGlyphFont(mentone10);
        residentialGroup.setRenderingProperties(residentialProperties);
        HighwayGroup unclassifiedGroup = this.highwayLayer.getGroup(HighwayNature.UNCLASSIFIED);
        GroupRenderingProperties unclassifiedProperties = new GroupRenderingProperties(8, Color.WHITE);
        unclassifiedProperties.setGlyphFont(noMovement12);
        unclassifiedGroup.setRenderingProperties(unclassifiedProperties);
        HighwayGroup roadGroup = this.highwayLayer.getGroup(HighwayNature.ROAD);
        GroupRenderingProperties roadProperties = new GroupRenderingProperties(8, Color.WHITE);
        unclassifiedProperties.setGlyphFont(noMovement12);
        roadGroup.setRenderingProperties(roadProperties);
        HighwayGroup primaryGroup = this.highwayLayer.getGroup(HighwayNature.PRIMARY);
        GroupRenderingProperties primaryProperties = new GroupRenderingProperties(10, Color.WHITE);
        primaryProperties.setGlyphFont(noMovement12);
        primaryGroup.setRenderingProperties(primaryProperties);
        HighwayGroup secondaryGroup = this.highwayLayer.getGroup(HighwayNature.SECONDARY);
        GroupRenderingProperties secondaryProperties = new GroupRenderingProperties(10, Color.WHITE);
        secondaryProperties.setGlyphFont(noMovement12);
        secondaryGroup.setRenderingProperties(secondaryProperties);
        HighwayGroup tertiaryGroup = this.highwayLayer.getGroup(HighwayNature.TERTIARY);
        GroupRenderingProperties tertiaryProperties = new GroupRenderingProperties(10, Color.WHITE);
        tertiaryProperties.setGlyphFont(noMovement12);
        tertiaryGroup.setRenderingProperties(tertiaryProperties);
        HighwayGroup serviceGroup = this.highwayLayer.getGroup(HighwayNature.SERVICE);
        GroupRenderingProperties serviceProperties = new GroupRenderingProperties(6, Color.WHITE);
        serviceGroup.setRenderingProperties(serviceProperties);
        HighwayGroup motorwayGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY);
        GroupRenderingProperties motorwayProperties = new GroupRenderingProperties(10, Color.WHITE);
        motorwayGroup.setRenderingProperties(motorwayProperties);
        HighwayGroup motorwayLinkGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY_LINK);
        GroupRenderingProperties motorwayLinkProperties = new GroupRenderingProperties(10, Color.WHITE);
        motorwayLinkGroup.setRenderingProperties(motorwayLinkProperties);
        HighwayGroup trunkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK);
        GroupRenderingProperties trunkProperties = new GroupRenderingProperties(10, Color.WHITE);
        trunkGroup.setRenderingProperties(trunkProperties);
        HighwayGroup trunkLinkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK_LINK);
        GroupRenderingProperties trunkLinkProperties = new GroupRenderingProperties(10, Color.WHITE);
        trunkLinkGroup.setRenderingProperties(trunkLinkProperties);
        HighwayGroup pedestrianGroup = this.highwayLayer.getGroup(HighwayNature.PEDESTRIAN);
        GroupRenderingProperties pedestrianProperties = new GroupRenderingProperties(10, Color.WHITE);
        pedestrianGroup.setRenderingProperties(pedestrianProperties);
        for (AbstractMapLayer layer : this.layers) {
            map2D.paint(layer);
        }
        return map2D;
    }

    public Map2D createMapD15_128(int startX, int endX, int startY, int endY) {
        Map2D map2D = this.D15_128.createMap2D(startX, endX, startY, endY);
        Font streetCompressed12 = new Font("Street - Compressed", 0, 12);
        Font streetCompressed10 = new Font("Street - Compressed", 0, 10);
        Font mentone12 = new Font("Mentone", 0, 12);
        Font mentone10 = new Font("Mentone", 0, 10);
        Font mentone8 = new Font("Mentone", 0, 8);
        Font yorkville12 = new Font("yorkville", 0, 12);
        Font yorkville10 = new Font("yorkville", 0, 10);
        Font yorkville8 = new Font("yorkville", 0, 10);
        Font roadway12 = new Font("Roadway", 0, 12);
        Font roadway10 = new Font("Roadway", 0, 10);
        Font ptfNordic12 = new Font("PTF NORDIC Rnd", 0, 12);
        Font ptfNordic10 = new Font("PTF NORDIC Rnd", 0, 10);
        Font ptfNordic8 = new Font("PTF NORDIC Rnd", 0, 8);
        Font noMovement12 = new Font("N.O.- Movement", 0, 12);
        Font noMovement10 = new Font("N.O.- Movement", 0, 10);
        Font noMovement8 = new Font("N.O.- Movement", 0, 8);
        HighwayGroup residentialGroup = this.highwayLayer.getGroup(HighwayNature.RESIDENTIAL);
        GroupRenderingProperties residentialProperties = new GroupRenderingProperties(4, Color.WHITE);
        residentialProperties.setGlyphFont(mentone10);
        residentialGroup.setRenderingProperties(residentialProperties);
        HighwayGroup unclassifiedGroup = this.highwayLayer.getGroup(HighwayNature.UNCLASSIFIED);
        GroupRenderingProperties unclassifiedProperties = new GroupRenderingProperties(4, Color.WHITE);
        unclassifiedProperties.setGlyphFont(mentone10);
        unclassifiedGroup.setRenderingProperties(unclassifiedProperties);
        HighwayGroup serviceGroup = this.highwayLayer.getGroup(HighwayNature.SERVICE);
        GroupRenderingProperties serviceProperties = new GroupRenderingProperties(2, Color.WHITE);
        serviceGroup.setRenderingProperties(serviceProperties);
        HighwayGroup roadGroup = this.highwayLayer.getGroup(HighwayNature.ROAD);
        GroupRenderingProperties roadProperties = new GroupRenderingProperties(4, Color.WHITE);
        unclassifiedProperties.setGlyphFont(mentone10);
        roadGroup.setRenderingProperties(roadProperties);
        HighwayGroup primaryGroup = this.highwayLayer.getGroup(HighwayNature.PRIMARY);
        GroupRenderingProperties primaryProperties = new GroupRenderingProperties(6, Color.WHITE);
        primaryProperties.setGlyphFont(mentone12);
        primaryGroup.setRenderingProperties(primaryProperties);
        HighwayGroup secondaryGroup = this.highwayLayer.getGroup(HighwayNature.SECONDARY);
        GroupRenderingProperties secondaryProperties = new GroupRenderingProperties(8, Color.WHITE);
        secondaryProperties.setGlyphFont(mentone12);
        secondaryGroup.setRenderingProperties(secondaryProperties);
        HighwayGroup tertiaryGroup = this.highwayLayer.getGroup(HighwayNature.TERTIARY);
        GroupRenderingProperties tertiaryProperties = new GroupRenderingProperties(8, Color.WHITE);
        tertiaryProperties.setGlyphFont(mentone12);
        tertiaryGroup.setRenderingProperties(tertiaryProperties);
        HighwayGroup motorwayGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY);
        GroupRenderingProperties motorwayProperties = new GroupRenderingProperties(8, Color.WHITE);
        motorwayGroup.setRenderingProperties(motorwayProperties);
        HighwayGroup motorwayLinkGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY_LINK);
        GroupRenderingProperties motorwayLinkProperties = new GroupRenderingProperties(6, Color.WHITE);
        motorwayLinkGroup.setRenderingProperties(motorwayLinkProperties);
        HighwayGroup trunkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK);
        GroupRenderingProperties trunkProperties = new GroupRenderingProperties(6, Color.WHITE);
        trunkGroup.setRenderingProperties(trunkProperties);
        HighwayGroup trunkLinkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK_LINK);
        GroupRenderingProperties trunkLinkProperties = new GroupRenderingProperties(6, Color.WHITE);
        trunkLinkGroup.setRenderingProperties(trunkLinkProperties);
        HighwayGroup pedestrianGroup = this.highwayLayer.getGroup(HighwayNature.PEDESTRIAN);
        GroupRenderingProperties pedestrianProperties = new GroupRenderingProperties(6, Color.WHITE);
        pedestrianGroup.setRenderingProperties(pedestrianProperties);
        for (AbstractMapLayer layer : this.layers) {
            map2D.paint(layer);
        }
        return map2D;
    }

    public Map2D createMapD15_128_HIGHWAYS(int startX, int endX, int startY, int endY) {
        Map2D map2D = this.D15_128.createMap2D(startX, endX, startY, endY);
        Font streetCompressed12 = new Font("Street - Compressed", 0, 12);
        Font streetCompressed10 = new Font("Street - Compressed", 0, 10);
        Font mentone12 = new Font("Mentone", 0, 12);
        Font mentone10 = new Font("Mentone", 0, 10);
        Font mentone8 = new Font("Mentone", 0, 8);
        Font yorkville12 = new Font("yorkville", 0, 12);
        Font yorkville10 = new Font("yorkville", 0, 10);
        Font yorkville8 = new Font("yorkville", 0, 10);
        Font roadway12 = new Font("Roadway", 0, 12);
        Font roadway10 = new Font("Roadway", 0, 10);
        Font ptfNordic12 = new Font("PTF NORDIC Rnd", 0, 12);
        Font ptfNordic10 = new Font("PTF NORDIC Rnd", 0, 10);
        Font ptfNordic8 = new Font("PTF NORDIC Rnd", 0, 8);
        Font noMovement12 = new Font("N.O.- Movement", 0, 12);
        Font noMovement10 = new Font("N.O.- Movement", 0, 10);
        Font noMovement8 = new Font("N.O.- Movement", 0, 8);
        this.backgroundLayer.setOpaque(true);
        HighwayGroup residentialGroup = this.highwayLayer.getGroup(HighwayNature.RESIDENTIAL);
        GroupRenderingProperties residentialProperties = new GroupRenderingProperties(4, Color.WHITE);
        residentialProperties.setGlyphFont(mentone10);
        residentialGroup.setRenderingProperties(residentialProperties);
        HighwayGroup unclassifiedGroup = this.highwayLayer.getGroup(HighwayNature.UNCLASSIFIED);
        GroupRenderingProperties unclassifiedProperties = new GroupRenderingProperties(4, Color.WHITE);
        unclassifiedProperties.setGlyphFont(mentone10);
        unclassifiedGroup.setRenderingProperties(unclassifiedProperties);
        HighwayGroup serviceGroup = this.highwayLayer.getGroup(HighwayNature.SERVICE);
        GroupRenderingProperties serviceProperties = new GroupRenderingProperties(2, Color.WHITE);
        serviceGroup.setRenderingProperties(serviceProperties);
        HighwayGroup roadGroup = this.highwayLayer.getGroup(HighwayNature.ROAD);
        GroupRenderingProperties roadProperties = new GroupRenderingProperties(4, Color.WHITE);
        unclassifiedProperties.setGlyphFont(mentone10);
        roadGroup.setRenderingProperties(roadProperties);
        HighwayGroup primaryGroup = this.highwayLayer.getGroup(HighwayNature.PRIMARY);
        GroupRenderingProperties primaryProperties = new GroupRenderingProperties(6, Color.WHITE);
        primaryProperties.setGlyphFont(mentone12);
        primaryGroup.setRenderingProperties(primaryProperties);
        HighwayGroup secondaryGroup = this.highwayLayer.getGroup(HighwayNature.SECONDARY);
        GroupRenderingProperties secondaryProperties = new GroupRenderingProperties(8, Color.WHITE);
        secondaryProperties.setGlyphFont(mentone12);
        secondaryGroup.setRenderingProperties(secondaryProperties);
        HighwayGroup tertiaryGroup = this.highwayLayer.getGroup(HighwayNature.TERTIARY);
        GroupRenderingProperties tertiaryProperties = new GroupRenderingProperties(8, Color.WHITE);
        tertiaryProperties.setGlyphFont(mentone12);
        tertiaryGroup.setRenderingProperties(tertiaryProperties);
        HighwayGroup motorwayGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY);
        GroupRenderingProperties motorwayProperties = new GroupRenderingProperties(8, Color.WHITE);
        motorwayGroup.setRenderingProperties(motorwayProperties);
        HighwayGroup motorwayLinkGroup = this.highwayLayer.getGroup(HighwayNature.MOTORWAY_LINK);
        GroupRenderingProperties motorwayLinkProperties = new GroupRenderingProperties(6, Color.WHITE);
        motorwayLinkGroup.setRenderingProperties(motorwayLinkProperties);
        HighwayGroup trunkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK);
        GroupRenderingProperties trunkProperties = new GroupRenderingProperties(6, Color.WHITE);
        trunkGroup.setRenderingProperties(trunkProperties);
        HighwayGroup trunkLinkGroup = this.highwayLayer.getGroup(HighwayNature.TRUNK_LINK);
        GroupRenderingProperties trunkLinkProperties = new GroupRenderingProperties(6, Color.WHITE);
        trunkLinkGroup.setRenderingProperties(trunkLinkProperties);
        HighwayGroup pedestrianGroup = this.highwayLayer.getGroup(HighwayNature.PEDESTRIAN);
        GroupRenderingProperties pedestrianProperties = new GroupRenderingProperties(6, Color.WHITE);
        pedestrianGroup.setRenderingProperties(pedestrianProperties);
        map2D.paint(this.backgroundLayer);
        map2D.paint(this.highwayLayer);
        return map2D;
    }
}

