/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.map.tilegis;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.map.layer.highway.Highway;
import org.jensoft.core.map.layer.landuse.Landuse;
import org.jensoft.core.map.layer.leisure.Leisure;
import org.jensoft.core.map.layer.natural.Natural;
import org.jensoft.core.map.layer.railway.Railway;
import org.jensoft.core.map.layer.waterway.Waterway;
import org.jensoft.core.map.primitive.Node;
import org.jensoft.core.map.primitive.Primitive;
import org.jensoft.core.map.primitive.Way;
import org.jensoft.core.map.tile.Tile;
import org.jensoft.core.map.tile.TileKey;

public class TileGis {
    private PreparedStatement nodeStatement;
    private PreparedStatement wayStatement;
    private PreparedStatement waynodeStatement;
    private PreparedStatement tileStatement;
    private PreparedStatement insertHighwayStatement;
    private PreparedStatement tilehighwayStatement;
    private PreparedStatement updateHighwayStatement;
    private PreparedStatement landuseStatement;
    private PreparedStatement tilelanduseStatement;
    private PreparedStatement leisureStatement;
    private PreparedStatement tileleisureStatement;
    private PreparedStatement waterwayStatement;
    private PreparedStatement tilewaterwayStatement;
    private PreparedStatement railwayStatement;
    private PreparedStatement tilerailwayStatement;
    private PreparedStatement naturalStatement;
    private PreparedStatement tilenaturalStatement;
    private Connection db;
    private Statement selectTileStatement;
    private Statement selectPrimitiveStatement;

    public TileGis() {
        this.openTileGis();
        try {
            this.nodeStatement = this.db.prepareStatement("INSERT INTO tilegis.node  (id,latitude,longitude) VALUES (?,?,?)");
            this.wayStatement = this.db.prepareStatement("INSERT INTO tilegis.way  (id) VALUES (?)");
            this.waynodeStatement = this.db.prepareStatement("INSERT INTO tilegis.way_node  (way_id,node_id) VALUES (?,?)");
            this.tileStatement = this.db.prepareStatement("INSERT INTO tilegis.tile  (x,y) VALUES (?,?)");
            this.insertHighwayStatement = this.db.prepareStatement("INSERT INTO tilegis.highway  (id,nature,name) VALUES (?,?,?)");
            this.tilehighwayStatement = this.db.prepareStatement("INSERT INTO tilegis.tile_highway  (highway_id,x,y) VALUES (?,?,?)");
            this.landuseStatement = this.db.prepareStatement("INSERT INTO tilegis.landuse  (id,nature) VALUES (?,?)");
            this.tilelanduseStatement = this.db.prepareStatement("INSERT INTO tilegis.tile_landuse  (landuse_id,x,y) VALUES (?,?,?)");
            this.leisureStatement = this.db.prepareStatement("INSERT INTO tilegis.leisure  (id,nature) VALUES (?,?)");
            this.tileleisureStatement = this.db.prepareStatement("INSERT INTO tilegis.tile_leisure  (leisure_id,x,y) VALUES (?,?,?)");
            this.waterwayStatement = this.db.prepareStatement("INSERT INTO tilegis.waterway  (id,nature) VALUES (?,?)");
            this.tilewaterwayStatement = this.db.prepareStatement("INSERT INTO tilegis.tile_waterway  (waterway_id,x,y) VALUES (?,?,?)");
            this.railwayStatement = this.db.prepareStatement("INSERT INTO tilegis.railway  (id,nature) VALUES (?,?)");
            this.tilerailwayStatement = this.db.prepareStatement("INSERT INTO tilegis.tile_railway  (railway_id,x,y) VALUES (?,?,?)");
            this.naturalStatement = this.db.prepareStatement("INSERT INTO tilegis.natural  (id,nature) VALUES (?,?)");
            this.selectTileStatement = this.db.createStatement(1005, 1007);
            this.selectPrimitiveStatement = this.db.createStatement(1005, 1007);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Tile selectTileHighways(int x, int y, int zoom) {
        Tile t = new Tile(x, y, zoom);
        ArrayList<Highway> highways = new ArrayList<Highway>();
        try {
            ResultSet highwaysSet = this.selectTileStatement.executeQuery("SELECT highway_id,nature,name from tilegis.tile_highway,tilegis.highway WHERE  tilegis.tile_highway.x = " + x + " AND  tilegis.tile_highway.y = " + y + " AND tilegis.tile_highway.highway_id=tilegis.highway.id" + ";");
            while (highwaysSet.next()) {
                int id = highwaysSet.getInt("highway_id");
                String name = highwaysSet.getString("name");
                String nature = highwaysSet.getString("nature");
                Highway h = new Highway(id, nature);
                h.setName(name);
                highways.add(h);
                this.selectPrimitive(id);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return t;
    }

    private Primitive selectPrimitive(int id) {
        try {
            ResultSet primitiveSet = this.selectPrimitiveStatement.executeQuery("SELECT tilegis.way.id as way_id,tilegis.way_node.node_id as node_id,tilegis.node.latitude as latitude,tilegis.node.longitude as longitude from tilegis.way,tilegis.way_node,tilegis.node WHERE tilegis.way.id = tilegis.way_node.way_id AND tilegis.way_node.node_id = tilegis.node.id AND tilegis.way.id = " + id + ";");
            while (primitiveSet.next()) {
                int wayid = primitiveSet.getInt("way_id");
                int nodeid = primitiveSet.getInt("node_id");
                double latitude = primitiveSet.getDouble("latitude");
                double longitude = primitiveSet.getDouble("longitude");
            }
            primitiveSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void insertTile(Tile tile) {
        this.insertKey(tile.getKey());
        for (Highway highway : tile.getHighways()) {
            this.insertHighway(tile.getKey(), highway);
        }
        for (Railway railway : tile.getRailways()) {
            this.insertRailway(railway);
        }
        for (Waterway waterway : tile.getWaterways()) {
            this.insertWaterway(waterway);
        }
        for (Landuse landuse : tile.getLanduses()) {
            this.insertLanduse(landuse);
        }
        for (Leisure leisure : tile.getLeisures()) {
            this.insertLeisure(leisure);
        }
        for (Natural natural : tile.getNaturals()) {
            this.insertNatural(natural);
        }
    }

    private void insertKey(TileKey key) {
        try {
            this.tileStatement.setInt(1, key.getX());
            this.tileStatement.setInt(2, key.getY());
            this.tileStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void insertPrimitive(Primitive primitive) {
        Way w = primitive.getWay();
        try {
            this.wayStatement.setInt(1, w.getId());
            this.wayStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        List<Node> nodes = primitive.getNodes();
        for (Node n : nodes) {
            try {
                this.nodeStatement.setInt(1, n.getId());
                this.nodeStatement.setDouble(2, n.getLatitudeAsDouble());
                this.nodeStatement.setDouble(3, n.getLongitudeAsDouble());
                this.nodeStatement.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                this.waynodeStatement.setInt(1, w.getId());
                this.waynodeStatement.setInt(2, n.getId());
                this.waynodeStatement.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void insertHighway(TileKey key, Highway h) {
        try {
            this.insertHighwayStatement.setInt(1, h.getId());
            this.insertHighwayStatement.setString(2, h.getNature());
            this.insertHighwayStatement.setString(3, h.getName());
            this.insertHighwayStatement.executeUpdate();
            this.tilehighwayStatement.setInt(1, h.getId());
            this.tilehighwayStatement.setInt(2, key.getX());
            this.tilehighwayStatement.setInt(3, key.getY());
            this.tilehighwayStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.insertPrimitive(h.getPrimitive());
    }

    public void insertRailway(Railway h) {
        try {
            this.railwayStatement.setInt(1, h.getId());
            this.railwayStatement.setString(2, h.getNature());
            this.railwayStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.insertPrimitive(h.getPrimitive());
    }

    public void insertWaterway(Waterway h) {
        try {
            this.waterwayStatement.setInt(1, h.getId());
            this.waterwayStatement.setString(2, h.getNature());
            this.waterwayStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.insertPrimitive(h.getPrimitive());
    }

    public void insertLanduse(Landuse h) {
        try {
            this.landuseStatement.setInt(1, h.getId());
            this.landuseStatement.setString(2, h.getNature());
            this.landuseStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.insertPrimitive(h.getPrimitive());
    }

    public void insertLeisure(Leisure h) {
        try {
            this.leisureStatement.setInt(1, h.getId());
            this.leisureStatement.setString(2, h.getNature());
            this.leisureStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.insertPrimitive(h.getPrimitive());
    }

    public void insertNatural(Natural h) {
        try {
            this.naturalStatement.setInt(1, h.getId());
            this.naturalStatement.setString(2, h.getNature());
            this.naturalStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.insertPrimitive(h.getPrimitive());
    }

    public void openTileGis() {
        try {
            Class.forName("org.postgresql.Driver");
            this.db = DriverManager.getConnection("jdbc:postgresql://localhost:5432/mposm", "postgres", "password");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void closeTileGis() {
        try {
            this.db.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

