/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import javax.swing.event.EventListenerList;
import org.jensoft.core.device.ContextEntry;
import org.jensoft.core.device.ContextRegistry;
import org.jensoft.core.graphics.AlphaInterpolation;
import org.jensoft.core.graphics.Antialiasing;
import org.jensoft.core.graphics.Dithering;
import org.jensoft.core.graphics.Fractional;
import org.jensoft.core.graphics.Interpolation;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.palette.color.ColorPalette;
import org.jensoft.core.plugin.Plugin;
import org.jensoft.core.plugin.PluginEvent;
import org.jensoft.core.plugin.PluginListener;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;
import org.jensoft.core.view.WidgetRegistry;
import org.jensoft.core.widget.Widget;

public abstract class AbstractPlugin
implements Plugin {
    private View view;
    private Projection proj;
    private boolean lockSelected = false;
    private boolean lockPassive = false;
    private String id;
    private String name;
    private Color themeColor;
    private EventListenerList listenerList = new EventListenerList();
    private String pluginID;
    private boolean selectable = false;
    private WidgetRegistry widgetRegistry;
    private ContextRegistry contextRegistry;
    private Antialiasing antialiasing = Antialiasing.On;
    private TextAntialiasing textAntialising = TextAntialiasing.Off;
    private Fractional fractionalMetrics = Fractional.Off;
    private Interpolation interpolation = Interpolation.NearestNeighbor;
    private Dithering dithering = Dithering.On;
    private AlphaInterpolation alphaInterpolation = AlphaInterpolation.Default;
    private int priority = 0;
    private static PluginOrderComparator priorityComparator = new PluginOrderComparator();
    private PaintBehavior paintBehavior = PaintBehavior.PaintAlways;
    private String lockMessage;
    private boolean showLockMessage = true;
    private String propertyFileName;
    private Properties properties;
    private OnPressListener onPressListener;
    private OnClickListener onClickListener;
    private OnMoveListener onMoveListener;
    private OnDragListener onDragListener;
    private OnEnterListener onEnterListener;
    private OnExitListener onExitListener;
    private OnReleaseListener onReleaseListener;
    private OnWheelListener onWheelListener;

    public PaintBehavior getPaintBehavior() {
        return this.paintBehavior;
    }

    public void setPaintBehavior(PaintBehavior paintBehavior) {
        this.paintBehavior = paintBehavior;
    }

    public String getPropertyFileName() {
        return this.propertyFileName;
    }

    public void setPropertyFileName(String propertyFileName) {
        this.propertyFileName = propertyFileName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public WidgetRegistry getWidgetRegistry() {
        if (this.widgetRegistry == null) {
            this.widgetRegistry = new WidgetRegistry();
            this.widgetRegistry.setHost(this);
        }
        return this.widgetRegistry;
    }

    public void registerWidget(Widget widget) {
        widget.setHost(this);
        if (widget.isCompatiblePlugin()) {
            widget.onRegister();
            this.getWidgetRegistry().register(widget);
        } else {
            System.err.println("incompatible widget " + widget.getClass() + " with plugin" + this.getClass());
        }
    }

    public void registerWidget(Widget ... widgets) {
        for (int i = 0; i < widgets.length; ++i) {
            Widget widget = widgets[i];
            widget.setHost(this);
            widget.onRegister();
            if (!widget.isCompatiblePlugin()) continue;
            this.getWidgetRegistry().register(widget);
        }
    }

    public String getLockMessage() {
        return this.lockMessage;
    }

    public void setLockMessage(String lockMessage) {
        this.lockMessage = lockMessage;
    }

    public boolean isShowLockMessage() {
        return this.showLockMessage;
    }

    public void setShowLockMessage(boolean showLockMessage) {
        this.showLockMessage = showLockMessage;
    }

    public List<Widget> getWidgets() {
        if (this.widgetRegistry == null) {
            return Collections.EMPTY_LIST;
        }
        return this.widgetRegistry.getWidgets();
    }

    public ContextRegistry getContextRegistry() {
        if (this.contextRegistry == null) {
            this.contextRegistry = new ContextRegistry();
            this.contextRegistry.setHost(this);
        }
        return this.contextRegistry;
    }

    public <T extends AbstractPlugin> void registerContext(ContextEntry<T> contextEntry) {
        contextEntry.setHost(this);
        if (contextEntry.isCompatiblePlugin()) {
            this.getContextRegistry().register(contextEntry);
        }
    }

    public <T extends AbstractPlugin> void registerContext(ContextEntry<T> ... contextEntries) {
        for (int i = 0; i < contextEntries.length; ++i) {
            ContextEntry<AbstractPlugin> contextEntry = contextEntries[i];
            contextEntry.setHost(this);
            if (!contextEntry.isCompatiblePlugin()) continue;
            this.getContextRegistry().register(contextEntry);
        }
    }

    public List<ContextEntry<? extends AbstractPlugin>> getContextEntries() {
        if (this.contextRegistry == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getContextRegistry().getContextEntries();
    }

    public static PluginOrderComparator getPriorityComparator() {
        return priorityComparator;
    }

    public void repaintDevice() {
        this.getProjection().getView().repaintDevice();
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Color getThemeColor() {
        if (this.themeColor == null) {
            this.themeColor = ColorPalette.getRandomColor();
        }
        return this.themeColor;
    }

    public void setThemeColor(Color themeColor) {
        this.themeColor = themeColor;
    }

    public String getPluginID() {
        return this.pluginID;
    }

    public void setPluginID(String pluginID) {
        this.pluginID = pluginID;
    }

    protected View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public boolean isLockSelected() {
        return this.lockSelected;
    }

    public void lockSelected() {
        if (!this.isLockSelected()) {
            this.lockSelected = true;
            this.firePluginLockSelected();
            if (this.getProjection() != null && this.getProjection().getView() != null) {
                this.getProjection().getView().repaint();
            }
        }
    }

    public void unlockSelected() {
        if (this.isLockSelected()) {
            this.lockSelected = false;
            this.firePluginUnlockSelected();
            if (this.getProjection() != null && this.getProjection().getView() != null) {
                this.getProjection().getView().repaint();
            }
        }
    }

    public void addPluginListener(PluginListener listener) {
        this.listenerList.add(PluginListener.class, listener);
    }

    public void removePluginListener(PluginListener listener) {
        this.listenerList.remove(PluginListener.class, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePluginLockSelected() {
        Object[] listeners;
        Object[] objectArray = listeners = this.listenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != PluginListener.class) continue;
                ((PluginListener)listeners[i + 1]).pluginSelected(new PluginEvent<AbstractPlugin>(this));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePluginUnlockSelected() {
        Object[] listeners;
        Object[] objectArray = listeners = this.listenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != PluginListener.class) continue;
                ((PluginListener)listeners[i + 1]).pluginUnlockSelected(new PluginEvent<AbstractPlugin>(this));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void lockPassive() {
        this.lockPassive = true;
    }

    public void unlockPassive() {
        this.lockPassive = false;
    }

    public boolean isLockPassive() {
        return this.lockPassive;
    }

    public Projection getProjection() {
        return this.proj;
    }

    public void setProjection(Projection proj) {
        this.proj = proj;
    }

    public void onProjectionRegister() {
    }

    public OnPressListener getOnPressListener() {
        return this.onPressListener;
    }

    public void setOnPressListener(OnPressListener onPressListener) {
        this.onPressListener = onPressListener;
    }

    public void setOnClickListener(OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
    }

    public OnClickListener getOnClickListener() {
        return this.onClickListener;
    }

    public void setOnMoveListener(OnMoveListener onMoveListener) {
        this.onMoveListener = onMoveListener;
    }

    public OnMoveListener getOnMoveListener() {
        return this.onMoveListener;
    }

    public OnDragListener getOnDragListener() {
        return this.onDragListener;
    }

    public void setOnDragListener(OnDragListener onDragListener) {
        this.onDragListener = onDragListener;
    }

    public OnEnterListener getOnEnterListener() {
        return this.onEnterListener;
    }

    public void setOnEnterListener(OnEnterListener onEnterListener) {
        this.onEnterListener = onEnterListener;
    }

    public OnExitListener getOnExitListener() {
        return this.onExitListener;
    }

    public void setOnExitListener(OnExitListener onExitListener) {
        this.onExitListener = onExitListener;
    }

    public OnReleaseListener getOnReleaseListener() {
        return this.onReleaseListener;
    }

    public void setOnReleaseListener(OnReleaseListener onReleaseListener) {
        this.onReleaseListener = onReleaseListener;
    }

    public OnWheelListener getOnWheelListener() {
        return this.onWheelListener;
    }

    public void setOnWheelListener(OnWheelListener onWheelListener) {
        this.onWheelListener = onWheelListener;
    }

    public Antialiasing getAntialiasing() {
        return this.antialiasing;
    }

    public void setAntialiasing(Antialiasing antialiasing) {
        this.antialiasing = antialiasing;
    }

    public TextAntialiasing getTextAntialising() {
        return this.textAntialising;
    }

    public void setTextAntialising(TextAntialiasing textAntialising) {
        this.textAntialising = textAntialising;
    }

    public Fractional getFractionalMetrics() {
        return this.fractionalMetrics;
    }

    public void setFractionalMetrics(Fractional fractionalMetrics) {
        this.fractionalMetrics = fractionalMetrics;
    }

    public Interpolation getInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(Interpolation interpolation) {
        this.interpolation = interpolation;
    }

    public Dithering getDithering() {
        return this.dithering;
    }

    public void setDithering(Dithering dithering) {
        this.dithering = dithering;
    }

    public AlphaInterpolation getAlphaInterpolation() {
        return this.alphaInterpolation;
    }

    public void setAlphaInterpolation(AlphaInterpolation alphaInterpolation) {
        this.alphaInterpolation = alphaInterpolation;
    }

    public void configureGraphics(Graphics2D g2d) {
        this.antialiasing.configureGraphics(g2d);
        this.textAntialising.configureGraphics(g2d);
        this.fractionalMetrics.configureGraphics(g2d);
        this.interpolation.configureGraphics(g2d);
        this.dithering.configureGraphics(g2d);
        this.alphaInterpolation.configureGraphics(g2d);
    }

    protected abstract void paintPlugin(View var1, Graphics2D var2, ViewPart var3);

    @Override
    public final void paint(View view, Graphics2D g2d, ViewPart viewPart) {
        this.configureGraphics(g2d);
        this.paintPlugin(view, g2d, viewPart);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    protected Properties getProperties(String pluginPropertyFile) throws IOException {
        Properties props = new Properties();
        InputStream inputStream = this.getClass().getResourceAsStream(pluginPropertyFile);
        if (inputStream == null) {
            throw new FileNotFoundException("property file '" + pluginPropertyFile + "' not found in the classpath");
        }
        props.load(inputStream);
        return props;
    }

    protected Properties getPropertiesFromClasspath(String pluginPropertyFile) throws IOException {
        Properties props = new Properties();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(pluginPropertyFile);
        if (inputStream == null) {
            throw new FileNotFoundException("property file '" + pluginPropertyFile + "' not found in the classpath");
        }
        props.load(inputStream);
        return props;
    }

    public static class PluginOrderComparator
    implements Comparator<AbstractPlugin> {
        @Override
        public int compare(AbstractPlugin p1, AbstractPlugin p2) {
            return p1.getPriority() - p2.getPriority();
        }
    }

    public static interface OnWheelListener {
        public void onWheel(MouseWheelEvent var1);
    }

    public static interface OnReleaseListener {
        public void onRelease(MouseEvent var1);
    }

    public static interface OnExitListener {
        public void onExit(MouseEvent var1);
    }

    public static interface OnEnterListener {
        public void onEnter(MouseEvent var1);
    }

    public static interface OnDragListener {
        public void onDrag(MouseEvent var1);
    }

    public static interface OnMoveListener {
        public void onMove(MouseEvent var1);
    }

    public static interface OnClickListener {
        public void onClick(MouseEvent var1);
    }

    public static interface OnPressListener {
        public void onPress(MouseEvent var1);
    }

    public static enum PaintBehavior {
        NoPaint,
        PaintIfHostProjectionActive,
        PaintIfPluginIsLockSelected,
        PaintAlways;

    }
}

