/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.imageio.ImageIO;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.Portfolio;
import org.jensoft.core.view.View;
import org.jensoft.core.x2d.binding.AbstractX2DPluginInflater;
import org.jensoft.core.x2d.binding.X2DBinding;

public class PluginPlatform {
    private static PluginPlatform pluginUI;
    private List<AbstractPlugin> plugins = new ArrayList<AbstractPlugin>();
    private List<Projection> projections = new ArrayList<Projection>();

    private PluginPlatform() {
    }

    public static PluginPlatform instance() {
        if (pluginUI == null) {
            pluginUI = new PluginPlatform();
        }
        return pluginUI;
    }

    public List<AbstractPlugin> getPlugins() {
        return this.plugins;
    }

    public List<Projection> getProjections() {
        return this.projections;
    }

    public void register(AbstractPlugin plugin) {
        if (!this.plugins.contains(plugin)) {
            this.plugins.add(plugin);
        }
    }

    public void register(Projection projection) {
        if (!this.projections.contains(projection)) {
            this.projections.add(projection);
        }
    }

    public <T extends AbstractPlugin> List<T> getPlugins(Class<T> c) {
        ArrayList<AbstractPlugin> ps = new ArrayList<AbstractPlugin>();
        for (AbstractPlugin plugin : this.plugins) {
            if (!plugin.getClass().getName().equals(c.getName())) continue;
            ps.add(plugin);
        }
        return ps;
    }

    public <T extends AbstractPlugin> List<T> getPlugins(Class<T> pluginClass, Projection projection) {
        ArrayList<AbstractPlugin> ps = new ArrayList<AbstractPlugin>();
        for (AbstractPlugin plugin : this.plugins) {
            if (plugin.getProjection() == null || !plugin.getProjection().equals(projection) || !plugin.getClass().getName().equals(pluginClass.getName())) continue;
            ps.add(plugin);
        }
        return ps;
    }

    public static void createPortfolio(String packageName, String portfolioDirectory) {
        PluginPlatform.createPortfolio(packageName, portfolioDirectory, -1, -1);
    }

    public static void createPortfolioClass(Class classPortfolio, String portfolioDirectory, int imageWidth, int imageHeight) {
        for (Method method : classPortfolio.getMethods()) {
            if (!method.isAnnotationPresent(Portfolio.class)) continue;
            if (Modifier.isStatic(method.getModifiers())) {
                Portfolio p = method.getAnnotation(Portfolio.class);
                Class<?> returnType = method.getReturnType();
                if (!View.class.isAssignableFrom(returnType)) continue;
                String name = p.name();
                Portfolio.ImageType imageType = p.imageType();
                try {
                    View v = (View)method.invoke(null, new Object[0]);
                    int w = 0;
                    int h = 0;
                    if (imageWidth > 0 && imageHeight > 0) {
                        w = imageWidth;
                        h = imageHeight;
                    } else {
                        w = p.width();
                        h = p.height();
                    }
                    BufferedImage image = v.createViewEmitter().getImageView(w, h);
                    File portfolioDir = new File(portfolioDirectory);
                    portfolioDir.mkdirs();
                    try {
                        System.out.println(classPortfolio.getSimpleName() + " generate portfolio : " + classPortfolio.getCanonicalName() + "#" + method.getName() + " with name :" + name);
                        ImageIO.write((RenderedImage)image, imageType.name().toLowerCase(), new FileOutputStream(portfolioDirectory + File.separator + name + "." + imageType.name().toLowerCase()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                continue;
            }
            System.err.println("Portfolio image not processed, portofolio Method " + method.getName() + " should be 'static'");
        }
    }

    public static void createPortfolio(String packageName, String portfolioDirectory, int imageWidth, int imageHeight) {
        List<Class<?>> portofolioClass = PluginPlatform.scanPortfolio(packageName);
        for (Class<?> c : portofolioClass) {
            PluginPlatform.createPortfolioClass(c, portfolioDirectory, imageWidth, imageHeight);
        }
    }

    public static List<Class<?>> scanPortfolio(String packageName) {
        ArrayList portfolios = new ArrayList();
        try {
            Iterable<Class<?>> classes = PluginPlatform.getClasses(packageName);
            block3: for (Class<?> testClass : classes) {
                for (Method method : testClass.getMethods()) {
                    if (!method.isAnnotationPresent(Portfolio.class)) continue;
                    portfolios.add(testClass);
                    continue block3;
                }
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return portfolios;
    }

    public static List<Class<?>> scanX2DInflater(String packageName) {
        ArrayList inflaters = new ArrayList();
        try {
            Iterable<Class<?>> classes = PluginPlatform.getClasses(packageName);
            for (Class<?> testClass : classes) {
                if (!testClass.isAnnotationPresent(X2DBinding.class)) continue;
                System.err.println("x2d annotation found : " + testClass);
                if (!AbstractX2DPluginInflater.class.isAssignableFrom(testClass)) continue;
                inflaters.add(testClass);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return inflaters;
    }

    private static Iterable<Class<?>> getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList classes = new ArrayList();
        for (File directory : dirs) {
            classes.addAll(PluginPlatform.findClasses(directory, packageName));
        }
        return classes;
    }

    private static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                classes.addAll(PluginPlatform.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            try {
                Class<?> c = Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6));
                classes.add(c);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return classes;
    }

    public static void main(String[] args) {
        List<Class<?>> x2dinflaters = PluginPlatform.scanX2DInflater(X2DBinding.class.getPackage().getName());
    }
}

