/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.background;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jensoft.core.graphics.AlphaInterpolation;
import org.jensoft.core.graphics.Antialiasing;
import org.jensoft.core.graphics.Dithering;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class DeviceGradientBackgroundPlugin
extends AbstractPlugin {
    private Color color1 = new Color(2107191);
    private Color color2 = Color.BLACK;
    private float alpha = 1.0f;

    public DeviceGradientBackgroundPlugin() {
        this.setDithering(Dithering.On);
        this.setAntialiasing(Antialiasing.On);
        this.setAlphaInterpolation(AlphaInterpolation.Quality);
    }

    public DeviceGradientBackgroundPlugin(Color color1, Color color2) {
        this();
        this.color1 = color1;
        this.color2 = color2;
    }

    public DeviceGradientBackgroundPlugin(Color color1, Color color2, float alpha) {
        this();
        this.color1 = color1;
        this.color2 = color2;
        this.alpha = alpha;
    }

    public Color getColor1() {
        return this.color1;
    }

    public void setColor1(Color color1) {
        this.color1 = color1;
    }

    public Color getColor2() {
        return this.color2;
    }

    public void setColor2(Color color2) {
        this.color2 = color2;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    @Override
    protected void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart != ViewPart.Device) {
            return;
        }
        g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
        int width = this.getProjection().getDevice2D().getDeviceWidth();
        int height = this.getProjection().getDevice2D().getDeviceHeight();
        Point2D.Double start = new Point2D.Double(width / 2, 0.0);
        Point2D.Double end = new Point2D.Double(width / 2, height);
        float[] dist = new float[]{0.0f, 1.0f};
        Color[] colors = new Color[]{this.color1, this.color2};
        LinearGradientPaint p = new LinearGradientPaint(start, end, dist, colors);
        g2d.setPaint(p);
        Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, width, height);
        g2d.fill(r);
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }
}

