/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.bubble.painter.effect;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.jensoft.core.plugin.bubble.Bubble;
import org.jensoft.core.plugin.bubble.painter.BubbleEffect;

public class BubbleEffect3
extends BubbleEffect {
    @Override
    public void paintBubble(Graphics2D g2d, Bubble bubble) {
        double centerX = bubble.getHost().getProjection().userToPixel(new Point2D.Double(bubble.getX(), 0.0)).getX();
        double centerY = bubble.getHost().getProjection().userToPixel(new Point2D.Double(0.0, bubble.getY())).getY();
        int radius = (int)(bubble.getRadius() - 5.0);
        int startAngleDegreee = 30;
        int endAngleDegree = 175;
        g2d.setStroke(new BasicStroke(0.4f));
        g2d.setColor(Color.WHITE);
        Arc2D.Double arc2d = new Arc2D.Double(centerX - (double)radius, centerY - (double)radius, 2 * radius, 2 * radius, startAngleDegreee, endAngleDegree - startAngleDegreee, 0);
        Point2D.Double p1 = new Point2D.Double(centerX + (double)radius * Math.cos(Math.toRadians(endAngleDegree)), centerY - (double)radius * Math.sin(Math.toRadians(endAngleDegree)));
        Point2D.Double p2 = new Point2D.Double(centerX + (double)radius * Math.cos(Math.toRadians(startAngleDegreee)), centerY - (double)radius * Math.sin(Math.toRadians(startAngleDegreee)));
        Point2D.Double ctrl1 = new Point2D.Double(centerX - (double)(radius / 3), centerY - (double)(radius / 2));
        Point2D.Double ctrl2 = new Point2D.Double(centerX + (double)(radius / 3), centerY);
        CubicCurve2D.Double cubicCurve = new CubicCurve2D.Double(((Point2D)p1).getX(), ((Point2D)p1).getY(), ((Point2D)ctrl1).getX(), ((Point2D)ctrl1).getY(), ((Point2D)ctrl2).getX(), ((Point2D)ctrl2).getY(), ((Point2D)p2).getX(), ((Point2D)p2).getY());
        GeneralPath path = new GeneralPath();
        path.append(arc2d, false);
        path.append(cubicCurve, true);
        path.closePath();
        Point2D.Double pG1 = new Point2D.Double(path.getBounds().getX() + path.getBounds().getWidth(), path.getBounds().getY() + path.getBounds().getHeight() / 2.0);
        Point2D.Double pG2 = new Point2D.Double(path.getBounds().getX(), path.getBounds().getY() + path.getBounds().getHeight() / 2.0);
        GradientPaint gPaint = new GradientPaint(pG1, new Color(255, 255, 255, 120), pG2, new Color(255, 255, 255, 30));
        g2d.setPaint(gPaint);
        g2d.fill(path);
    }
}

