/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.capture;

import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.jensoft.core.device.ContextEntry;
import org.jensoft.core.plugin.capture.CapturePlugin;
import org.jensoft.core.sharedicon.SharedIcon;
import org.jensoft.core.sharedicon.common.Common;

public class CaptureDefaultDeviceContext
extends ContextEntry<CapturePlugin> {
    private JMenu captureMenu;
    private ImageIcon captureIcon = SharedIcon.getCommon(Common.CAPTURE);
    private ImageIcon formatIcon = SharedIcon.getCommon(Common.ITEM);

    @Override
    public void buildContext() {
        this.captureMenu = new JMenu("Capture");
        this.captureMenu.setIcon(this.captureIcon);
        String[] f = ImageIO.getWriterFormatNames();
        TreeSet<String> formatSet = new TreeSet<String>();
        for (String s : f) {
            formatSet.add(s.toLowerCase());
        }
        String[] formats = formatSet.toArray(new String[0]);
        for (int i = 0; i < formats.length; ++i) {
            JMenuItem capureFormat = new JMenuItem(formats[i]);
            capureFormat.addActionListener(((CapturePlugin)this.getHost()).getCaptureAction(formats[i]));
            capureFormat.setIcon(this.formatIcon);
            this.captureMenu.add(capureFormat);
        }
        this.setGroup("capture");
        this.setItem(this.captureMenu);
    }

    @Override
    public boolean isCompatiblePlugin() {
        return this.getHost() != null && this.getHost() instanceof CapturePlugin;
    }
}

