/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.capture;

import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class CapturePlugin
extends AbstractPlugin {
    public CapturePlugin() {
        this.setName("CapturePlugin");
    }

    public final void captureViewAsImageFile(String dir, String fileName, int width, int height, ViewImageFormat viewImageFormat) throws IOException {
        File rootDir = new File(dir);
        rootDir.mkdirs();
        if (viewImageFormat == null) {
            viewImageFormat = ViewImageFormat.Png;
        }
        if (fileName == null) {
            fileName = "jensoft-view-capture." + viewImageFormat.getFormat();
        } else if (!fileName.endsWith("." + viewImageFormat.getFormat()) || !fileName.endsWith("." + viewImageFormat.getFormat().toLowerCase())) {
            fileName = fileName + "." + viewImageFormat.getFormat().toLowerCase();
        }
        String imageFilePath = dir + File.separator + fileName;
        File saveFile = new File(imageFilePath);
        BufferedImage viewImage = this.getProjection().getView().createViewEmitter().getImageView(width, height);
        viewImage.flush();
        ImageIO.write((RenderedImage)viewImage, viewImageFormat.getFormat(), saveFile);
    }

    public final BufferedImage captureViewAsImage(int width, int height, ViewImageFormat viewImageFormat) {
        BufferedImage viewImage = this.getProjection().getView().createViewEmitter().getImageView(width, height);
        viewImage.flush();
        return viewImage;
    }

    public CaptureAction getCaptureAction(ViewImageFormat format) {
        return new CaptureAction(format.getFormat());
    }

    public CaptureAction getCaptureAction(String format) {
        return new CaptureAction(format);
    }

    @Override
    protected void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
    }

    class CaptureAction
    implements ActionListener {
        private String format;

        public CaptureAction(String format) {
            this.format = format;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                View v2d = CapturePlugin.this.getProjection().getView();
                BufferedImage viewImage = CapturePlugin.this.getProjection().getView().createViewEmitter().getImageView(v2d.getWidth(), v2d.getHeight());
                viewImage.flush();
                File saveFile = new File("savedimage." + this.format);
                JFileChooser chooser = new JFileChooser();
                chooser.setSelectedFile(saveFile);
                int rval = chooser.showSaveDialog(CapturePlugin.this.getProjection().getView());
                if (rval == 0) {
                    saveFile = chooser.getSelectedFile();
                    try {
                        ImageIO.write((RenderedImage)viewImage, this.format, saveFile);
                    }
                    catch (IOException ex) {}
                }
            }
            catch (HeadlessException e1) {
                e1.printStackTrace();
            }
        }
    }

    public static enum ViewImageFormat {
        Png("PNG"),
        Bmp("BMP"),
        Jpeg("JPEG"),
        Wbmp("WBMP"),
        Gif("GIF");

        private String format;

        private ViewImageFormat(String format) {
            this.format = format;
        }

        public String getFormat() {
            return this.format;
        }
    }
}

