/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.components;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.components.DeviceComponent;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.projection.ProjectionAdapter;
import org.jensoft.core.projection.ProjectionEvent;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class ComponentsPlugin
extends AbstractPlugin {
    private List<DeviceComponent> userComponents;
    boolean init = false;
    int count = 0;

    public ComponentsPlugin() {
        this.setName("ComponentsPlugin");
        this.userComponents = new ArrayList<DeviceComponent>();
    }

    @Override
    public void onProjectionRegister() {
        super.onProjectionRegister();
        this.getProjection().addProjectionListener(new ProjectionAdapter(){

            @Override
            public void projectionBoundChanged(ProjectionEvent w2dEvent) {
                ComponentsPlugin.this.project();
            }
        });
    }

    private void project() {
        for (DeviceComponent uc : this.userComponents) {
            Projection w2d = this.getProjection();
            Point2D deviceLocation = w2d.userToPixel(new Point2D.Double(uc.getUserLocation().getX(), uc.getUserLocation().getY()));
            uc.getComponent().setLocation((int)deviceLocation.getX(), (int)deviceLocation.getY());
        }
    }

    public void addComponent(DeviceComponent label) {
        this.userComponents.add(label);
    }

    public void removeComponent(DeviceComponent label) {
        this.userComponents.remove(label);
    }

    @Override
    protected void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
        if (!this.init) {
            this.project();
            for (DeviceComponent component : this.userComponents) {
                component.getComponent().setBounds((int)component.getComponent().getLocation().getX(), (int)component.getComponent().getLocation().getY(), (int)component.getComponent().getPreferredSize().getWidth(), (int)component.getComponent().getPreferredSize().getHeight());
                this.getProjection().getView().getDevice2D().remove(component.getComponent());
                this.getProjection().getView().getDevice2D().add(component.getComponent());
            }
        }
    }
}

