/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut2d;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.graphics.Antialiasing;
import org.jensoft.core.graphics.Dithering;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.donut2d.Donut2D;
import org.jensoft.core.plugin.donut2d.Donut2DEvent;
import org.jensoft.core.plugin.donut2d.Donut2DListener;
import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.plugin.donut2d.painter.label.AbstractDonut2DSliceLabel;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class Donut2DPlugin
extends AbstractPlugin
implements AbstractPlugin.OnClickListener,
AbstractPlugin.OnEnterListener,
AbstractPlugin.OnExitListener,
AbstractPlugin.OnPressListener,
AbstractPlugin.OnReleaseListener,
AbstractPlugin.OnMoveListener,
AbstractPlugin.OnDragListener {
    private List<Donut2D> donuts;

    public Donut2DPlugin() {
        this.setName("Donut2DPlugin");
        this.setAntialiasing(Antialiasing.On);
        this.setTextAntialising(TextAntialiasing.On);
        this.setDithering(Dithering.On);
        this.setPriority(100);
        this.donuts = new ArrayList<Donut2D>();
        this.setOnMoveListener(this);
        this.setOnClickListener(this);
        this.setOnReleaseListener(this);
        this.setOnPressListener(this);
        this.setOnDragListener(this);
    }

    public void addDonut(Donut2D donut) {
        donut.setHostPlugin(this);
        this.donuts.add(donut);
    }

    public void removeDonut(Donut2D donut) {
        donut.setHostPlugin(null);
        this.donuts.remove(donut);
    }

    public List<Donut2D> getDonuts() {
        return this.donuts;
    }

    private void solvePluginGeometry() {
        for (int i = 0; i < this.donuts.size(); ++i) {
            Donut2D d = this.donuts.get(i);
            d.solveGeometry();
        }
    }

    @Override
    protected void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart != ViewPart.Device) {
            return;
        }
        this.solvePluginGeometry();
        for (int i = 0; i < this.donuts.size(); ++i) {
            Donut2D donut2D = this.donuts.get(i);
            if (donut2D.getDonut2DFill() != null) {
                donut2D.getDonut2DFill().paintDonut2D(g2d, donut2D);
            }
            if (donut2D.getDonut2DDraw() != null) {
                donut2D.getDonut2DDraw().paintDonut2D(g2d, donut2D);
            }
            if (donut2D.getDonut2DEffect() != null) {
                donut2D.getDonut2DEffect().paintDonut2D(g2d, donut2D);
            }
            List<Donut2DSlice> slices = donut2D.getSlices();
            for (Donut2DSlice donut2DSlice : slices) {
                for (AbstractDonut2DSliceLabel label : donut2DSlice.getSliceLabels()) {
                    label.paintDonut2DSlice(g2d, donut2D, donut2DSlice);
                }
            }
        }
    }

    @Override
    public void onRelease(MouseEvent me) {
        for (Donut2D donut2d : this.donuts) {
            for (Donut2DSlice slice : donut2d.getSlices()) {
                if (slice.getSlicePath() == null || !slice.getSlicePath().contains(me.getX(), me.getY()) || !slice.isLockEnter()) continue;
                this.fireDonut2DReleased(slice);
            }
        }
    }

    @Override
    public void onPress(MouseEvent me) {
        for (Donut2D donut2d : this.donuts) {
            for (Donut2DSlice slice : donut2d.getSlices()) {
                if (slice.getSlicePath() == null || !slice.getSlicePath().contains(me.getX(), me.getY()) || !slice.isLockEnter()) continue;
                this.fireDonut2DPressed(slice);
                return;
            }
        }
    }

    @Override
    public void onExit(MouseEvent me) {
    }

    @Override
    public void onEnter(MouseEvent me) {
    }

    @Override
    public void onClick(MouseEvent me) {
        for (Donut2D donut2d : this.donuts) {
            for (Donut2DSlice slice : donut2d.getSlices()) {
                if (slice.getSlicePath() == null || !slice.getSlicePath().contains(me.getX(), me.getY()) || !slice.isLockEnter()) continue;
                this.fireDonut2DClicked(slice);
            }
        }
    }

    @Override
    public void onMove(MouseEvent me) {
        for (Donut2D donut2d : this.donuts) {
            for (Donut2DSlice slice : donut2d.getSlices()) {
                this.donut2DEnterExitTracker(slice, me.getX(), me.getY());
            }
        }
    }

    @Override
    public void onDrag(MouseEvent me) {
        for (Donut2D donut2d : this.donuts) {
            for (Donut2DSlice slice : donut2d.getSlices()) {
                this.donut2DEnterExitTracker(slice, me.getX(), me.getY());
            }
        }
    }

    private void donut2DEnterExitTracker(Donut2DSlice slice, int x, int y) {
        if (slice == null || slice.getSlicePath() == null) {
            return;
        }
        if (slice.getSlicePath().contains(x, y) && !slice.isLockEnter()) {
            slice.lockEnter();
            this.fireDonut2DEntered(slice);
        } else if (!slice.getSlicePath().contains(x, y) && slice.isLockEnter()) {
            slice.unlockEnter();
            this.fireDonut2DExited(slice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDonut2DEntered(Donut2DSlice slice) {
        Object[] listeners;
        Object[] objectArray = listeners = slice.getHost().getDonut2DListenerList().getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != Donut2DListener.class) continue;
                ((Donut2DListener)listeners[i + 1]).donut2DSliceEntered(new Donut2DEvent(slice));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDonut2DExited(Donut2DSlice slice) {
        Object[] listeners;
        Object[] objectArray = listeners = slice.getHost().getDonut2DListenerList().getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != Donut2DListener.class) continue;
                ((Donut2DListener)listeners[i + 1]).donut2DSliceExited(new Donut2DEvent(slice));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDonut2DClicked(Donut2DSlice slice) {
        Object[] listeners;
        Object[] objectArray = listeners = slice.getHost().getDonut2DListenerList().getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != Donut2DListener.class) continue;
                ((Donut2DListener)listeners[i + 1]).donut2DSliceClicked(new Donut2DEvent(slice));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDonut2DPressed(Donut2DSlice slice) {
        Object[] listeners;
        Object[] objectArray = listeners = slice.getHost().getDonut2DListenerList().getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != Donut2DListener.class) continue;
                ((Donut2DListener)listeners[i + 1]).donut2DSlicePressed(new Donut2DEvent(slice));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDonut2DReleased(Donut2DSlice slice) {
        Object[] listeners;
        Object[] objectArray = listeners = slice.getHost().getDonut2DListenerList().getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != Donut2DListener.class) continue;
                ((Donut2DListener)listeners[i + 1]).donut2DSliceReleased(new Donut2DEvent(slice));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

