/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut2d;

import java.awt.Color;
import java.awt.Font;
import java.util.List;
import org.jensoft.core.drawable.text.TextPath;
import org.jensoft.core.plugin.Toolkit;
import org.jensoft.core.plugin.donut2d.Donut2D;
import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.plugin.donut2d.painter.fill.Donut2DDefaultFill;
import org.jensoft.core.plugin.donut2d.painter.label.AbstractDonut2DSliceLabel;
import org.jensoft.core.plugin.donut2d.painter.label.Donut2DBorderLabel;
import org.jensoft.core.plugin.donut2d.painter.label.Donut2DPathLabel;
import org.jensoft.core.plugin.donut2d.painter.label.Donut2DRadialLabel;

public class Donut2DToolkit
extends Toolkit {
    public static Donut2D createDonut2D(String name, double centerX, double centerY, double innerRadius, double outerRadius) {
        Donut2D donut2D = new Donut2D();
        donut2D.setName(name);
        donut2D.setNature(Donut2D.Donut2DNature.User);
        donut2D.setCenterX(centerX);
        donut2D.setCenterY(centerY);
        donut2D.setInnerRadius(innerRadius);
        donut2D.setOuterRadius(outerRadius);
        donut2D.setExplose(0.0);
        donut2D.setDonut2DFill(new Donut2DDefaultFill());
        return donut2D;
    }

    public static Donut2D createDonut2D(String name, double innerRadius, double outerRadius) {
        Donut2D donut2D = new Donut2D();
        donut2D.setName(name);
        donut2D.setNature(Donut2D.Donut2DNature.User);
        donut2D.setCenterX(0.0);
        donut2D.setCenterY(0.0);
        donut2D.setInnerRadius(innerRadius);
        donut2D.setOuterRadius(outerRadius);
        donut2D.setExplose(0.0);
        donut2D.setDonut2DFill(new Donut2DDefaultFill());
        return donut2D;
    }

    public static Donut2DSlice createDonut2DSlice(String name, Color color, double value, double divergence) {
        Donut2DSlice slice = new Donut2DSlice(name, color);
        slice.setValue(value);
        slice.setDivergence(divergence);
        return slice;
    }

    public static Donut2DRadialLabel createRadialLabel(String label) {
        return new Donut2DRadialLabel(label);
    }

    public static Donut2DRadialLabel createRadialLabel(String label, int offsetRadius) {
        Donut2DRadialLabel radialLabel = new Donut2DRadialLabel(label);
        radialLabel.setOffsetRadius(offsetRadius);
        return radialLabel;
    }

    public static Donut2DRadialLabel createRadialLabel(String label, Color labelColor) {
        return new Donut2DRadialLabel(label, labelColor);
    }

    public static Donut2DRadialLabel createRadialLabel(String label, Color labelColor, int offsetRadius) {
        Donut2DRadialLabel radialLabel = new Donut2DRadialLabel(label, labelColor);
        radialLabel.setOffsetRadius(offsetRadius);
        return radialLabel;
    }

    public static Donut2DRadialLabel createRadialLabel(String label, Color labelColor, Font labelFont) {
        return new Donut2DRadialLabel(label, labelColor, labelFont);
    }

    public static Donut2DRadialLabel createRadialLabel(String label, Color labelColor, Font labelFont, int offsetRadius) {
        Donut2DRadialLabel radialLabel = new Donut2DRadialLabel(label, labelColor, labelFont);
        radialLabel.setOffsetRadius(offsetRadius);
        return radialLabel;
    }

    public static Donut2DRadialLabel createRadialLabel(String label, Color labelColor, Font labelFont, int offsetRadius, AbstractDonut2DSliceLabel.Style style) {
        Donut2DRadialLabel radialLabel = new Donut2DRadialLabel(label, labelColor, labelFont);
        radialLabel.setOffsetRadius(offsetRadius);
        radialLabel.setStyle(style);
        return radialLabel;
    }

    public static Donut2DRadialLabel createRadialLabel(String label, Color labelColor, Font labelFont, int offsetRadius, int outlineRound, AbstractDonut2DSliceLabel.Style style) {
        Donut2DRadialLabel radialLabel = new Donut2DRadialLabel(label, labelColor, labelFont);
        radialLabel.setOffsetRadius(offsetRadius);
        radialLabel.setOutlineRound(outlineRound);
        radialLabel.setStyle(style);
        return radialLabel;
    }

    public static Donut2DBorderLabel createBorderLabel(String label) {
        return new Donut2DBorderLabel(label);
    }

    public static Donut2DBorderLabel createBorderLabel(String label, Color labelColor) {
        return new Donut2DBorderLabel(label, labelColor);
    }

    public static Donut2DBorderLabel createBorderLabel(String label, Color labelColor, Font labelFont) {
        return new Donut2DBorderLabel(label, labelColor, labelFont);
    }

    public static Donut2DBorderLabel createBorderLabel(String label, Color labelColor, Font labelFont, int outlineRound) {
        Donut2DBorderLabel l = new Donut2DBorderLabel(label, labelColor, labelFont);
        l.setOutlineRound(outlineRound);
        return l;
    }

    public static Donut2DBorderLabel createBorderLabel(String label, Color labelColor, Font labelFont, int outlineRound, int margin) {
        Donut2DBorderLabel l = new Donut2DBorderLabel(label, labelColor, labelFont);
        l.setOutlineRound(outlineRound);
        l.setMargin(margin);
        return l;
    }

    public static Donut2DBorderLabel createBorderLabel(String label, Color labelColor, Font labelFont, int outlineRound, AbstractDonut2DSliceLabel.Style style) {
        Donut2DBorderLabel l = new Donut2DBorderLabel(label, labelColor, labelFont);
        l.setOutlineRound(outlineRound);
        l.setStyle(style);
        return l;
    }

    public static Donut2DPathLabel createPathLabel(String label, Color labelColor) {
        Donut2DPathLabel Donut2DPathLabel2 = new Donut2DPathLabel(label, labelColor);
        return Donut2DPathLabel2;
    }

    public static Donut2DPathLabel createPathLabel(String label, Color labelColor, int divergence) {
        Donut2DPathLabel Donut2DPathLabel2 = new Donut2DPathLabel(label, labelColor);
        Donut2DPathLabel2.setDivergence(divergence);
        return Donut2DPathLabel2;
    }

    public static Donut2DPathLabel createPathLabel(String label, Color labelColor, Font labelFont) {
        Donut2DPathLabel Donut2DPathLabel2 = new Donut2DPathLabel(label, labelColor, labelFont);
        return Donut2DPathLabel2;
    }

    public static Donut2DPathLabel createPathLabel(String label, Color labelColor, Font labelFont, int divergence) {
        Donut2DPathLabel Donut2DPathLabel2 = new Donut2DPathLabel(label, labelColor, labelFont);
        Donut2DPathLabel2.setDivergence(divergence);
        return Donut2DPathLabel2;
    }

    public static Donut2DPathLabel createPathLabel(String label, Color labelColor, Font labelFont, TextPath.TextPosition textPosition) {
        Donut2DPathLabel Donut2DPathLabel2 = new Donut2DPathLabel(label, labelColor, labelFont);
        Donut2DPathLabel2.setTextPosition(textPosition);
        return Donut2DPathLabel2;
    }

    public static Donut2DPathLabel createPathLabel(String label, Color labelColor, Font labelFont, TextPath.TextPosition textPosition, TextPath.PathSide pathSide) {
        Donut2DPathLabel Donut2DPathLabel2 = new Donut2DPathLabel(label, labelColor, labelFont);
        Donut2DPathLabel2.setTextPosition(textPosition);
        Donut2DPathLabel2.setPathSide(pathSide);
        return Donut2DPathLabel2;
    }

    public static Donut2DPathLabel createPathLabel(String label, Color labelColor, Font labelFont, TextPath.TextPosition textPosition, int divergence) {
        Donut2DPathLabel Donut2DPathLabel2 = new Donut2DPathLabel(label, labelColor, labelFont);
        Donut2DPathLabel2.setTextPosition(textPosition);
        Donut2DPathLabel2.setDivergence(divergence);
        return Donut2DPathLabel2;
    }

    public static void pushSlices(Donut2D donut2D, Donut2DSlice ... slices) {
        for (int i = 0; i < slices.length; ++i) {
            donut2D.addSlice(slices[i]);
        }
    }

    public static void pushSlices(Donut2D donut2D, List<Donut2DSlice> slices) {
        for (Donut2DSlice slice : slices) {
            donut2D.addSlice(slice);
        }
    }
}

