/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut2d.animator;

import java.util.HashMap;
import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.plugin.donut2d.animator.AbstractDonut2DAnimator;

public class Donut2DAlphaAnimator
extends AbstractDonut2DAnimator {
    private int sleep = 40;
    private float alphaMin = 0.0f;
    private float alphaMax = 1.0f;
    private HashMap<Donut2DSlice, AlphaTransition> transitions = new HashMap();
    private Thread t;

    public Donut2DAlphaAnimator() {
    }

    public Donut2DAlphaAnimator(float alphaMin, float alphaMax) {
        this.alphaMin = alphaMin;
        this.alphaMax = alphaMax;
    }

    public Donut2DAlphaAnimator(float alphaMin, float alphaMax, int sleep) {
        this.alphaMin = alphaMin;
        this.alphaMax = alphaMax;
        this.sleep = sleep;
    }

    public float getAlphaMin() {
        return this.alphaMin;
    }

    public void setAlphaMin(float alphaMin) {
        this.alphaMin = alphaMin;
    }

    public float getAlphaMax() {
        return this.alphaMax;
    }

    public void setAlphaMax(float alphaMax) {
        this.alphaMax = alphaMax;
    }

    @Override
    protected void onPressed(Donut2DSlice slice) {
        if (this.t == null) {
            this.t = new Thread(this.getAnimator(slice));
            this.t.start();
        } else if (!this.t.isAlive()) {
            this.t = new Thread(this.getAnimator(slice));
            this.t.start();
        }
    }

    public int getSleep() {
        return this.sleep;
    }

    public void setSleep(int sleep) {
        this.sleep = sleep;
    }

    @Override
    public Runnable getAnimator(Donut2DSlice slice) {
        AlphaTransition at = this.transitions.get(slice);
        if (at == null) {
            AlphaTransition transition = new AlphaTransition(slice);
            this.transitions.put(slice, transition);
        }
        return this.transitions.get(slice);
    }

    public class AlphaTransition
    implements Runnable {
        private Donut2DSlice slice;
        private TransitionState transitionState;

        public AlphaTransition(Donut2DSlice slice) {
            this.slice = slice;
            this.transitionState = TransitionState.Off;
        }

        @Override
        public void run() {
            float step = 10.0f;
            try {
                if (this.transitionState == TransitionState.Off) {
                    float pas = (Donut2DAlphaAnimator.this.alphaMax - Donut2DAlphaAnimator.this.alphaMin) / new Float(step).floatValue();
                    int i = 0;
                    while ((float)i <= step) {
                        float alpha = Donut2DAlphaAnimator.this.alphaMax - (float)i * pas;
                        if (alpha < Donut2DAlphaAnimator.this.alphaMin) {
                            alpha = Donut2DAlphaAnimator.this.alphaMin;
                        }
                        this.slice.setAlpha(alpha);
                        Donut2DAlphaAnimator.this.getView(this.slice).repaintDevice();
                        Thread.sleep(Donut2DAlphaAnimator.this.sleep);
                        ++i;
                    }
                    this.slice.setAlpha(Donut2DAlphaAnimator.this.alphaMin);
                    Donut2DAlphaAnimator.this.getView(this.slice).repaintDevice();
                    this.transitionState = TransitionState.On;
                } else if (this.transitionState == TransitionState.On) {
                    float pas = (Donut2DAlphaAnimator.this.alphaMax - Donut2DAlphaAnimator.this.alphaMin) / new Float(step).floatValue();
                    int i = 0;
                    while ((float)i <= step) {
                        float alpha = Donut2DAlphaAnimator.this.alphaMin + (float)i * pas;
                        if (alpha > Donut2DAlphaAnimator.this.alphaMax) {
                            alpha = Donut2DAlphaAnimator.this.alphaMax;
                        }
                        this.slice.setAlpha(alpha);
                        Donut2DAlphaAnimator.this.getView(this.slice).repaintDevice();
                        Thread.sleep(Donut2DAlphaAnimator.this.sleep);
                        ++i;
                    }
                    this.slice.setAlpha(Donut2DAlphaAnimator.this.alphaMax);
                    Donut2DAlphaAnimator.this.getView(this.slice).repaintDevice();
                    this.transitionState = TransitionState.Off;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static enum TransitionState {
        On,
        Off;

    }
}

